<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: GSS_MonedaMast.xml */
/* Generado: 2020-08-18 04:21:26 */

/* Mantenimiento de los registros de la tabla GSS_MonedaMast */
abstract class BaseGSS_MonedaMastDP extends GSS_MonedaMastBV
{
    /* Constructor ( Establece los valores desde un objeto GSS_MonedaMastBN ) */
    public function __construct( GSS_MonedaMastBN $o_GSS_MonedaMastBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_GSS_MonedaMastBN ) )
        {
            $this->setByBN( $o_GSS_MonedaMastBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto GSS_MonedaMastBN */
    public function setByBN( GSS_MonedaMastBN $o_GSS_MonedaMastBN )
    {
        if ( !is_null( $o_GSS_MonedaMastBN->getIdMoneda() ) )
        {
            $this->setIdMoneda( $o_GSS_MonedaMastBN->getIdMoneda() );
        }
        if ( !is_null( $o_GSS_MonedaMastBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_GSS_MonedaMastBN->getDescripcion() );
        }
        if ( !is_null( $o_GSS_MonedaMastBN->getSigla() ) )
        {
            $this->setSigla( $o_GSS_MonedaMastBN->getSigla() );
        }
        if ( !is_null( $o_GSS_MonedaMastBN->getCodigoFiscal() ) )
        {
            $this->setCodigoFiscal( $o_GSS_MonedaMastBN->getCodigoFiscal() );
        }
        if ( !is_null( $o_GSS_MonedaMastBN->getEstado() ) )
        {
            $this->setEstado( $o_GSS_MonedaMastBN->getEstado() );
        }
        if ( !is_null( $o_GSS_MonedaMastBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_GSS_MonedaMastBN->getFechaCreacion() );
        }
        if ( !is_null( $o_GSS_MonedaMastBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_GSS_MonedaMastBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_GSS_MonedaMastBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_GSS_MonedaMastBN->getFechaModificacion() );
        }
        if ( !is_null( $o_GSS_MonedaMastBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_GSS_MonedaMastBN->getUsuarioModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_GSS_MonedaMastFN = new GSS_MonedaMastFN();
        $o_GSS_MonedaMastBN = $o_GSS_MonedaMastFN->selectByPk( $this->getIdMoneda() );
        if ( is_null( $o_GSS_MonedaMastBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO GSS_MonedaMast ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdMoneda() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdMoneda";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdMoneda()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Descripcion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getSigla() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Sigla";
                $s_SQLQuery2 .= $s_Separator."'".$this->getSigla()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCodigoFiscal() ) )
            {
                $s_SQLQuery1 .= $s_Separator."CodigoFiscal";
                $s_SQLQuery2 .= $s_Separator."'".$this->getCodigoFiscal()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE GSS_MonedaMast SET ";
            $s_Separator = "";
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery .= $s_Separator."Descripcion = '".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getSigla() ) )
            {
                $s_SQLQuery .= $s_Separator."Sigla = '".$this->getSigla()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCodigoFiscal() ) )
            {
                $s_SQLQuery .= $s_Separator."CodigoFiscal = '".$this->getCodigoFiscal()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdMoneda = '".$this->getIdMoneda()."';";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM GSS_MonedaMast WHERE  IdMoneda = '".$this->getIdMoneda()."';";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>