<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: GSS_FeriadosMast.xml */
/* Generado: 2020-08-18 04:21:26 */

/* Mantenimiento de los registros de la tabla GSS_FeriadosMast */
abstract class BaseGSS_FeriadosMastDP extends GSS_FeriadosMastBV
{
    /* Constructor ( Establece los valores desde un objeto GSS_FeriadosMastBN ) */
    public function __construct( GSS_FeriadosMastBN $o_GSS_FeriadosMastBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_GSS_FeriadosMastBN ) )
        {
            $this->setByBN( $o_GSS_FeriadosMastBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto GSS_FeriadosMastBN */
    public function setByBN( GSS_FeriadosMastBN $o_GSS_FeriadosMastBN )
    {
        if ( !is_null( $o_GSS_FeriadosMastBN->getIdFeriado() ) )
        {
            $this->setIdFeriado( $o_GSS_FeriadosMastBN->getIdFeriado() );
        }
        if ( !is_null( $o_GSS_FeriadosMastBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_GSS_FeriadosMastBN->getIdCompania() );
        }
        if ( !is_null( $o_GSS_FeriadosMastBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_GSS_FeriadosMastBN->getIdSucursal() );
        }
        if ( !is_null( $o_GSS_FeriadosMastBN->getAnio() ) )
        {
            $this->setAnio( $o_GSS_FeriadosMastBN->getAnio() );
        }
        if ( !is_null( $o_GSS_FeriadosMastBN->getMes() ) )
        {
            $this->setMes( $o_GSS_FeriadosMastBN->getMes() );
        }
        if ( !is_null( $o_GSS_FeriadosMastBN->getDia() ) )
        {
            $this->setDia( $o_GSS_FeriadosMastBN->getDia() );
        }
        if ( !is_null( $o_GSS_FeriadosMastBN->getDiaNumero() ) )
        {
            $this->setDiaNumero( $o_GSS_FeriadosMastBN->getDiaNumero() );
        }
        if ( !is_null( $o_GSS_FeriadosMastBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_GSS_FeriadosMastBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_GSS_FeriadosMastBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_GSS_FeriadosMastBN->getFechaCreacion() );
        }
        if ( !is_null( $o_GSS_FeriadosMastBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_GSS_FeriadosMastBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_GSS_FeriadosMastBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_GSS_FeriadosMastBN->getFechaModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_GSS_FeriadosMastFN = new GSS_FeriadosMastFN();
        $o_GSS_FeriadosMastBN = $o_GSS_FeriadosMastFN->selectByPk( $this->getIdFeriado() );
        if ( is_null( $o_GSS_FeriadosMastBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO GSS_FeriadosMast ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdFeriado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdFeriado";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdFeriado()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdCompania() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCompania";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdCompania()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdSucursal() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdSucursal";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdSucursal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getAnio() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Anio";
                $s_SQLQuery2 .= $s_Separator."'".$this->getAnio()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMes() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Mes";
                $s_SQLQuery2 .= $s_Separator."'".$this->getMes()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDia() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Dia";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDia()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDiaNumero() ) )
            {
                $s_SQLQuery1 .= $s_Separator."DiaNumero";
                $s_SQLQuery2 .= $s_Separator."".$this->getDiaNumero()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE GSS_FeriadosMast SET ";
            $s_Separator = "";
            if ( !is_null( $this->getIdCompania() ) )
            {
                $s_SQLQuery .= $s_Separator."IdCompania = ".$this->getIdCompania()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdSucursal() ) )
            {
                $s_SQLQuery .= $s_Separator."IdSucursal = ".$this->getIdSucursal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getAnio() ) )
            {
                $s_SQLQuery .= $s_Separator."Anio = '".$this->getAnio()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMes() ) )
            {
                $s_SQLQuery .= $s_Separator."Mes = '".$this->getMes()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDia() ) )
            {
                $s_SQLQuery .= $s_Separator."Dia = '".$this->getDia()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDiaNumero() ) )
            {
                $s_SQLQuery .= $s_Separator."DiaNumero = ".$this->getDiaNumero()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdFeriado = ".$this->getIdFeriado().";";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM GSS_FeriadosMast WHERE  IdFeriado = ".$this->getIdFeriado().";";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>