<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: GSS_Detraccion.xml */
/* Generado: 2021-10-09 18:38:22 */

/* Mantenimiento de los registros de la tabla GSS_Detraccion */
abstract class BaseGSS_DetraccionDP extends GSS_DetraccionBV
{
    /* Constructor ( Establece los valores desde un objeto GSS_DetraccionBN ) */
    public function __construct( GSS_DetraccionBN $o_GSS_DetraccionBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_GSS_DetraccionBN ) )
        {
            $this->setByBN( $o_GSS_DetraccionBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto GSS_DetraccionBN */
    public function setByBN( GSS_DetraccionBN $o_GSS_DetraccionBN )
    {
        if ( !is_null( $o_GSS_DetraccionBN->getIdDetraccion() ) )
        {
            $this->setIdDetraccion( $o_GSS_DetraccionBN->getIdDetraccion() );
        }
        if ( !is_null( $o_GSS_DetraccionBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_GSS_DetraccionBN->getDescripcion() );
        }
        if ( !is_null( $o_GSS_DetraccionBN->getCodigoSunat() ) )
        {
            $this->setCodigoSunat( $o_GSS_DetraccionBN->getCodigoSunat() );
        }
        if ( !is_null( $o_GSS_DetraccionBN->getCodigoSunatPr() ) )
        {
            $this->setCodigoSunatPr( $o_GSS_DetraccionBN->getCodigoSunatPr() );
        }
        if ( !is_null( $o_GSS_DetraccionBN->getPorcentaje() ) )
        {
            $this->setPorcentaje( $o_GSS_DetraccionBN->getPorcentaje() );
        }
        if ( !is_null( $o_GSS_DetraccionBN->getMontoMinimo() ) )
        {
            $this->setMontoMinimo( $o_GSS_DetraccionBN->getMontoMinimo() );
        }
        if ( !is_null( $o_GSS_DetraccionBN->getEstado() ) )
        {
            $this->setEstado( $o_GSS_DetraccionBN->getEstado() );
        }
        if ( !is_null( $o_GSS_DetraccionBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_GSS_DetraccionBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_GSS_DetraccionBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_GSS_DetraccionBN->getFechaCreacion() );
        }
        if ( !is_null( $o_GSS_DetraccionBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_GSS_DetraccionBN->getFechaModificacion() );
        }
        if ( !is_null( $o_GSS_DetraccionBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_GSS_DetraccionBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_GSS_DetraccionBN->getFehaEliminacion() ) )
        {
            $this->setFehaEliminacion( $o_GSS_DetraccionBN->getFehaEliminacion() );
        }
        if ( !is_null( $o_GSS_DetraccionBN->getUsuarioEliminacion() ) )
        {
            $this->setUsuarioEliminacion( $o_GSS_DetraccionBN->getUsuarioEliminacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_GSS_DetraccionFN = new GSS_DetraccionFN();
        $o_GSS_DetraccionBN = $o_GSS_DetraccionFN->selectByPk( $this->getIdDetraccion() );
        if ( is_null( $o_GSS_DetraccionBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO GSS_Detraccion ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdDetraccion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdDetraccion";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdDetraccion()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Descripcion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCodigoSunat() ) )
            {
                $s_SQLQuery1 .= $s_Separator."CodigoSunat";
                $s_SQLQuery2 .= $s_Separator."'".$this->getCodigoSunat()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCodigoSunatPr() ) )
            {
                $s_SQLQuery1 .= $s_Separator."CodigoSunatPr";
                $s_SQLQuery2 .= $s_Separator."'".$this->getCodigoSunatPr()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPorcentaje() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Porcentaje";
                $s_SQLQuery2 .= $s_Separator."".$this->getPorcentaje()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoMinimo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MontoMinimo";
                $s_SQLQuery2 .= $s_Separator."".$this->getMontoMinimo()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFehaEliminacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FehaEliminacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFehaEliminacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioEliminacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioEliminacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioEliminacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE GSS_Detraccion SET ";
            $s_Separator = "";
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery .= $s_Separator."Descripcion = '".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCodigoSunat() ) )
            {
                $s_SQLQuery .= $s_Separator."CodigoSunat = '".$this->getCodigoSunat()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCodigoSunatPr() ) )
            {
                $s_SQLQuery .= $s_Separator."CodigoSunatPr = '".$this->getCodigoSunatPr()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPorcentaje() ) )
            {
                $s_SQLQuery .= $s_Separator."Porcentaje = ".$this->getPorcentaje()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoMinimo() ) )
            {
                $s_SQLQuery .= $s_Separator."MontoMinimo = ".$this->getMontoMinimo()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFehaEliminacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FehaEliminacion = '".$this->getFehaEliminacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioEliminacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioEliminacion = '".$this->getUsuarioEliminacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdDetraccion = ".$this->getIdDetraccion().";";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM GSS_Detraccion WHERE  IdDetraccion = ".$this->getIdDetraccion().";";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        return true;
    }

}
?>