<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: GSS_CentroCostos.xml */
/* Generado: 2020-11-17 02:28:04 */

/* Mantenimiento de los registros de la tabla GSS_CentroCostos */
abstract class BaseGSS_CentroCostosDP extends GSS_CentroCostosBV
{
    /* Constructor ( Establece los valores desde un objeto GSS_CentroCostosBN ) */
    public function __construct( GSS_CentroCostosBN $o_GSS_CentroCostosBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_GSS_CentroCostosBN ) )
        {
            $this->setByBN( $o_GSS_CentroCostosBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto GSS_CentroCostosBN */
    public function setByBN( GSS_CentroCostosBN $o_GSS_CentroCostosBN )
    {
        if ( !is_null( $o_GSS_CentroCostosBN->getIdCeCostos() ) )
        {
            $this->setIdCeCostos( $o_GSS_CentroCostosBN->getIdCeCostos() );
        }
        if ( !is_null( $o_GSS_CentroCostosBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_GSS_CentroCostosBN->getDescripcion() );
        }
        if ( !is_null( $o_GSS_CentroCostosBN->getCodigo() ) )
        {
            $this->setCodigo( $o_GSS_CentroCostosBN->getCodigo() );
        }
        if ( !is_null( $o_GSS_CentroCostosBN->getEstado() ) )
        {
            $this->setEstado( $o_GSS_CentroCostosBN->getEstado() );
        }
        if ( !is_null( $o_GSS_CentroCostosBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_GSS_CentroCostosBN->getFechaCreacion() );
        }
        if ( !is_null( $o_GSS_CentroCostosBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_GSS_CentroCostosBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_GSS_CentroCostosBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_GSS_CentroCostosBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_GSS_CentroCostosBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_GSS_CentroCostosBN->getFechaModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_GSS_CentroCostosFN = new GSS_CentroCostosFN();
        $o_GSS_CentroCostosBN = $o_GSS_CentroCostosFN->selectByPk( $this->getIdCeCostos() );
        if ( is_null( $o_GSS_CentroCostosBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO GSS_CentroCostos ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdCeCostos() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCeCostos";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdCeCostos()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Descripcion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCodigo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Codigo";
                $s_SQLQuery2 .= $s_Separator."'".$this->getCodigo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE GSS_CentroCostos SET ";
            $s_Separator = "";
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery .= $s_Separator."Descripcion = '".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCodigo() ) )
            {
                $s_SQLQuery .= $s_Separator."Codigo = '".$this->getCodigo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdCeCostos = ".$this->getIdCeCostos().";";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM GSS_CentroCostos WHERE  IdCeCostos = ".$this->getIdCeCostos().";";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>