<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: GSS_Auditoria.xml */
/* Generado: 2020-08-18 04:21:26 */

/* Mantenimiento de los registros de la tabla GSS_Auditoria */
abstract class BaseGSS_AuditoriaDP extends GSS_AuditoriaBV
{
    /* Constructor ( Establece los valores desde un objeto GSS_AuditoriaBN ) */
    public function __construct( GSS_AuditoriaBN $o_GSS_AuditoriaBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_GSS_AuditoriaBN ) )
        {
            $this->setByBN( $o_GSS_AuditoriaBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto GSS_AuditoriaBN */
    public function setByBN( GSS_AuditoriaBN $o_GSS_AuditoriaBN )
    {
        if ( !is_null( $o_GSS_AuditoriaBN->getIdAuditoria() ) )
        {
            $this->setIdAuditoria( $o_GSS_AuditoriaBN->getIdAuditoria() );
        }
        if ( !is_null( $o_GSS_AuditoriaBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_GSS_AuditoriaBN->getIdCompania() );
        }
        if ( !is_null( $o_GSS_AuditoriaBN->getModulo() ) )
        {
            $this->setModulo( $o_GSS_AuditoriaBN->getModulo() );
        }
        if ( !is_null( $o_GSS_AuditoriaBN->getSentencia() ) )
        {
            $this->setSentencia( $o_GSS_AuditoriaBN->getSentencia() );
        }
        if ( !is_null( $o_GSS_AuditoriaBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_GSS_AuditoriaBN->getFechaCreacion() );
        }
        if ( !is_null( $o_GSS_AuditoriaBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_GSS_AuditoriaBN->getUsuarioCreacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_GSS_AuditoriaFN = new GSS_AuditoriaFN();
            $s_SQLQuery1 = "INSERT INTO GSS_Auditoria ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdAuditoria() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdAuditoria";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdAuditoria()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdCompania() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCompania";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdCompania()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getModulo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Modulo";
                $s_SQLQuery2 .= $s_Separator."'".$this->getModulo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getSentencia() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Sentencia";
                $s_SQLQuery2 .= $s_Separator."'".$this->getSentencia()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE GSS_Auditoria SET ";
            $s_Separator = "";
            if ( !is_null( $this->getIdAuditoria() ) )
            {
                $s_SQLQuery .= $s_Separator."IdAuditoria = ".$this->getIdAuditoria()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdCompania() ) )
            {
                $s_SQLQuery .= $s_Separator."IdCompania = ".$this->getIdCompania()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getModulo() ) )
            {
                $s_SQLQuery .= $s_Separator."Modulo = '".$this->getModulo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getSentencia() ) )
            {
                $s_SQLQuery .= $s_Separator."Sentencia = '".$this->getSentencia()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE ;";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM GSS_Auditoria WHERE ;";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>