<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_Marca.xml */
/* Generado: 2020-08-18 04:21:24 */

/* Mantenimiento de los registros de la tabla ALM_Marca */
abstract class BaseALM_MarcaDP extends ALM_MarcaBV
{
    /* Constructor ( Establece los valores desde un objeto ALM_MarcaBN ) */
    public function __construct( ALM_MarcaBN $o_ALM_MarcaBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_ALM_MarcaBN ) )
        {
            $this->setByBN( $o_ALM_MarcaBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto ALM_MarcaBN */
    public function setByBN( ALM_MarcaBN $o_ALM_MarcaBN )
    {
        if ( !is_null( $o_ALM_MarcaBN->getIdMarca() ) )
        {
            $this->setIdMarca( $o_ALM_MarcaBN->getIdMarca() );
        }
        if ( !is_null( $o_ALM_MarcaBN->getDescripcionLocal() ) )
        {
            $this->setDescripcionLocal( $o_ALM_MarcaBN->getDescripcionLocal() );
        }
        if ( !is_null( $o_ALM_MarcaBN->getDescripcionIngles() ) )
        {
            $this->setDescripcionIngles( $o_ALM_MarcaBN->getDescripcionIngles() );
        }
        if ( !is_null( $o_ALM_MarcaBN->getPersona() ) )
        {
            $this->setPersona( $o_ALM_MarcaBN->getPersona() );
        }
        if ( !is_null( $o_ALM_MarcaBN->getEstado() ) )
        {
            $this->setEstado( $o_ALM_MarcaBN->getEstado() );
        }
        if ( !is_null( $o_ALM_MarcaBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_ALM_MarcaBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_ALM_MarcaBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_ALM_MarcaBN->getFechaModificacion() );
        }
        if ( !is_null( $o_ALM_MarcaBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_ALM_MarcaBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_ALM_MarcaBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_ALM_MarcaBN->getFechaCreacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_ALM_MarcaFN = new ALM_MarcaFN();
        $o_ALM_MarcaBN = $o_ALM_MarcaFN->selectByPk( $this->getIdMarca() );
        if ( is_null( $o_ALM_MarcaBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO ALM_Marca ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdMarca() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdMarca";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdMarca()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcionLocal() ) )
            {
                $s_SQLQuery1 .= $s_Separator."DescripcionLocal";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcionLocal()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcionIngles() ) )
            {
                $s_SQLQuery1 .= $s_Separator."DescripcionIngles";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcionIngles()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPersona() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Persona";
                $s_SQLQuery2 .= $s_Separator."".$this->getPersona()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE ALM_Marca SET ";
            $s_Separator = "";
            if ( !is_null( $this->getDescripcionLocal() ) )
            {
                $s_SQLQuery .= $s_Separator."DescripcionLocal = '".$this->getDescripcionLocal()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcionIngles() ) )
            {
                $s_SQLQuery .= $s_Separator."DescripcionIngles = '".$this->getDescripcionIngles()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPersona() ) )
            {
                $s_SQLQuery .= $s_Separator."Persona = ".$this->getPersona()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdMarca = '".$this->getIdMarca()."';";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM ALM_Marca WHERE  IdMarca = '".$this->getIdMarca()."';";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>