<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_Lote.xml */
/* Generado: 2021-11-07 23:55:52 */

/* Mantenimiento de los registros de la tabla ALM_Lote */
abstract class BaseALM_LoteDP extends ALM_LoteBV
{
    /* Constructor ( Establece los valores desde un objeto ALM_LoteBN ) */
    public function __construct( ALM_LoteBN $o_ALM_LoteBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_ALM_LoteBN ) )
        {
            $this->setByBN( $o_ALM_LoteBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto ALM_LoteBN */
    public function setByBN( ALM_LoteBN $o_ALM_LoteBN )
    {
        if ( !is_null( $o_ALM_LoteBN->getIdLote() ) )
        {
            $this->setIdLote( $o_ALM_LoteBN->getIdLote() );
        }
        if ( !is_null( $o_ALM_LoteBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_ALM_LoteBN->getIdCompania() );
        }
        if ( !is_null( $o_ALM_LoteBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_ALM_LoteBN->getIdSucursal() );
        }
        if ( !is_null( $o_ALM_LoteBN->getIdItem() ) )
        {
            $this->setIdItem( $o_ALM_LoteBN->getIdItem() );
        }
        if ( !is_null( $o_ALM_LoteBN->getProductoDescripcion() ) )
        {
            $this->setProductoDescripcion( $o_ALM_LoteBN->getProductoDescripcion() );
        }
        if ( !is_null( $o_ALM_LoteBN->getLoteNumero() ) )
        {
            $this->setLoteNumero( $o_ALM_LoteBN->getLoteNumero() );
        }
        if ( !is_null( $o_ALM_LoteBN->getFechaVencimiento() ) )
        {
            $this->setFechaVencimiento( $o_ALM_LoteBN->getFechaVencimiento() );
        }
        if ( !is_null( $o_ALM_LoteBN->getFechaOrigen() ) )
        {
            $this->setFechaOrigen( $o_ALM_LoteBN->getFechaOrigen() );
        }
        if ( !is_null( $o_ALM_LoteBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_ALM_LoteBN->getDescripcion() );
        }
        if ( !is_null( $o_ALM_LoteBN->getEstado() ) )
        {
            $this->setEstado( $o_ALM_LoteBN->getEstado() );
        }
        if ( !is_null( $o_ALM_LoteBN->getProveedorId() ) )
        {
            $this->setProveedorId( $o_ALM_LoteBN->getProveedorId() );
        }
        if ( !is_null( $o_ALM_LoteBN->getProveedorNombre() ) )
        {
            $this->setProveedorNombre( $o_ALM_LoteBN->getProveedorNombre() );
        }
        if ( !is_null( $o_ALM_LoteBN->getLoteNumeroProveedor() ) )
        {
            $this->setLoteNumeroProveedor( $o_ALM_LoteBN->getLoteNumeroProveedor() );
        }
        if ( !is_null( $o_ALM_LoteBN->getAnio() ) )
        {
            $this->setAnio( $o_ALM_LoteBN->getAnio() );
        }
        if ( !is_null( $o_ALM_LoteBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_ALM_LoteBN->getFechaCreacion() );
        }
        if ( !is_null( $o_ALM_LoteBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_ALM_LoteBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_ALM_LoteBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_ALM_LoteBN->getFechaModificacion() );
        }
        if ( !is_null( $o_ALM_LoteBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_ALM_LoteBN->getUsuarioModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_ALM_LoteFN = new ALM_LoteFN();
        $o_ALM_LoteBN = $o_ALM_LoteFN->selectByPk( $this->getIdLote() );
        if ( is_null( $o_ALM_LoteBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO ALM_Lote ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdLote() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdLote";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdLote()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdCompania() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCompania";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdCompania()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdSucursal() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdSucursal";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdSucursal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdItem() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdItem";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdItem()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getProductoDescripcion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ProductoDescripcion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getProductoDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getLoteNumero() ) )
            {
                $s_SQLQuery1 .= $s_Separator."LoteNumero";
                $s_SQLQuery2 .= $s_Separator."'".$this->getLoteNumero()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaVencimiento() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaVencimiento";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaVencimiento()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaOrigen() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaOrigen";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaOrigen()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Descripcion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getProveedorId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ProveedorId";
                $s_SQLQuery2 .= $s_Separator."".$this->getProveedorId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getProveedorNombre() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ProveedorNombre";
                $s_SQLQuery2 .= $s_Separator."'".$this->getProveedorNombre()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getLoteNumeroProveedor() ) )
            {
                $s_SQLQuery1 .= $s_Separator."LoteNumeroProveedor";
                $s_SQLQuery2 .= $s_Separator."'".$this->getLoteNumeroProveedor()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getAnio() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Anio";
                $s_SQLQuery2 .= $s_Separator."'".$this->getAnio()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE ALM_Lote SET ";
            $s_Separator = "";
            if ( !is_null( $this->getIdCompania() ) )
            {
                $s_SQLQuery .= $s_Separator."IdCompania = ".$this->getIdCompania()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdSucursal() ) )
            {
                $s_SQLQuery .= $s_Separator."IdSucursal = ".$this->getIdSucursal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdItem() ) )
            {
                $s_SQLQuery .= $s_Separator."IdItem = '".$this->getIdItem()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getProductoDescripcion() ) )
            {
                $s_SQLQuery .= $s_Separator."ProductoDescripcion = '".$this->getProductoDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getLoteNumero() ) )
            {
                $s_SQLQuery .= $s_Separator."LoteNumero = '".$this->getLoteNumero()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaVencimiento() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaVencimiento = '".$this->getFechaVencimiento()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaOrigen() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaOrigen = '".$this->getFechaOrigen()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery .= $s_Separator."Descripcion = '".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getProveedorId() ) )
            {
                $s_SQLQuery .= $s_Separator."ProveedorId = ".$this->getProveedorId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getProveedorNombre() ) )
            {
                $s_SQLQuery .= $s_Separator."ProveedorNombre = '".$this->getProveedorNombre()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getLoteNumeroProveedor() ) )
            {
                $s_SQLQuery .= $s_Separator."LoteNumeroProveedor = '".$this->getLoteNumeroProveedor()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getAnio() ) )
            {
                $s_SQLQuery .= $s_Separator."Anio = '".$this->getAnio()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdLote = ".$this->getIdLote().";";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM ALM_Lote WHERE  IdLote = ".$this->getIdLote().";";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        return true;
    }

}
?>