<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_ItemAlmacenStock.xml */
/* Generado: 2020-08-18 04:21:24 */

/* Mantenimiento de los registros de la tabla ALM_ItemAlmacenStock */
abstract class BaseALM_ItemAlmacenStockDP extends ALM_ItemAlmacenStockBV
{
    /* Constructor ( Establece los valores desde un objeto ALM_ItemAlmacenStockBN ) */
    public function __construct( ALM_ItemAlmacenStockBN $o_ALM_ItemAlmacenStockBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_ALM_ItemAlmacenStockBN ) )
        {
            $this->setByBN( $o_ALM_ItemAlmacenStockBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto ALM_ItemAlmacenStockBN */
    public function setByBN( ALM_ItemAlmacenStockBN $o_ALM_ItemAlmacenStockBN )
    {
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_ALM_ItemAlmacenStockBN->getIdCompania() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getIdItem() ) )
        {
            $this->setIdItem( $o_ALM_ItemAlmacenStockBN->getIdItem() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getIdAlmacen() ) )
        {
            $this->setIdAlmacen( $o_ALM_ItemAlmacenStockBN->getIdAlmacen() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getIdCondicion() ) )
        {
            $this->setIdCondicion( $o_ALM_ItemAlmacenStockBN->getIdCondicion() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getIdLote() ) )
        {
            $this->setIdLote( $o_ALM_ItemAlmacenStockBN->getIdLote() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_ALM_ItemAlmacenStockBN->getIdSucursal() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getLoteEquivalente() ) )
        {
            $this->setLoteEquivalente( $o_ALM_ItemAlmacenStockBN->getLoteEquivalente() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getDonante() ) )
        {
            $this->setDonante( $o_ALM_ItemAlmacenStockBN->getDonante() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getFechaIngreso() ) )
        {
            $this->setFechaIngreso( $o_ALM_ItemAlmacenStockBN->getFechaIngreso() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getFechaVencimiento() ) )
        {
            $this->setFechaVencimiento( $o_ALM_ItemAlmacenStockBN->getFechaVencimiento() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getStockIngreso() ) )
        {
            $this->setStockIngreso( $o_ALM_ItemAlmacenStockBN->getStockIngreso() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getStockActual() ) )
        {
            $this->setStockActual( $o_ALM_ItemAlmacenStockBN->getStockActual() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getStockComprometido() ) )
        {
            $this->setStockComprometido( $o_ALM_ItemAlmacenStockBN->getStockComprometido() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getStockActualDoble() ) )
        {
            $this->setStockActualDoble( $o_ALM_ItemAlmacenStockBN->getStockActualDoble() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getStockFisico() ) )
        {
            $this->setStockFisico( $o_ALM_ItemAlmacenStockBN->getStockFisico() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getStockReservado() ) )
        {
            $this->setStockReservado( $o_ALM_ItemAlmacenStockBN->getStockReservado() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getStockDisponible() ) )
        {
            $this->setStockDisponible( $o_ALM_ItemAlmacenStockBN->getStockDisponible() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getPrecioUnitario() ) )
        {
            $this->setPrecioUnitario( $o_ALM_ItemAlmacenStockBN->getPrecioUnitario() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getPrecioUnitarioDolares() ) )
        {
            $this->setPrecioUnitarioDolares( $o_ALM_ItemAlmacenStockBN->getPrecioUnitarioDolares() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getPrioridad() ) )
        {
            $this->setPrioridad( $o_ALM_ItemAlmacenStockBN->getPrioridad() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getPrecioPromedioLocal() ) )
        {
            $this->setPrecioPromedioLocal( $o_ALM_ItemAlmacenStockBN->getPrecioPromedioLocal() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getPrecioPromedioDolares() ) )
        {
            $this->setPrecioPromedioDolares( $o_ALM_ItemAlmacenStockBN->getPrecioPromedioDolares() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getDocumentoReferencia() ) )
        {
            $this->setDocumentoReferencia( $o_ALM_ItemAlmacenStockBN->getDocumentoReferencia() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getObservaciones() ) )
        {
            $this->setObservaciones( $o_ALM_ItemAlmacenStockBN->getObservaciones() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getObservacionesCorrectivas() ) )
        {
            $this->setObservacionesCorrectivas( $o_ALM_ItemAlmacenStockBN->getObservacionesCorrectivas() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_ALM_ItemAlmacenStockBN->getFechaCreacion() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_ALM_ItemAlmacenStockBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_ALM_ItemAlmacenStockBN->getFechaModificacion() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_ALM_ItemAlmacenStockBN->getUsuarioModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_ALM_ItemAlmacenStockFN = new ALM_ItemAlmacenStockFN();
        $o_ALM_ItemAlmacenStockBN = $o_ALM_ItemAlmacenStockFN->selectByPk( $this->getIdCompania(), $this->getIdItem(), $this->getIdAlmacen(), $this->getIdCondicion(), $this->getIdLote() );
        if ( is_null( $o_ALM_ItemAlmacenStockBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO ALM_ItemAlmacenStock ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdCompania() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCompania";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdCompania()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdItem() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdItem";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdItem()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdAlmacen() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdAlmacen";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdAlmacen()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdCondicion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCondicion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdCondicion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdLote() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdLote";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdLote()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdSucursal() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdSucursal";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdSucursal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getLoteEquivalente() ) )
            {
                $s_SQLQuery1 .= $s_Separator."LoteEquivalente";
                $s_SQLQuery2 .= $s_Separator."'".$this->getLoteEquivalente()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDonante() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Donante";
                $s_SQLQuery2 .= $s_Separator."".$this->getDonante()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaIngreso() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaIngreso";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaIngreso()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaVencimiento() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaVencimiento";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaVencimiento()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getStockIngreso() ) )
            {
                $s_SQLQuery1 .= $s_Separator."StockIngreso";
                $s_SQLQuery2 .= $s_Separator."".$this->getStockIngreso()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getStockActual() ) )
            {
                $s_SQLQuery1 .= $s_Separator."StockActual";
                $s_SQLQuery2 .= $s_Separator."".$this->getStockActual()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getStockComprometido() ) )
            {
                $s_SQLQuery1 .= $s_Separator."StockComprometido";
                $s_SQLQuery2 .= $s_Separator."".$this->getStockComprometido()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getStockActualDoble() ) )
            {
                $s_SQLQuery1 .= $s_Separator."StockActualDoble";
                $s_SQLQuery2 .= $s_Separator."".$this->getStockActualDoble()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getStockFisico() ) )
            {
                $s_SQLQuery1 .= $s_Separator."StockFisico";
                $s_SQLQuery2 .= $s_Separator."".$this->getStockFisico()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getStockReservado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."StockReservado";
                $s_SQLQuery2 .= $s_Separator."".$this->getStockReservado()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getStockDisponible() ) )
            {
                $s_SQLQuery1 .= $s_Separator."StockDisponible";
                $s_SQLQuery2 .= $s_Separator."".$this->getStockDisponible()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPrecioUnitario() ) )
            {
                $s_SQLQuery1 .= $s_Separator."PrecioUnitario";
                $s_SQLQuery2 .= $s_Separator."".$this->getPrecioUnitario()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPrecioUnitarioDolares() ) )
            {
                $s_SQLQuery1 .= $s_Separator."PrecioUnitarioDolares";
                $s_SQLQuery2 .= $s_Separator."".$this->getPrecioUnitarioDolares()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPrioridad() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Prioridad";
                $s_SQLQuery2 .= $s_Separator."".$this->getPrioridad()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPrecioPromedioLocal() ) )
            {
                $s_SQLQuery1 .= $s_Separator."PrecioPromedioLocal";
                $s_SQLQuery2 .= $s_Separator."".$this->getPrecioPromedioLocal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPrecioPromedioDolares() ) )
            {
                $s_SQLQuery1 .= $s_Separator."PrecioPromedioDolares";
                $s_SQLQuery2 .= $s_Separator."".$this->getPrecioPromedioDolares()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDocumentoReferencia() ) )
            {
                $s_SQLQuery1 .= $s_Separator."DocumentoReferencia";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDocumentoReferencia()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getObservaciones() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Observaciones";
                $s_SQLQuery2 .= $s_Separator."'".$this->getObservaciones()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getObservacionesCorrectivas() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ObservacionesCorrectivas";
                $s_SQLQuery2 .= $s_Separator."'".$this->getObservacionesCorrectivas()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE ALM_ItemAlmacenStock SET ";
            $s_Separator = "";
            if ( !is_null( $this->getIdSucursal() ) )
            {
                $s_SQLQuery .= $s_Separator."IdSucursal = ".$this->getIdSucursal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getLoteEquivalente() ) )
            {
                $s_SQLQuery .= $s_Separator."LoteEquivalente = '".$this->getLoteEquivalente()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDonante() ) )
            {
                $s_SQLQuery .= $s_Separator."Donante = ".$this->getDonante()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaIngreso() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaIngreso = '".$this->getFechaIngreso()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaVencimiento() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaVencimiento = '".$this->getFechaVencimiento()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getStockIngreso() ) )
            {
                $s_SQLQuery .= $s_Separator."StockIngreso = ".$this->getStockIngreso()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getStockActual() ) )
            {
                $s_SQLQuery .= $s_Separator."StockActual = ".$this->getStockActual()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getStockComprometido() ) )
            {
                $s_SQLQuery .= $s_Separator."StockComprometido = ".$this->getStockComprometido()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getStockActualDoble() ) )
            {
                $s_SQLQuery .= $s_Separator."StockActualDoble = ".$this->getStockActualDoble()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getStockFisico() ) )
            {
                $s_SQLQuery .= $s_Separator."StockFisico = ".$this->getStockFisico()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getStockReservado() ) )
            {
                $s_SQLQuery .= $s_Separator."StockReservado = ".$this->getStockReservado()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getStockDisponible() ) )
            {
                $s_SQLQuery .= $s_Separator."StockDisponible = ".$this->getStockDisponible()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPrecioUnitario() ) )
            {
                $s_SQLQuery .= $s_Separator."PrecioUnitario = ".$this->getPrecioUnitario()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPrecioUnitarioDolares() ) )
            {
                $s_SQLQuery .= $s_Separator."PrecioUnitarioDolares = ".$this->getPrecioUnitarioDolares()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPrioridad() ) )
            {
                $s_SQLQuery .= $s_Separator."Prioridad = ".$this->getPrioridad()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPrecioPromedioLocal() ) )
            {
                $s_SQLQuery .= $s_Separator."PrecioPromedioLocal = ".$this->getPrecioPromedioLocal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPrecioPromedioDolares() ) )
            {
                $s_SQLQuery .= $s_Separator."PrecioPromedioDolares = ".$this->getPrecioPromedioDolares()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDocumentoReferencia() ) )
            {
                $s_SQLQuery .= $s_Separator."DocumentoReferencia = '".$this->getDocumentoReferencia()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getObservaciones() ) )
            {
                $s_SQLQuery .= $s_Separator."Observaciones = '".$this->getObservaciones()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getObservacionesCorrectivas() ) )
            {
                $s_SQLQuery .= $s_Separator."ObservacionesCorrectivas = '".$this->getObservacionesCorrectivas()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdCompania = ".$this->getIdCompania()." AND  IdItem = '".$this->getIdItem()."' AND  IdAlmacen = '".$this->getIdAlmacen()."' AND  IdCondicion = '".$this->getIdCondicion()."' AND  IdLote = '".$this->getIdLote()."';";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM ALM_ItemAlmacenStock WHERE  IdCompania = ".$this->getIdCompania()." AND  IdItem = '".$this->getIdItem()."' AND  IdAlmacen = '".$this->getIdAlmacen()."' AND  IdCondicion = '".$this->getIdCondicion()."' AND  IdLote = '".$this->getIdLote()."';";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>