<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: VTA_Orden.xml */
/* Generado: 2022-06-14 07:58:41 */

/* Validacion del contenido de los campos campos de la tabla VTA_Orden */
abstract class BaseVTA_OrdenBV extends VTA_OrdenBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo OrdenId */
    public function setOrdenId( $i_OrdenId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_OrdenId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo OrdenId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenId( $i_OrdenId );
        return true;
    }

    /* Valida y establece el valor del campo CiaCod */
    public function setCiaCod( $i_CiaCod, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_CiaCod, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo CiaCod ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCiaCod( $i_CiaCod );
        return true;
    }

    /* Valida y establece el valor del campo IdSucursal */
    public function setIdSucursal( $i_IdSucursal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSucursal, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSucursal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSucursal( $i_IdSucursal );
        return true;
    }

    /* Valida y establece el valor del campo PtoVtaCod */
    public function setPtoVtaCod( $s_PtoVtaCod, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_PtoVtaCod, "CHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo PtoVtaCod ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPtoVtaCod( $s_PtoVtaCod );
        return true;
    }

    /* Valida y establece el valor del campo IdCaja */
    public function setIdCaja( $i_IdCaja, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCaja, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCaja ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCaja( $i_IdCaja );
        return true;
    }

    /* Valida y establece el valor del campo IdTurno */
    public function setIdTurno( $i_IdTurno, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdTurno, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdTurno ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTurno( $i_IdTurno );
        return true;
    }

    /* Valida y establece el valor del campo IdProyecto */
    public function setIdProyecto( $i_IdProyecto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdProyecto, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdProyecto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdProyecto( $i_IdProyecto );
        return true;
    }

    /* Valida y establece el valor del campo OrdenTipoId */
    public function setOrdenTipoId( $i_OrdenTipoId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_OrdenTipoId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo OrdenTipoId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenTipoId( $i_OrdenTipoId );
        return true;
    }

    /* Valida y establece el valor del campo OrdenTipoComercialId */
    public function setOrdenTipoComercialId( $i_OrdenTipoComercialId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_OrdenTipoComercialId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo OrdenTipoComercialId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenTipoComercialId( $i_OrdenTipoComercialId );
        return true;
    }

    /* Valida y establece el valor del campo OrdenTipoClasificacionId */
    public function setOrdenTipoClasificacionId( $i_OrdenTipoClasificacionId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_OrdenTipoClasificacionId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo OrdenTipoClasificacionId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenTipoClasificacionId( $i_OrdenTipoClasificacionId );
        return true;
    }

    /* Valida y establece el valor del campo OrdenNum */
    public function setOrdenNum( $s_OrdenNum, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_OrdenNum, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo OrdenNum ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenNum( $s_OrdenNum );
        return true;
    }

    /* Valida y establece el valor del campo OrdenPadre */
    public function setOrdenPadre( $i_OrdenPadre, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_OrdenPadre, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo OrdenPadre ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenPadre( $i_OrdenPadre );
        return true;
    }

    /* Valida y establece el valor del campo OrdenFecha */
    public function setOrdenFecha( $d_OrdenFecha, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_OrdenFecha, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo OrdenFecha ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenFecha( $d_OrdenFecha );
        return true;
    }

    /* Valida y establece el valor del campo OrdenVenc */
    public function setOrdenVenc( $d_OrdenVenc, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_OrdenVenc, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo OrdenVenc ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenVenc( $d_OrdenVenc );
        return true;
    }

    /* Valida y establece el valor del campo FechaInicioAlq */
    public function setFechaInicioAlq( $d_FechaInicioAlq, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaInicioAlq, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaInicioAlq ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaInicioAlq( $d_FechaInicioAlq );
        return true;
    }

    /* Valida y establece el valor del campo FechaFinAlq */
    public function setFechaFinAlq( $d_FechaFinAlq, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaFinAlq, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaFinAlq ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaFinAlq( $d_FechaFinAlq );
        return true;
    }

    /* Valida y establece el valor del campo AlmacenCod */
    public function setAlmacenCod( $s_AlmacenCod, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_AlmacenCod, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo AlmacenCod ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAlmacenCod( $s_AlmacenCod );
        return true;
    }

    /* Valida y establece el valor del campo AlmacenDespacho */
    public function setAlmacenDespacho( $s_AlmacenDespacho, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_AlmacenDespacho, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo AlmacenDespacho ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAlmacenDespacho( $s_AlmacenDespacho );
        return true;
    }

    /* Valida y establece el valor del campo ClienteId */
    public function setClienteId( $i_ClienteId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_ClienteId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo ClienteId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setClienteId( $i_ClienteId );
        return true;
    }

    /* Valida y establece el valor del campo ClienteNombre */
    public function setClienteNombre( $s_ClienteNombre, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ClienteNombre, "VARCHAR", 150, 0, false ) )
            {
                throw new Exception( "El campo ClienteNombre ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setClienteNombre( $s_ClienteNombre );
        return true;
    }

    /* Valida y establece el valor del campo ClienteDocCod */
    public function setClienteDocCod( $s_ClienteDocCod, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ClienteDocCod, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo ClienteDocCod ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setClienteDocCod( $s_ClienteDocCod );
        return true;
    }

    /* Valida y establece el valor del campo ClienteDocNum */
    public function setClienteDocNum( $s_ClienteDocNum, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ClienteDocNum, "VARCHAR", 15, 0, false ) )
            {
                throw new Exception( "El campo ClienteDocNum ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setClienteDocNum( $s_ClienteDocNum );
        return true;
    }

    /* Valida y establece el valor del campo ClienteSucursal */
    public function setClienteSucursal( $s_ClienteSucursal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ClienteSucursal, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo ClienteSucursal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setClienteSucursal( $s_ClienteSucursal );
        return true;
    }

    /* Valida y establece el valor del campo FactDirec1 */
    public function setFactDirec1( $s_FactDirec1, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_FactDirec1, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo FactDirec1 ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFactDirec1( $s_FactDirec1 );
        return true;
    }

    /* Valida y establece el valor del campo FactDirec2 */
    public function setFactDirec2( $s_FactDirec2, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_FactDirec2, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo FactDirec2 ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFactDirec2( $s_FactDirec2 );
        return true;
    }

    /* Valida y establece el valor del campo FactDirec3 */
    public function setFactDirec3( $s_FactDirec3, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_FactDirec3, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo FactDirec3 ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFactDirec3( $s_FactDirec3 );
        return true;
    }

    /* Valida y establece el valor del campo FactCiudad */
    public function setFactCiudad( $s_FactCiudad, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_FactCiudad, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo FactCiudad ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFactCiudad( $s_FactCiudad );
        return true;
    }

    /* Valida y establece el valor del campo FactEstado */
    public function setFactEstado( $s_FactEstado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_FactEstado, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo FactEstado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFactEstado( $s_FactEstado );
        return true;
    }

    /* Valida y establece el valor del campo FactPais */
    public function setFactPais( $s_FactPais, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_FactPais, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo FactPais ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFactPais( $s_FactPais );
        return true;
    }

    /* Valida y establece el valor del campo VendedorCliente */
    public function setVendedorCliente( $s_VendedorCliente, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_VendedorCliente, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo VendedorCliente ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setVendedorCliente( $s_VendedorCliente );
        return true;
    }

    /* Valida y establece el valor del campo VendedorOrden */
    public function setVendedorOrden( $s_VendedorOrden, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_VendedorOrden, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo VendedorOrden ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setVendedorOrden( $s_VendedorOrden );
        return true;
    }

    /* Valida y establece el valor del campo PrecioNivel */
    public function setPrecioNivel( $s_PrecioNivel, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_PrecioNivel, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo PrecioNivel ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioNivel( $s_PrecioNivel );
        return true;
    }

    /* Valida y establece el valor del campo FactRegla */
    public function setFactRegla( $s_FactRegla, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_FactRegla, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo FactRegla ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFactRegla( $s_FactRegla );
        return true;
    }

    /* Valida y establece el valor del campo ContactoMedio */
    public function setContactoMedio( $s_ContactoMedio, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ContactoMedio, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo ContactoMedio ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setContactoMedio( $s_ContactoMedio );
        return true;
    }

    /* Valida y establece el valor del campo ContactoNombre */
    public function setContactoNombre( $s_ContactoNombre, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ContactoNombre, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo ContactoNombre ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setContactoNombre( $s_ContactoNombre );
        return true;
    }

    /* Valida y establece el valor del campo CondicionVentaId */
    public function setCondicionVentaId( $s_CondicionVentaId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CondicionVentaId, "VARCHAR", 5, 0, false ) )
            {
                throw new Exception( "El campo CondicionVentaId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCondicionVentaId( $s_CondicionVentaId );
        return true;
    }

    /* Valida y establece el valor del campo FormaPagoDesc */
    public function setFormaPagoDesc( $s_FormaPagoDesc, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_FormaPagoDesc, "VARCHAR", 200, 0, false ) )
            {
                throw new Exception( "El campo FormaPagoDesc ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFormaPagoDesc( $s_FormaPagoDesc );
        return true;
    }

    /* Valida y establece el valor del campo ValidezOrden */
    public function setValidezOrden( $s_ValidezOrden, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ValidezOrden, "VARCHAR", 200, 0, false ) )
            {
                throw new Exception( "El campo ValidezOrden ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setValidezOrden( $s_ValidezOrden );
        return true;
    }

    /* Valida y establece el valor del campo PlazaEntregaOrden */
    public function setPlazaEntregaOrden( $s_PlazaEntregaOrden, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_PlazaEntregaOrden, "VARCHAR", 200, 0, false ) )
            {
                throw new Exception( "El campo PlazaEntregaOrden ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPlazaEntregaOrden( $s_PlazaEntregaOrden );
        return true;
    }

    /* Valida y establece el valor del campo CondicionVenta */
    public function setCondicionVenta( $s_CondicionVenta, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CondicionVenta, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo CondicionVenta ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCondicionVenta( $s_CondicionVenta );
        return true;
    }

    /* Valida y establece el valor del campo DiasAlquiler */
    public function setDiasAlquiler( $i_DiasAlquiler, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_DiasAlquiler, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo DiasAlquiler ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDiasAlquiler( $i_DiasAlquiler );
        return true;
    }

    /* Valida y establece el valor del campo OrdenCompraRef */
    public function setOrdenCompraRef( $s_OrdenCompraRef, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_OrdenCompraRef, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo OrdenCompraRef ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenCompraRef( $s_OrdenCompraRef );
        return true;
    }

    /* Valida y establece el valor del campo ReferenciaTipoDocId */
    public function setReferenciaTipoDocId( $s_ReferenciaTipoDocId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReferenciaTipoDocId, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo ReferenciaTipoDocId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReferenciaTipoDocId( $s_ReferenciaTipoDocId );
        return true;
    }

    /* Valida y establece el valor del campo DocReferenciaTipo */
    public function setDocReferenciaTipo( $s_DocReferenciaTipo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DocReferenciaTipo, "VARCHAR", 5, 0, false ) )
            {
                throw new Exception( "El campo DocReferenciaTipo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDocReferenciaTipo( $s_DocReferenciaTipo );
        return true;
    }

    /* Valida y establece el valor del campo DocReferenciaNum */
    public function setDocReferenciaNum( $s_DocReferenciaNum, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DocReferenciaNum, "VARCHAR", 15, 0, false ) )
            {
                throw new Exception( "El campo DocReferenciaNum ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDocReferenciaNum( $s_DocReferenciaNum );
        return true;
    }

    /* Valida y establece el valor del campo DocReferenciaId */
    public function setDocReferenciaId( $s_DocReferenciaId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DocReferenciaId, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo DocReferenciaId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDocReferenciaId( $s_DocReferenciaId );
        return true;
    }

    /* Valida y establece el valor del campo DocReferenciaFecha */
    public function setDocReferenciaFecha( $d_DocReferenciaFecha, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_DocReferenciaFecha, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo DocReferenciaFecha ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDocReferenciaFecha( $d_DocReferenciaFecha );
        return true;
    }

    /* Valida y establece el valor del campo OrdenCredito */
    public function setOrdenCredito( $s_OrdenCredito, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_OrdenCredito, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo OrdenCredito ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenCredito( $s_OrdenCredito );
        return true;
    }

    /* Valida y establece el valor del campo OrdenCreditoEstado */
    public function setOrdenCreditoEstado( $s_OrdenCreditoEstado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_OrdenCreditoEstado, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo OrdenCreditoEstado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenCreditoEstado( $s_OrdenCreditoEstado );
        return true;
    }

    /* Valida y establece el valor del campo OrdenImpuestoFlag */
    public function setOrdenImpuestoFlag( $s_OrdenImpuestoFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_OrdenImpuestoFlag, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo OrdenImpuestoFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenImpuestoFlag( $s_OrdenImpuestoFlag );
        return true;
    }

    /* Valida y establece el valor del campo OrdenExoneradoFlag */
    public function setOrdenExoneradoFlag( $s_OrdenExoneradoFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_OrdenExoneradoFlag, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo OrdenExoneradoFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenExoneradoFlag( $s_OrdenExoneradoFlag );
        return true;
    }

    /* Valida y establece el valor del campo MonedaCod */
    public function setMonedaCod( $s_MonedaCod, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_MonedaCod, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo MonedaCod ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMonedaCod( $s_MonedaCod );
        return true;
    }

    /* Valida y establece el valor del campo MonedaCambioValor */
    public function setMonedaCambioValor( $f_MonedaCambioValor, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MonedaCambioValor, "DECIMAL", 6, 3, false ) )
            {
                throw new Exception( "El campo MonedaCambioValor ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMonedaCambioValor( $f_MonedaCambioValor );
        return true;
    }

    /* Valida y establece el valor del campo OrdenVenta */
    public function setOrdenVenta( $f_OrdenVenta, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_OrdenVenta, "DECIMAL", 12, 2, false ) )
            {
                throw new Exception( "El campo OrdenVenta ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenVenta( $f_OrdenVenta );
        return true;
    }

    /* Valida y establece el valor del campo OrdenVentaMN */
    public function setOrdenVentaMN( $f_OrdenVentaMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_OrdenVentaMN, "DECIMAL", 12, 2, false ) )
            {
                throw new Exception( "El campo OrdenVentaMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenVentaMN( $f_OrdenVentaMN );
        return true;
    }

    /* Valida y establece el valor del campo DsctoTipoCod */
    public function setDsctoTipoCod( $s_DsctoTipoCod, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DsctoTipoCod, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo DsctoTipoCod ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDsctoTipoCod( $s_DsctoTipoCod );
        return true;
    }

    /* Valida y establece el valor del campo DsctoCod */
    public function setDsctoCod( $s_DsctoCod, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DsctoCod, "VARCHAR", 15, 0, false ) )
            {
                throw new Exception( "El campo DsctoCod ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDsctoCod( $s_DsctoCod );
        return true;
    }

    /* Valida y establece el valor del campo OrdenDscto */
    public function setOrdenDscto( $f_OrdenDscto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_OrdenDscto, "DECIMAL", 12, 6, false ) )
            {
                throw new Exception( "El campo OrdenDscto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenDscto( $f_OrdenDscto );
        return true;
    }

    /* Valida y establece el valor del campo OrdenDsctoMN */
    public function setOrdenDsctoMN( $f_OrdenDsctoMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_OrdenDsctoMN, "DECIMAL", 12, 6, false ) )
            {
                throw new Exception( "El campo OrdenDsctoMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenDsctoMN( $f_OrdenDsctoMN );
        return true;
    }

    /* Valida y establece el valor del campo OrdenDsctoLinea */
    public function setOrdenDsctoLinea( $f_OrdenDsctoLinea, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_OrdenDsctoLinea, "DECIMAL", 12, 6, false ) )
            {
                throw new Exception( "El campo OrdenDsctoLinea ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenDsctoLinea( $f_OrdenDsctoLinea );
        return true;
    }

    /* Valida y establece el valor del campo OrdenDsctoLineaMN */
    public function setOrdenDsctoLineaMN( $f_OrdenDsctoLineaMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_OrdenDsctoLineaMN, "DECIMAL", 12, 6, false ) )
            {
                throw new Exception( "El campo OrdenDsctoLineaMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenDsctoLineaMN( $f_OrdenDsctoLineaMN );
        return true;
    }

    /* Valida y establece el valor del campo MontoAnticipo */
    public function setMontoAnticipo( $f_MontoAnticipo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoAnticipo, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoAnticipo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoAnticipo( $f_MontoAnticipo );
        return true;
    }

    /* Valida y establece el valor del campo MontoAnticipoMN */
    public function setMontoAnticipoMN( $f_MontoAnticipoMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoAnticipoMN, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoAnticipoMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoAnticipoMN( $f_MontoAnticipoMN );
        return true;
    }

    /* Valida y establece el valor del campo MontoExonerado */
    public function setMontoExonerado( $f_MontoExonerado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoExonerado, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoExonerado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoExonerado( $f_MontoExonerado );
        return true;
    }

    /* Valida y establece el valor del campo MontoExoneradoMN */
    public function setMontoExoneradoMN( $f_MontoExoneradoMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoExoneradoMN, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoExoneradoMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoExoneradoMN( $f_MontoExoneradoMN );
        return true;
    }

    /* Valida y establece el valor del campo OrdenAfecto */
    public function setOrdenAfecto( $f_OrdenAfecto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_OrdenAfecto, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo OrdenAfecto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenAfecto( $f_OrdenAfecto );
        return true;
    }

    /* Valida y establece el valor del campo OrdenAfectoMN */
    public function setOrdenAfectoMN( $f_OrdenAfectoMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_OrdenAfectoMN, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo OrdenAfectoMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenAfectoMN( $f_OrdenAfectoMN );
        return true;
    }

    /* Valida y establece el valor del campo OrdenInafecto */
    public function setOrdenInafecto( $f_OrdenInafecto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_OrdenInafecto, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo OrdenInafecto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenInafecto( $f_OrdenInafecto );
        return true;
    }

    /* Valida y establece el valor del campo OrdenInafectoMN */
    public function setOrdenInafectoMN( $f_OrdenInafectoMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_OrdenInafectoMN, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo OrdenInafectoMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenInafectoMN( $f_OrdenInafectoMN );
        return true;
    }

    /* Valida y establece el valor del campo OrdenImpuesto */
    public function setOrdenImpuesto( $f_OrdenImpuesto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_OrdenImpuesto, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo OrdenImpuesto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenImpuesto( $f_OrdenImpuesto );
        return true;
    }

    /* Valida y establece el valor del campo OrdenImpuestoMN */
    public function setOrdenImpuestoMN( $f_OrdenImpuestoMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_OrdenImpuestoMN, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo OrdenImpuestoMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenImpuestoMN( $f_OrdenImpuestoMN );
        return true;
    }

    /* Valida y establece el valor del campo OrdenNeto */
    public function setOrdenNeto( $f_OrdenNeto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_OrdenNeto, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo OrdenNeto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenNeto( $f_OrdenNeto );
        return true;
    }

    /* Valida y establece el valor del campo OrdenNetoMN */
    public function setOrdenNetoMN( $f_OrdenNetoMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_OrdenNetoMN, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo OrdenNetoMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenNetoMN( $f_OrdenNetoMN );
        return true;
    }

    /* Valida y establece el valor del campo OrdenBaseImponible */
    public function setOrdenBaseImponible( $f_OrdenBaseImponible, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_OrdenBaseImponible, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo OrdenBaseImponible ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenBaseImponible( $f_OrdenBaseImponible );
        return true;
    }

    /* Valida y establece el valor del campo OrdenBaseImponibleMN */
    public function setOrdenBaseImponibleMN( $f_OrdenBaseImponibleMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_OrdenBaseImponibleMN, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo OrdenBaseImponibleMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenBaseImponibleMN( $f_OrdenBaseImponibleMN );
        return true;
    }

    /* Valida y establece el valor del campo OrdenImpuestoConDscto */
    public function setOrdenImpuestoConDscto( $f_OrdenImpuestoConDscto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_OrdenImpuestoConDscto, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo OrdenImpuestoConDscto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenImpuestoConDscto( $f_OrdenImpuestoConDscto );
        return true;
    }

    /* Valida y establece el valor del campo OrdenImpuestoConDsctoMN */
    public function setOrdenImpuestoConDsctoMN( $f_OrdenImpuestoConDsctoMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_OrdenImpuestoConDsctoMN, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo OrdenImpuestoConDsctoMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenImpuestoConDsctoMN( $f_OrdenImpuestoConDsctoMN );
        return true;
    }

    /* Valida y establece el valor del campo OrdenTotalaPagar */
    public function setOrdenTotalaPagar( $f_OrdenTotalaPagar, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_OrdenTotalaPagar, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo OrdenTotalaPagar ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenTotalaPagar( $f_OrdenTotalaPagar );
        return true;
    }

    /* Valida y establece el valor del campo OrdenTotalaPagarMN */
    public function setOrdenTotalaPagarMN( $f_OrdenTotalaPagarMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_OrdenTotalaPagarMN, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo OrdenTotalaPagarMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenTotalaPagarMN( $f_OrdenTotalaPagarMN );
        return true;
    }

    /* Valida y establece el valor del campo OrdenComision */
    public function setOrdenComision( $f_OrdenComision, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_OrdenComision, "DECIMAL", 12, 2, false ) )
            {
                throw new Exception( "El campo OrdenComision ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenComision( $f_OrdenComision );
        return true;
    }

    /* Valida y establece el valor del campo OrdenObs */
    public function setOrdenObs( $u_OrdenObs, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $u_OrdenObs, "TEXT", 0, 0, false ) )
            {
                throw new Exception( "El campo OrdenObs ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenObs( $u_OrdenObs );
        return true;
    }

    /* Valida y establece el valor del campo AnulacionComentario */
    public function setAnulacionComentario( $s_AnulacionComentario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_AnulacionComentario, "VARCHAR", 500, 0, false ) )
            {
                throw new Exception( "El campo AnulacionComentario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAnulacionComentario( $s_AnulacionComentario );
        return true;
    }

    /* Valida y establece el valor del campo AdminComentario */
    public function setAdminComentario( $s_AdminComentario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_AdminComentario, "VARCHAR", 500, 0, false ) )
            {
                throw new Exception( "El campo AdminComentario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAdminComentario( $s_AdminComentario );
        return true;
    }

    /* Valida y establece el valor del campo OrdenEstado */
    public function setOrdenEstado( $s_OrdenEstado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_OrdenEstado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo OrdenEstado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenEstado( $s_OrdenEstado );
        return true;
    }

    /* Valida y establece el valor del campo EstadoDevolucion */
    public function setEstadoDevolucion( $s_EstadoDevolucion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EstadoDevolucion, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo EstadoDevolucion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstadoDevolucion( $s_EstadoDevolucion );
        return true;
    }

    /* Valida y establece el valor del campo OrdenBloqueado */
    public function setOrdenBloqueado( $s_OrdenBloqueado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_OrdenBloqueado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo OrdenBloqueado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenBloqueado( $s_OrdenBloqueado );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioActualizacion */
    public function setUsuarioActualizacion( $s_UsuarioActualizacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioActualizacion, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo UsuarioActualizacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioActualizacion( $s_UsuarioActualizacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaActualizacion */
    public function setFechaActualizacion( $d_FechaActualizacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaActualizacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaActualizacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaActualizacion( $d_FechaActualizacion );
        return true;
    }
    
    /* Valida y establece el valor del campo Placa */
    public function setPlaca( $s_Placa, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Placa, "VARCHAR", 11, 0, false ) )
            {
                throw new Exception( "El campo Placa ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPlaca( $s_Placa );
        return true;
    }
    
    /* Valida y establece el valor del campo IdVehiculoTipo */
    public function setIdVehiculoTipo( $s_IdVehiculoTipo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdVehiculoTipo, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdVehiculoTipo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdVehiculoTipo( $s_IdVehiculoTipo );
        return true;
    }
    
    /* Valida y establece el valor del campo NombreVehiculoTipo */
    public function setNombreVehiculoTipo( $s_NombreVehiculoTipo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NombreVehiculoTipo, "VARCHAR", 200, 0, false ) )
            {
                throw new Exception( "El campo NombreVehiculoTipo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNombreVehiculoTipo( $s_NombreVehiculoTipo );
        return true;
    }

    /* Valida y establece el valor del campo IdVehiculoMarca */
    public function setIdVehiculoMarca( $s_IdVehiculoMarca, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdVehiculoMarca, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdVehiculoMarca ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdVehiculoMarca( $s_IdVehiculoMarca );
        return true;
    }
    
    /* Valida y establece el valor del campo IdVehiculoMarca */
    public function setIdVehiculoModelo( $s_IdVehiculoModelo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdVehiculoModelo, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdVehiculoModelo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdVehiculoModelo( $s_IdVehiculoModelo );
        return true;
    }
    
    /* Valida y establece el valor del campo NombrVehiculoMarca */
    public function setNombreVehiculoMarca( $s_NombreVehiculoMarca, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NombreVehiculoMarca, "VARCHAR", 80, 0, false ) )
            {
                throw new Exception( "El campo NombreVehiculoMarca ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNombreVehiculoMarca( $s_NombreVehiculoMarca );
        return true;
    }
    
    /* Valida y establece el valor del campo NombrVehiculoModelo */
    public function setNombreVehiculoModelo( $s_NombreVehiculoModelo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NombreVehiculoModelo, "VARCHAR", 80, 0, false ) )
            {
                throw new Exception( "El campo NombreVehiculoModelo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNombreVehiculoModelo( $s_NombreVehiculoModelo );
        return true;
    }
    
    /* Valida y establece el valor del campo Color */
    public function setColor( $s_Color, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Color, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo Color ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setColor( $s_Color );
        return true;
    }
    
    /* Valida y establece el valor del campo Color */
    public function setComentario( $s_Comentario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Comentario, "VARCHAR", 360, 0, false ) )
            {
                throw new Exception( "El campo Comentario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setComentario( $s_Comentario );
        return true;
    }
    
    /* Valida y establece el valor del campo IdDestino */
    public function setIdDestino( $s_IdDestino, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdDestino, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdDestino ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdDestino( $s_IdDestino );
        return true;
    }
    
    /* Valida y establece el valor del campo NombreDestino */
    public function setNombreDestino( $s_NombreDestino, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NombreDestino, "VARCHAR", 360, 0, false ) )
            {
                throw new Exception( "El campo NombreDestino ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNombreDestino( $s_NombreDestino );
        return true;
    }
     
    /* Valida y establece el valor del campo NumeroPase */
    public function setNumeroPase( $s_NumeroPase, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NumeroPase, "VARCHAR", 5, 0, false ) )
            {
                throw new Exception( "El campo NumeroPase ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNumeroPase( $s_NumeroPase );
        return true;
    }

    /* Valida y establece el valor del campo Color */
    public function setCelularCliente( $s_CelularCliente, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CelularCliente, "VARCHAR", 15, 0, false ) )
            {
                throw new Exception( "El campo CelularCliente ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCelularCliente( $s_CelularCliente );
        return true;
    }
    
    /* Valida y establece el valor del campo Comision */
    public function setComision( $s_Comision, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Comision, "DECIMAL", 10, 2, false ) )
            {
                throw new Exception( "El campo Comision ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setComision( $s_Comision );
        return true;
    }
    
    /* Valida y establece el valor del campo BilletraDigitalArchivo */
    public function setBilletraDigitalArchivo( $s_BilletraDigitalArchivo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_BilletraDigitalArchivo, "VARCHAR", 600, 0, false ) )
            {
                throw new Exception( "El campo BilletraDigitalArchivo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setBilletraDigitalArchivo( $s_BilletraDigitalArchivo );
        return true;
    }
    
	/* Valida y establece el valor del campo FlagSinComision */
    public function setFlagSinComision( $s_FlagSinComision, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_FlagSinComision, "INT", 1, 0, false ) )
            {
                throw new Exception( "El campo FlagSinComision ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFlagSinComision( $s_FlagSinComision );
        return true;
    }
	
    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setOrdenId( $this->getOrdenId(), false );
        $this->setCiaCod( $this->getCiaCod(), true );
        $this->setIdSucursal( $this->getIdSucursal(), true );
        $this->setPtoVtaCod( $this->getPtoVtaCod(), true );
        $this->setIdCaja( $this->getIdCaja(), true );
        $this->setIdTurno( $this->getIdTurno(), true );
        $this->setIdProyecto( $this->getIdProyecto(), true );
        $this->setOrdenTipoId( $this->getOrdenTipoId(), true );
        $this->setOrdenTipoComercialId( $this->getOrdenTipoComercialId(), true );
        $this->setOrdenTipoClasificacionId( $this->getOrdenTipoClasificacionId(), true );
        $this->setOrdenNum( $this->getOrdenNum(), true );
        $this->setOrdenPadre( $this->getOrdenPadre(), true );
        $this->setOrdenFecha( $this->getOrdenFecha(), true );
        $this->setOrdenVenc( $this->getOrdenVenc(), true );
        $this->setFechaInicioAlq( $this->getFechaInicioAlq(), true );
        $this->setFechaFinAlq( $this->getFechaFinAlq(), true );
        $this->setAlmacenCod( $this->getAlmacenCod(), true );
        $this->setAlmacenDespacho( $this->getAlmacenDespacho(), true );
        $this->setClienteId( $this->getClienteId(), true );
        $this->setClienteNombre( $this->getClienteNombre(), true );
        $this->setClienteDocCod( $this->getClienteDocCod(), true );
        $this->setClienteDocNum( $this->getClienteDocNum(), true );
        $this->setClienteSucursal( $this->getClienteSucursal(), true );
        $this->setFactDirec1( $this->getFactDirec1(), true );
        $this->setFactDirec2( $this->getFactDirec2(), true );
        $this->setFactDirec3( $this->getFactDirec3(), true );
        $this->setFactCiudad( $this->getFactCiudad(), true );
        $this->setFactEstado( $this->getFactEstado(), true );
        $this->setFactPais( $this->getFactPais(), true );
        $this->setVendedorCliente( $this->getVendedorCliente(), true );
        $this->setVendedorOrden( $this->getVendedorOrden(), true );
        $this->setPrecioNivel( $this->getPrecioNivel(), true );
        $this->setFactRegla( $this->getFactRegla(), true );
        $this->setContactoMedio( $this->getContactoMedio(), true );
        $this->setContactoNombre( $this->getContactoNombre(), true );
        $this->setCondicionVentaId( $this->getCondicionVentaId(), true );
        $this->setFormaPagoDesc( $this->getFormaPagoDesc(), true );
        $this->setValidezOrden( $this->getValidezOrden(), true );
        $this->setPlazaEntregaOrden( $this->getPlazaEntregaOrden(), true );
        $this->setCondicionVenta( $this->getCondicionVenta(), true );
        $this->setDiasAlquiler( $this->getDiasAlquiler(), true );
        $this->setOrdenCompraRef( $this->getOrdenCompraRef(), true );
        $this->setReferenciaTipoDocId( $this->getReferenciaTipoDocId(), true );
        $this->setDocReferenciaTipo( $this->getDocReferenciaTipo(), true );
        $this->setDocReferenciaNum( $this->getDocReferenciaNum(), true );
        $this->setDocReferenciaId( $this->getDocReferenciaId(), true );
        $this->setDocReferenciaFecha( $this->getDocReferenciaFecha(), true );
        $this->setOrdenCredito( $this->getOrdenCredito(), true );
        $this->setOrdenCreditoEstado( $this->getOrdenCreditoEstado(), true );
        $this->setOrdenImpuestoFlag( $this->getOrdenImpuestoFlag(), true );
        $this->setOrdenExoneradoFlag( $this->getOrdenExoneradoFlag(), true );
        $this->setMonedaCod( $this->getMonedaCod(), true );
        $this->setMonedaCambioValor( $this->getMonedaCambioValor(), true );
        $this->setOrdenVenta( $this->getOrdenVenta(), true );
        $this->setOrdenVentaMN( $this->getOrdenVentaMN(), true );
        $this->setDsctoTipoCod( $this->getDsctoTipoCod(), true );
        $this->setDsctoCod( $this->getDsctoCod(), true );
        $this->setOrdenDscto( $this->getOrdenDscto(), true );
        $this->setOrdenDsctoMN( $this->getOrdenDsctoMN(), true );
        $this->setOrdenDsctoLinea( $this->getOrdenDsctoLinea(), true );
        $this->setOrdenDsctoLineaMN( $this->getOrdenDsctoLineaMN(), true );
        $this->setMontoAnticipo( $this->getMontoAnticipo(), true );
        $this->setMontoAnticipoMN( $this->getMontoAnticipoMN(), true );
        $this->setMontoExonerado( $this->getMontoExonerado(), true );
        $this->setMontoExoneradoMN( $this->getMontoExoneradoMN(), true );
        $this->setOrdenAfecto( $this->getOrdenAfecto(), true );
        $this->setOrdenAfectoMN( $this->getOrdenAfectoMN(), true );
        $this->setOrdenInafecto( $this->getOrdenInafecto(), true );
        $this->setOrdenInafectoMN( $this->getOrdenInafectoMN(), true );
        $this->setOrdenImpuesto( $this->getOrdenImpuesto(), true );
        $this->setOrdenImpuestoMN( $this->getOrdenImpuestoMN(), true );
        $this->setOrdenNeto( $this->getOrdenNeto(), true );
        $this->setOrdenNetoMN( $this->getOrdenNetoMN(), true );
        $this->setOrdenBaseImponible( $this->getOrdenBaseImponible(), true );
        $this->setOrdenBaseImponibleMN( $this->getOrdenBaseImponibleMN(), true );
        $this->setOrdenImpuestoConDscto( $this->getOrdenImpuestoConDscto(), true );
        $this->setOrdenImpuestoConDsctoMN( $this->getOrdenImpuestoConDsctoMN(), true );
        $this->setOrdenTotalaPagar( $this->getOrdenTotalaPagar(), true );
        $this->setOrdenTotalaPagarMN( $this->getOrdenTotalaPagarMN(), true );
        $this->setOrdenComision( $this->getOrdenComision(), true );
        $this->setOrdenObs( $this->getOrdenObs(), true );
        $this->setAnulacionComentario( $this->getAnulacionComentario(), true );
        $this->setAdminComentario( $this->getAdminComentario(), true );
        $this->setOrdenEstado( $this->getOrdenEstado(), true );
        $this->setEstadoDevolucion( $this->getEstadoDevolucion(), true );
        $this->setOrdenBloqueado( $this->getOrdenBloqueado(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioActualizacion( $this->getUsuarioActualizacion(), true );
        $this->setFechaActualizacion( $this->getFechaActualizacion(), true );
        return true;
    }
}
?>