<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: VTA_FacturacionElectronica.xml */
/* Generado: 2024-08-24 23:31:56 */

/* Validacion del contenido de los campos campos de la tabla VTA_FacturacionElectronica */
abstract class BaseVTA_FacturacionElectronicaBV extends VTA_FacturacionElectronicaBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo FactElecId */
    public function setFactElecId( $i_FactElecId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_FactElecId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo FactElecId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFactElecId( $i_FactElecId );
        return true;
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo IdSucursal */
    public function setIdSucursal( $i_IdSucursal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSucursal, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSucursal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSucursal( $i_IdSucursal );
        return true;
    }

    /* Valida y establece el valor del campo Tipo */
    public function setTipo( $s_Tipo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Tipo, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo Tipo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipo( $s_Tipo );
        return true;
    }

    /* Valida y establece el valor del campo Serie */
    public function setSerie( $s_Serie, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Serie, "VARCHAR", 4, 0, false ) )
            {
                throw new Exception( "El campo Serie ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSerie( $s_Serie );
        return true;
    }

    /* Valida y establece el valor del campo Numero */
    public function setNumero( $s_Numero, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Numero, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo Numero ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNumero( $s_Numero );
        return true;
    }

    /* Valida y establece el valor del campo FechaEmision */
    public function setFechaEmision( $d_FechaEmision, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaEmision, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaEmision ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaEmision( $d_FechaEmision );
        return true;
    }

    /* Valida y establece el valor del campo FechaVencimiento */
    public function setFechaVencimiento( $d_FechaVencimiento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaVencimiento, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaVencimiento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaVencimiento( $d_FechaVencimiento );
        return true;
    }

    /* Valida y establece el valor del campo TipoComprobante */
    public function setTipoComprobante( $s_TipoComprobante, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoComprobante, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo TipoComprobante ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoComprobante( $s_TipoComprobante );
        return true;
    }

    /* Valida y establece el valor del campo TipoComprobanteDesc */
    public function setTipoComprobanteDesc( $s_TipoComprobanteDesc, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoComprobanteDesc, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo TipoComprobanteDesc ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoComprobanteDesc( $s_TipoComprobanteDesc );
        return true;
    }

    /* Valida y establece el valor del campo SerieNum */
    public function setSerieNum( $s_SerieNum, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_SerieNum, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo SerieNum ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSerieNum( $s_SerieNum );
        return true;
    }

    /* Valida y establece el valor del campo CodCliente */
    public function setCodCliente( $s_CodCliente, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CodCliente, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo CodCliente ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCodCliente( $s_CodCliente );
        return true;
    }

    /* Valida y establece el valor del campo ClienteNom */
    public function setClienteNom( $s_ClienteNom, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ClienteNom, "VARCHAR", 500, 0, false ) )
            {
                throw new Exception( "El campo ClienteNom ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setClienteNom( $s_ClienteNom );
        return true;
    }

    /* Valida y establece el valor del campo ClienteTipoDoc */
    public function setClienteTipoDoc( $s_ClienteTipoDoc, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ClienteTipoDoc, "VARCHAR", 5, 0, false ) )
            {
                throw new Exception( "El campo ClienteTipoDoc ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setClienteTipoDoc( $s_ClienteTipoDoc );
        return true;
    }

    /* Valida y establece el valor del campo ClienteDocNum */
    public function setClienteDocNum( $s_ClienteDocNum, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ClienteDocNum, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo ClienteDocNum ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setClienteDocNum( $s_ClienteDocNum );
        return true;
    }

    /* Valida y establece el valor del campo ClienteDireccion */
    public function setClienteDireccion( $s_ClienteDireccion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ClienteDireccion, "VARCHAR", 500, 0, false ) )
            {
                throw new Exception( "El campo ClienteDireccion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setClienteDireccion( $s_ClienteDireccion );
        return true;
    }

    /* Valida y establece el valor del campo ClienteEmail */
    public function setClienteEmail( $s_ClienteEmail, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ClienteEmail, "VARCHAR", 100, 0, false ) )
            {
                throw new Exception( "El campo ClienteEmail ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setClienteEmail( $s_ClienteEmail );
        return true;
    }

    /* Valida y establece el valor del campo ClienteEmail1 */
    public function setClienteEmail1( $s_ClienteEmail1, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ClienteEmail1, "VARCHAR", 100, 0, false ) )
            {
                throw new Exception( "El campo ClienteEmail1 ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setClienteEmail1( $s_ClienteEmail1 );
        return true;
    }

    /* Valida y establece el valor del campo ClienteEmail2 */
    public function setClienteEmail2( $s_ClienteEmail2, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ClienteEmail2, "VARCHAR", 100, 0, false ) )
            {
                throw new Exception( "El campo ClienteEmail2 ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setClienteEmail2( $s_ClienteEmail2 );
        return true;
    }

    /* Valida y establece el valor del campo TipoMoneda */
    public function setTipoMoneda( $s_TipoMoneda, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoMoneda, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo TipoMoneda ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoMoneda( $s_TipoMoneda );
        return true;
    }

    /* Valida y establece el valor del campo TipoCambio */
    public function setTipoCambio( $f_TipoCambio, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_TipoCambio, "DECIMAL", 6, 3, false ) )
            {
                throw new Exception( "El campo TipoCambio ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoCambio( $f_TipoCambio );
        return true;
    }

    /* Valida y establece el valor del campo PorcentajeIGV */
    public function setPorcentajeIGV( $f_PorcentajeIGV, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PorcentajeIGV, "DECIMAL", 4, 2, false ) )
            {
                throw new Exception( "El campo PorcentajeIGV ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPorcentajeIGV( $f_PorcentajeIGV );
        return true;
    }

    /* Valida y establece el valor del campo MontoDescuento */
    public function setMontoDescuento( $f_MontoDescuento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoDescuento, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoDescuento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoDescuento( $f_MontoDescuento );
        return true;
    }

    /* Valida y establece el valor del campo MontoDescuentoLinea */
    public function setMontoDescuentoLinea( $f_MontoDescuentoLinea, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoDescuentoLinea, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoDescuentoLinea ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoDescuentoLinea( $f_MontoDescuentoLinea );
        return true;
    }

    /* Valida y establece el valor del campo MontoAnticipo */
    public function setMontoAnticipo( $f_MontoAnticipo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoAnticipo, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoAnticipo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoAnticipo( $f_MontoAnticipo );
        return true;
    }

    /* Valida y establece el valor del campo MontoExonerado */
    public function setMontoExonerado( $f_MontoExonerado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoExonerado, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoExonerado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoExonerado( $f_MontoExonerado );
        return true;
    }

    /* Valida y establece el valor del campo MontoAfecto */
    public function setMontoAfecto( $f_MontoAfecto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoAfecto, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoAfecto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoAfecto( $f_MontoAfecto );
        return true;
    }

    /* Valida y establece el valor del campo MontoInafecto */
    public function setMontoInafecto( $f_MontoInafecto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoInafecto, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoInafecto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoInafecto( $f_MontoInafecto );
        return true;
    }

    /* Valida y establece el valor del campo SubTotal */
    public function setSubTotal( $f_SubTotal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_SubTotal, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo SubTotal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSubTotal( $f_SubTotal );
        return true;
    }

    /* Valida y establece el valor del campo Impuesto */
    public function setImpuesto( $f_Impuesto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_Impuesto, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo Impuesto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setImpuesto( $f_Impuesto );
        return true;
    }

    /* Valida y establece el valor del campo MontoTotal */
    public function setMontoTotal( $f_MontoTotal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoTotal, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoTotal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoTotal( $f_MontoTotal );
        return true;
    }

    /* Valida y establece el valor del campo EstadoWeb */
    public function setEstadoWeb( $s_EstadoWeb, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EstadoWeb, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo EstadoWeb ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstadoWeb( $s_EstadoWeb );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo FechaAnulacion */
    public function setFechaAnulacion( $d_FechaAnulacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaAnulacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaAnulacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaAnulacion( $d_FechaAnulacion );
        return true;
    }

    /* Valida y establece el valor del campo Enlace */
    public function setEnlace( $s_Enlace, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Enlace, "VARCHAR", 500, 0, false ) )
            {
                throw new Exception( "El campo Enlace ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEnlace( $s_Enlace );
        return true;
    }

    /* Valida y establece el valor del campo AceptadaxSunat */
    public function setAceptadaxSunat( $s_AceptadaxSunat, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_AceptadaxSunat, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo AceptadaxSunat ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAceptadaxSunat( $s_AceptadaxSunat );
        return true;
    }

    /* Valida y establece el valor del campo SunatDescripcion */
    public function setSunatDescripcion( $s_SunatDescripcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_SunatDescripcion, "VARCHAR", 1000, 0, false ) )
            {
                throw new Exception( "El campo SunatDescripcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSunatDescripcion( $s_SunatDescripcion );
        return true;
    }

    /* Valida y establece el valor del campo SunatNote */
    public function setSunatNote( $u_SunatNote, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $u_SunatNote, "TEXT", 0, 0, false ) )
            {
                throw new Exception( "El campo SunatNote ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSunatNote( $u_SunatNote );
        return true;
    }

    /* Valida y establece el valor del campo SunatResponseCode */
    public function setSunatResponseCode( $s_SunatResponseCode, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_SunatResponseCode, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo SunatResponseCode ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSunatResponseCode( $s_SunatResponseCode );
        return true;
    }

    /* Valida y establece el valor del campo SunatSoapError */
    public function setSunatSoapError( $s_SunatSoapError, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_SunatSoapError, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo SunatSoapError ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSunatSoapError( $s_SunatSoapError );
        return true;
    }

    /* Valida y establece el valor del campo PDFResult */
    public function setPDFResult( $s_PDFResult, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_PDFResult, "VARCHAR", 500, 0, false ) )
            {
                throw new Exception( "El campo PDFResult ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPDFResult( $s_PDFResult );
        return true;
    }

    /* Valida y establece el valor del campo XMLResult */
    public function setXMLResult( $s_XMLResult, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_XMLResult, "VARCHAR", 500, 0, false ) )
            {
                throw new Exception( "El campo XMLResult ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setXMLResult( $s_XMLResult );
        return true;
    }

    /* Valida y establece el valor del campo CDRResult */
    public function setCDRResult( $s_CDRResult, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CDRResult, "VARCHAR", 500, 0, false ) )
            {
                throw new Exception( "El campo CDRResult ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCDRResult( $s_CDRResult );
        return true;
    }

    /* Valida y establece el valor del campo CodigoHashQR */
    public function setCodigoHashQR( $u_CodigoHashQR, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $u_CodigoHashQR, "MEDIUMTEXT", 0, 0, false ) )
            {
                throw new Exception( "El campo CodigoHashQR ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCodigoHashQR( $u_CodigoHashQR );
        return true;
    }

    /* Valida y establece el valor del campo CodigoHash */
    public function setCodigoHash( $s_CodigoHash, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CodigoHash, "VARCHAR", 100, 0, false ) )
            {
                throw new Exception( "El campo CodigoHash ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCodigoHash( $s_CodigoHash );
        return true;
    }

    /* Valida y establece el valor del campo Errors */
    public function setErrors( $u_Errors, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $u_Errors, "TEXT", 0, 0, false ) )
            {
                throw new Exception( "El campo Errors ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setErrors( $u_Errors );
        return true;
    }

    /* Valida y establece el valor del campo CodigoError */
    public function setCodigoError( $s_CodigoError, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CodigoError, "VARCHAR", 4, 0, false ) )
            {
                throw new Exception( "El campo CodigoError ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCodigoError( $s_CodigoError );
        return true;
    }

    /* Valida y establece el valor del campo CodigoErrorDesc */
    public function setCodigoErrorDesc( $s_CodigoErrorDesc, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CodigoErrorDesc, "VARCHAR", 500, 0, false ) )
            {
                throw new Exception( "El campo CodigoErrorDesc ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCodigoErrorDesc( $s_CodigoErrorDesc );
        return true;
    }

    /* Valida y establece el valor del campo AnuNumero */
    public function setAnuNumero( $i_AnuNumero, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_AnuNumero, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo AnuNumero ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAnuNumero( $i_AnuNumero );
        return true;
    }

    /* Valida y establece el valor del campo AnuEnlace */
    public function setAnuEnlace( $s_AnuEnlace, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_AnuEnlace, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo AnuEnlace ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAnuEnlace( $s_AnuEnlace );
        return true;
    }

    /* Valida y establece el valor del campo AnuSunatTicketNumero */
    public function setAnuSunatTicketNumero( $s_AnuSunatTicketNumero, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_AnuSunatTicketNumero, "VARCHAR", 45, 0, false ) )
            {
                throw new Exception( "El campo AnuSunatTicketNumero ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAnuSunatTicketNumero( $s_AnuSunatTicketNumero );
        return true;
    }

    /* Valida y establece el valor del campo AnuMotivo */
    public function setAnuMotivo( $s_AnuMotivo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_AnuMotivo, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo AnuMotivo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAnuMotivo( $s_AnuMotivo );
        return true;
    }

    /* Valida y establece el valor del campo AnuAceptadaPorSunat */
    public function setAnuAceptadaPorSunat( $s_AnuAceptadaPorSunat, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_AnuAceptadaPorSunat, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo AnuAceptadaPorSunat ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAnuAceptadaPorSunat( $s_AnuAceptadaPorSunat );
        return true;
    }

    /* Valida y establece el valor del campo AnuSunatDescripcion */
    public function setAnuSunatDescripcion( $s_AnuSunatDescripcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_AnuSunatDescripcion, "VARCHAR", 1000, 0, false ) )
            {
                throw new Exception( "El campo AnuSunatDescripcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAnuSunatDescripcion( $s_AnuSunatDescripcion );
        return true;
    }

    /* Valida y establece el valor del campo AnuSunatNote */
    public function setAnuSunatNote( $s_AnuSunatNote, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_AnuSunatNote, "VARCHAR", 500, 0, false ) )
            {
                throw new Exception( "El campo AnuSunatNote ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAnuSunatNote( $s_AnuSunatNote );
        return true;
    }

    /* Valida y establece el valor del campo AnuSunatResponseCode */
    public function setAnuSunatResponseCode( $s_AnuSunatResponseCode, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_AnuSunatResponseCode, "VARCHAR", 4, 0, false ) )
            {
                throw new Exception( "El campo AnuSunatResponseCode ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAnuSunatResponseCode( $s_AnuSunatResponseCode );
        return true;
    }

    /* Valida y establece el valor del campo AnuSunatSoapError */
    public function setAnuSunatSoapError( $s_AnuSunatSoapError, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_AnuSunatSoapError, "VARCHAR", 500, 0, false ) )
            {
                throw new Exception( "El campo AnuSunatSoapError ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAnuSunatSoapError( $s_AnuSunatSoapError );
        return true;
    }

    /* Valida y establece el valor del campo AnuPDFResult */
    public function setAnuPDFResult( $s_AnuPDFResult, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_AnuPDFResult, "VARCHAR", 500, 0, false ) )
            {
                throw new Exception( "El campo AnuPDFResult ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAnuPDFResult( $s_AnuPDFResult );
        return true;
    }

    /* Valida y establece el valor del campo AnuXMLResult */
    public function setAnuXMLResult( $s_AnuXMLResult, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_AnuXMLResult, "VARCHAR", 500, 0, false ) )
            {
                throw new Exception( "El campo AnuXMLResult ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAnuXMLResult( $s_AnuXMLResult );
        return true;
    }

    /* Valida y establece el valor del campo AnuCDRResult */
    public function setAnuCDRResult( $s_AnuCDRResult, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_AnuCDRResult, "VARCHAR", 500, 0, false ) )
            {
                throw new Exception( "El campo AnuCDRResult ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAnuCDRResult( $s_AnuCDRResult );
        return true;
    }

    /* Valida y establece el valor del campo AnuKey */
    public function setAnuKey( $s_AnuKey, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_AnuKey, "VARCHAR", 150, 0, false ) )
            {
                throw new Exception( "El campo AnuKey ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAnuKey( $s_AnuKey );
        return true;
    }

    /* Valida y establece el valor del campo DataJson */
    public function setDataJson( $u_DataJson, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $u_DataJson, "MEDIUMTEXT", 0, 0, false ) )
            {
                throw new Exception( "El campo DataJson ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDataJson( $u_DataJson );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setFactElecId( $this->getFactElecId(), false );
        $this->setIdCompania( $this->getIdCompania(), true );
        $this->setIdSucursal( $this->getIdSucursal(), true );
        $this->setTipo( $this->getTipo(), true );
        $this->setSerie( $this->getSerie(), true );
        $this->setNumero( $this->getNumero(), true );
        $this->setFechaEmision( $this->getFechaEmision(), true );
        $this->setFechaVencimiento( $this->getFechaVencimiento(), true );
        $this->setTipoComprobante( $this->getTipoComprobante(), true );
        $this->setTipoComprobanteDesc( $this->getTipoComprobanteDesc(), true );
        $this->setSerieNum( $this->getSerieNum(), true );
        $this->setCodCliente( $this->getCodCliente(), true );
        $this->setClienteNom( $this->getClienteNom(), true );
        $this->setClienteTipoDoc( $this->getClienteTipoDoc(), true );
        $this->setClienteDocNum( $this->getClienteDocNum(), true );
        $this->setClienteDireccion( $this->getClienteDireccion(), true );
        $this->setClienteEmail( $this->getClienteEmail(), true );
        $this->setClienteEmail1( $this->getClienteEmail1(), true );
        $this->setClienteEmail2( $this->getClienteEmail2(), true );
        $this->setTipoMoneda( $this->getTipoMoneda(), true );
        $this->setTipoCambio( $this->getTipoCambio(), true );
        $this->setPorcentajeIGV( $this->getPorcentajeIGV(), true );
        $this->setMontoDescuento( $this->getMontoDescuento(), true );
        $this->setMontoDescuentoLinea( $this->getMontoDescuentoLinea(), true );
        $this->setMontoAnticipo( $this->getMontoAnticipo(), true );
        $this->setMontoExonerado( $this->getMontoExonerado(), true );
        $this->setMontoAfecto( $this->getMontoAfecto(), true );
        $this->setMontoInafecto( $this->getMontoInafecto(), true );
        $this->setSubTotal( $this->getSubTotal(), true );
        $this->setImpuesto( $this->getImpuesto(), true );
        $this->setMontoTotal( $this->getMontoTotal(), true );
        $this->setEstadoWeb( $this->getEstadoWeb(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setFechaAnulacion( $this->getFechaAnulacion(), true );
        $this->setEnlace( $this->getEnlace(), true );
        $this->setAceptadaxSunat( $this->getAceptadaxSunat(), true );
        $this->setSunatDescripcion( $this->getSunatDescripcion(), true );
        $this->setSunatNote( $this->getSunatNote(), true );
        $this->setSunatResponseCode( $this->getSunatResponseCode(), true );
        $this->setSunatSoapError( $this->getSunatSoapError(), true );
        $this->setPDFResult( $this->getPDFResult(), true );
        $this->setXMLResult( $this->getXMLResult(), true );
        $this->setCDRResult( $this->getCDRResult(), true );
        $this->setCodigoHashQR( $this->getCodigoHashQR(), true );
        $this->setCodigoHash( $this->getCodigoHash(), true );
        $this->setErrors( $this->getErrors(), true );
        $this->setCodigoError( $this->getCodigoError(), true );
        $this->setCodigoErrorDesc( $this->getCodigoErrorDesc(), true );
        $this->setAnuNumero( $this->getAnuNumero(), true );
        $this->setAnuEnlace( $this->getAnuEnlace(), true );
        $this->setAnuSunatTicketNumero( $this->getAnuSunatTicketNumero(), true );
        $this->setAnuMotivo( $this->getAnuMotivo(), true );
        $this->setAnuAceptadaPorSunat( $this->getAnuAceptadaPorSunat(), true );
        $this->setAnuSunatDescripcion( $this->getAnuSunatDescripcion(), true );
        $this->setAnuSunatNote( $this->getAnuSunatNote(), true );
        $this->setAnuSunatResponseCode( $this->getAnuSunatResponseCode(), true );
        $this->setAnuSunatSoapError( $this->getAnuSunatSoapError(), true );
        $this->setAnuPDFResult( $this->getAnuPDFResult(), true );
        $this->setAnuXMLResult( $this->getAnuXMLResult(), true );
        $this->setAnuCDRResult( $this->getAnuCDRResult(), true );
        $this->setAnuKey( $this->getAnuKey(), true );
        $this->setDataJson( $this->getDataJson(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        return true;
    }
}
?>