<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: VTA_DocumentoDetalle.xml */
/* Generado: 2022-08-08 22:21:39 */

/* Validacion del contenido de los campos campos de la tabla VTA_DocumentoDetalle */
abstract class BaseVTA_DocumentoDetalleBV extends VTA_DocumentoDetalleBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdTipoDocumento */
    public function setIdTipoDocumento( $s_IdTipoDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdTipoDocumento, "CHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo IdTipoDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTipoDocumento( $s_IdTipoDocumento );
        return true;
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo NumeroDocumento */
    public function setNumeroDocumento( $s_NumeroDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NumeroDocumento, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo NumeroDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNumeroDocumento( $s_NumeroDocumento );
        return true;
    }

    /* Valida y establece el valor del campo Secuencia */
    public function setSecuencia( $i_Secuencia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_Secuencia, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo Secuencia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSecuencia( $i_Secuencia );
        return true;
    }

    /* Valida y establece el valor del campo TipoDetalle */
    public function setTipoDetalle( $s_TipoDetalle, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoDetalle, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo TipoDetalle ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoDetalle( $s_TipoDetalle );
        return true;
    }

    /* Valida y establece el valor del campo ItemCodigo */
    public function setItemCodigo( $s_ItemCodigo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ItemCodigo, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo ItemCodigo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setItemCodigo( $s_ItemCodigo );
        return true;
    }

    /* Valida y establece el valor del campo Lote */
    public function setLote( $s_Lote, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Lote, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo Lote ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setLote( $s_Lote );
        return true;
    }

    /* Valida y establece el valor del campo LoteAlias */
    public function setLoteAlias( $s_LoteAlias, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_LoteAlias, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo LoteAlias ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setLoteAlias( $s_LoteAlias );
        return true;
    }

    /* Valida y establece el valor del campo FechaVencimiento */
    public function setFechaVencimiento( $d_FechaVencimiento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaVencimiento, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaVencimiento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaVencimiento( $d_FechaVencimiento );
        return true;
    }

    /* Valida y establece el valor del campo IdItemTipo */
    public function setIdItemTipo( $s_IdItemTipo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdItemTipo, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo IdItemTipo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdItemTipo( $s_IdItemTipo );
        return true;
    }

    /* Valida y establece el valor del campo IdUnidad */
    public function setIdUnidad( $i_IdUnidad, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdUnidad, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdUnidad ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdUnidad( $i_IdUnidad );
        return true;
    }

    /* Valida y establece el valor del campo Condicion */
    public function setCondicion( $s_Condicion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Condicion, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Condicion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCondicion( $s_Condicion );
        return true;
    }

    /* Valida y establece el valor del campo IdTipoPrecio */
    public function setIdTipoPrecio( $s_IdTipoPrecio, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdTipoPrecio, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo IdTipoPrecio ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTipoPrecio( $s_IdTipoPrecio );
        return true;
    }

    /* Valida y establece el valor del campo CodigoProductoSunat */
    public function setCodigoProductoSunat( $s_CodigoProductoSunat, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CodigoProductoSunat, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo CodigoProductoSunat ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCodigoProductoSunat( $s_CodigoProductoSunat );
        return true;
    }

    /* Valida y establece el valor del campo Descripcion */
    public function setDescripcion( $s_Descripcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Descripcion, "VARCHAR", 255, 0, false ) )
            {
                throw new Exception( "El campo Descripcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcion( $s_Descripcion );
        return true;
    }

    /* Valida y establece el valor del campo CantidadPedida */
    public function setCantidadPedida( $f_CantidadPedida, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_CantidadPedida, "DECIMAL", 12, 2, false ) )
            {
                throw new Exception( "El campo CantidadPedida ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCantidadPedida( $f_CantidadPedida );
        return true;
    }

    /* Valida y establece el valor del campo CantidadRecibida */
    public function setCantidadRecibida( $f_CantidadRecibida, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_CantidadRecibida, "DECIMAL", 10, 2, false ) )
            {
                throw new Exception( "El campo CantidadRecibida ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCantidadRecibida( $f_CantidadRecibida );
        return true;
    }

    /* Valida y establece el valor del campo CostoUnitarioProm */
    public function setCostoUnitarioProm( $f_CostoUnitarioProm, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_CostoUnitarioProm, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo CostoUnitarioProm ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCostoUnitarioProm( $f_CostoUnitarioProm );
        return true;
    }

    /* Valida y establece el valor del campo CostoUnitarioMN */
    public function setCostoUnitarioMN( $f_CostoUnitarioMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_CostoUnitarioMN, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo CostoUnitarioMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCostoUnitarioMN( $f_CostoUnitarioMN );
        return true;
    }

    /* Valida y establece el valor del campo PrecioUnitarioMN */
    public function setPrecioUnitarioMN( $f_PrecioUnitarioMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioUnitarioMN, "DECIMAL", 16, 10, false ) )
            {
                throw new Exception( "El campo PrecioUnitarioMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioUnitarioMN( $f_PrecioUnitarioMN );
        return true;
    }

    /* Valida y establece el valor del campo PrecioUnitario */
    public function setPrecioUnitario( $f_PrecioUnitario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioUnitario, "DECIMAL", 16, 10, false ) )
            {
                throw new Exception( "El campo PrecioUnitario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioUnitario( $f_PrecioUnitario );
        return true;
    }

    /* Valida y establece el valor del campo MontoDescuentoMN */
    public function setMontoDescuentoMN( $f_MontoDescuentoMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoDescuentoMN, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoDescuentoMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoDescuentoMN( $f_MontoDescuentoMN );
        return true;
    }

    /* Valida y establece el valor del campo MontoDescuento */
    public function setMontoDescuento( $f_MontoDescuento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoDescuento, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoDescuento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoDescuento( $f_MontoDescuento );
        return true;
    }

    /* Valida y establece el valor del campo MontoImpuestoUnidad */
    public function setMontoImpuestoUnidad( $f_MontoImpuestoUnidad, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoImpuestoUnidad, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoImpuestoUnidad ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoImpuestoUnidad( $f_MontoImpuestoUnidad );
        return true;
    }

    /* Valida y establece el valor del campo MontoImpuestoUnidadMN */
    public function setMontoImpuestoUnidadMN( $f_MontoImpuestoUnidadMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoImpuestoUnidadMN, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoImpuestoUnidadMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoImpuestoUnidadMN( $f_MontoImpuestoUnidadMN );
        return true;
    }

    /* Valida y establece el valor del campo MontoIncImpuestoUnidad */
    public function setMontoIncImpuestoUnidad( $f_MontoIncImpuestoUnidad, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoIncImpuestoUnidad, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoIncImpuestoUnidad ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoIncImpuestoUnidad( $f_MontoIncImpuestoUnidad );
        return true;
    }

    /* Valida y establece el valor del campo MontoIncImpuestoUnidadMN */
    public function setMontoIncImpuestoUnidadMN( $f_MontoIncImpuestoUnidadMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoIncImpuestoUnidadMN, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoIncImpuestoUnidadMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoIncImpuestoUnidadMN( $f_MontoIncImpuestoUnidadMN );
        return true;
    }

    /* Valida y establece el valor del campo MontoSubTotal */
    public function setMontoSubTotal( $f_MontoSubTotal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoSubTotal, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoSubTotal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoSubTotal( $f_MontoSubTotal );
        return true;
    }

    /* Valida y establece el valor del campo MontoSubTotalMN */
    public function setMontoSubTotalMN( $f_MontoSubTotalMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoSubTotalMN, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoSubTotalMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoSubTotalMN( $f_MontoSubTotalMN );
        return true;
    }

    /* Valida y establece el valor del campo MontoSubTotalImpuesto */
    public function setMontoSubTotalImpuesto( $f_MontoSubTotalImpuesto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoSubTotalImpuesto, "DECIMAL", 16, 10, false ) )
            {
                throw new Exception( "El campo MontoSubTotalImpuesto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoSubTotalImpuesto( $f_MontoSubTotalImpuesto );
        return true;
    }

    /* Valida y establece el valor del campo MontoSubTotalImpuestoMN */
    public function setMontoSubTotalImpuestoMN( $f_MontoSubTotalImpuestoMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoSubTotalImpuestoMN, "DECIMAL", 16, 10, false ) )
            {
                throw new Exception( "El campo MontoSubTotalImpuestoMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoSubTotalImpuestoMN( $f_MontoSubTotalImpuestoMN );
        return true;
    }

    /* Valida y establece el valor del campo MontoTotalNeto */
    public function setMontoTotalNeto( $f_MontoTotalNeto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoTotalNeto, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoTotalNeto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoTotalNeto( $f_MontoTotalNeto );
        return true;
    }

    /* Valida y establece el valor del campo MontoTotalNetoMN */
    public function setMontoTotalNetoMN( $f_MontoTotalNetoMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoTotalNetoMN, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoTotalNetoMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoTotalNetoMN( $f_MontoTotalNetoMN );
        return true;
    }

    /* Valida y establece el valor del campo IGVExoneradoFlag */
    public function setIGVExoneradoFlag( $s_IGVExoneradoFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IGVExoneradoFlag, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo IGVExoneradoFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIGVExoneradoFlag( $s_IGVExoneradoFlag );
        return true;
    }

    /* Valida y establece el valor del campo TipoIGV */
    public function setTipoIGV( $s_TipoIGV, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoIGV, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo TipoIGV ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoIGV( $s_TipoIGV );
        return true;
    }

    /* Valida y establece el valor del campo PorcentajeImpuesto */
    public function setPorcentajeImpuesto( $i_PorcentajeImpuesto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_PorcentajeImpuesto, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo PorcentajeImpuesto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPorcentajeImpuesto( $i_PorcentajeImpuesto );
        return true;
    }

    /* Valida y establece el valor del campo AlmacenCodigo */
    public function setAlmacenCodigo( $s_AlmacenCodigo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_AlmacenCodigo, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo AlmacenCodigo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAlmacenCodigo( $s_AlmacenCodigo );
        return true;
    }

    /* Valida y establece el valor del campo NumeroPromocion */
    public function setNumeroPromocion( $s_NumeroPromocion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NumeroPromocion, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo NumeroPromocion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNumeroPromocion( $s_NumeroPromocion );
        return true;
    }

    /* Valida y establece el valor del campo RefParent */
    public function setRefParent( $i_RefParent, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_RefParent, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo RefParent ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setRefParent( $i_RefParent );
        return true;
    }

    /* Valida y establece el valor del campo RefTipoParent */
    public function setRefTipoParent( $s_RefTipoParent, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_RefTipoParent, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo RefTipoParent ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setRefTipoParent( $s_RefTipoParent );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo CentroCosto */
    public function setCentroCosto( $s_CentroCosto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CentroCosto, "CHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo CentroCosto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCentroCosto( $s_CentroCosto );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdTipoDocumento( $this->getIdTipoDocumento(), false );
        $this->setIdCompania( $this->getIdCompania(), false );
        $this->setNumeroDocumento( $this->getNumeroDocumento(), false );
        $this->setSecuencia( $this->getSecuencia(), false );
        $this->setTipoDetalle( $this->getTipoDetalle(), true );
        $this->setItemCodigo( $this->getItemCodigo(), true );
        $this->setLote( $this->getLote(), true );
        $this->setLoteAlias( $this->getLoteAlias(), true );
        $this->setFechaVencimiento( $this->getFechaVencimiento(), true );
        $this->setIdItemTipo( $this->getIdItemTipo(), true );
        $this->setIdUnidad( $this->getIdUnidad(), true );
        $this->setCondicion( $this->getCondicion(), true );
        $this->setIdTipoPrecio( $this->getIdTipoPrecio(), true );
        $this->setCodigoProductoSunat( $this->getCodigoProductoSunat(), true );
        $this->setDescripcion( $this->getDescripcion(), true );
        $this->setCantidadPedida( $this->getCantidadPedida(), true );
        $this->setCantidadRecibida( $this->getCantidadRecibida(), true );
        $this->setCostoUnitarioProm( $this->getCostoUnitarioProm(), true );
        $this->setCostoUnitarioMN( $this->getCostoUnitarioMN(), true );
        $this->setPrecioUnitarioMN( $this->getPrecioUnitarioMN(), true );
        $this->setPrecioUnitario( $this->getPrecioUnitario(), true );
        $this->setMontoDescuentoMN( $this->getMontoDescuentoMN(), true );
        $this->setMontoDescuento( $this->getMontoDescuento(), true );
        $this->setMontoImpuestoUnidad( $this->getMontoImpuestoUnidad(), true );
        $this->setMontoImpuestoUnidadMN( $this->getMontoImpuestoUnidadMN(), true );
        $this->setMontoIncImpuestoUnidad( $this->getMontoIncImpuestoUnidad(), true );
        $this->setMontoIncImpuestoUnidadMN( $this->getMontoIncImpuestoUnidadMN(), true );
        $this->setMontoSubTotal( $this->getMontoSubTotal(), true );
        $this->setMontoSubTotalMN( $this->getMontoSubTotalMN(), true );
        $this->setMontoSubTotalImpuesto( $this->getMontoSubTotalImpuesto(), true );
        $this->setMontoSubTotalImpuestoMN( $this->getMontoSubTotalImpuestoMN(), true );
        $this->setMontoTotalNeto( $this->getMontoTotalNeto(), true );
        $this->setMontoTotalNetoMN( $this->getMontoTotalNetoMN(), true );
        $this->setIGVExoneradoFlag( $this->getIGVExoneradoFlag(), true );
        $this->setTipoIGV( $this->getTipoIGV(), true );
        $this->setPorcentajeImpuesto( $this->getPorcentajeImpuesto(), true );
        $this->setAlmacenCodigo( $this->getAlmacenCodigo(), true );
        $this->setNumeroPromocion( $this->getNumeroPromocion(), true );
        $this->setRefParent( $this->getRefParent(), true );
        $this->setRefTipoParent( $this->getRefTipoParent(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setCentroCosto( $this->getCentroCosto(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        return true;
    }
}
?>