<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: TR_RutaDetGuias.xml */
/* Generado: 2021-06-27 08:47:44 */

/* Validacion del contenido de los campos campos de la tabla TR_RutaDetGuias */
abstract class BaseTR_RutaDetGuiasBV extends TR_RutaDetGuiasBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo DetGuiaId */
    public function setDetGuiaId( $i_DetGuiaId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_DetGuiaId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo DetGuiaId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDetGuiaId( $i_DetGuiaId );
        return true;
    }

    /* Valida y establece el valor del campo IdRuta */
    public function setIdRuta( $i_IdRuta, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdRuta, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdRuta ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdRuta( $i_IdRuta );
        return true;
    }

    /* Valida y establece el valor del campo IdRutaLinea */
    public function setIdRutaLinea( $i_IdRutaLinea, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdRutaLinea, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdRutaLinea ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdRutaLinea( $i_IdRutaLinea );
        return true;
    }

    /* Valida y establece el valor del campo TipoDocumentoRef */
    public function setTipoDocumentoRef( $s_TipoDocumentoRef, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoDocumentoRef, "VARCHAR", 5, 0, false ) )
            {
                throw new Exception( "El campo TipoDocumentoRef ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoDocumentoRef( $s_TipoDocumentoRef );
        return true;
    }

    /* Valida y establece el valor del campo SerieDocumentoRef */
    public function setSerieDocumentoRef( $s_SerieDocumentoRef, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_SerieDocumentoRef, "VARCHAR", 5, 0, false ) )
            {
                throw new Exception( "El campo SerieDocumentoRef ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSerieDocumentoRef( $s_SerieDocumentoRef );
        return true;
    }

    /* Valida y establece el valor del campo NumeroDocumentoRef */
    public function setNumeroDocumentoRef( $s_NumeroDocumentoRef, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NumeroDocumentoRef, "VARCHAR", 15, 0, false ) )
            {
                throw new Exception( "El campo NumeroDocumentoRef ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNumeroDocumentoRef( $s_NumeroDocumentoRef );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setDetGuiaId( $this->getDetGuiaId(), false );
        $this->setIdRuta( $this->getIdRuta(), true );
        $this->setIdRutaLinea( $this->getIdRutaLinea(), true );
        $this->setTipoDocumentoRef( $this->getTipoDocumentoRef(), true );
        $this->setSerieDocumentoRef( $this->getSerieDocumentoRef(), true );
        $this->setNumeroDocumentoRef( $this->getNumeroDocumentoRef(), true );
        return true;
    }
}
?>