<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SR_LoteEscaneo.xml */
/* Generado: 2020-08-18 04:21:31 */

/* Validacion del contenido de los campos campos de la tabla SR_LoteEscaneo */
abstract class BaseSR_LoteEscaneoBV extends SR_LoteEscaneoBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo MovimientoDetalleId */
    public function setMovimientoDetalleId( $i_MovimientoDetalleId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_MovimientoDetalleId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo MovimientoDetalleId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMovimientoDetalleId( $i_MovimientoDetalleId );
        return true;
    }

    /* Valida y establece el valor del campo Secuencia */
    public function setSecuencia( $i_Secuencia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_Secuencia, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo Secuencia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSecuencia( $i_Secuencia );
        return true;
    }

    /* Valida y establece el valor del campo Lote */
    public function setLote( $s_Lote, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Lote, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo Lote ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setLote( $s_Lote );
        return true;
    }

    /* Valida y establece el valor del campo Cantidad */
    public function setCantidad( $f_Cantidad, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_Cantidad, "DECIMAL", 6, 2, false ) )
            {
                throw new Exception( "El campo Cantidad ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCantidad( $f_Cantidad );
        return true;
    }

    /* Valida y establece el valor del campo Fecha */
    public function setFecha( $d_Fecha, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_Fecha, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo Fecha ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFecha( $d_Fecha );
        return true;
    }

    /* Valida y establece el valor del campo Comentario */
    public function setComentario( $u_Comentario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $u_Comentario, "TEXT", 0, 0, false ) )
            {
                throw new Exception( "El campo Comentario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setComentario( $u_Comentario );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioRegistro */
    public function setUsuarioRegistro( $s_UsuarioRegistro, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioRegistro, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo UsuarioRegistro ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioRegistro( $s_UsuarioRegistro );
        return true;
    }

    /* Valida y establece el valor del campo FechaRegistro */
    public function setFechaRegistro( $d_FechaRegistro, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaRegistro, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaRegistro ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaRegistro( $d_FechaRegistro );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setMovimientoDetalleId( $this->getMovimientoDetalleId(), false );
        $this->setSecuencia( $this->getSecuencia(), false );
        $this->setLote( $this->getLote(), true );
        $this->setCantidad( $this->getCantidad(), true );
        $this->setFecha( $this->getFecha(), true );
        $this->setComentario( $this->getComentario(), true );
        $this->setUsuarioRegistro( $this->getUsuarioRegistro(), true );
        $this->setFechaRegistro( $this->getFechaRegistro(), true );
        return true;
    }
}
?>