<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SR_DevolucionLimpieza.xml */
/* Generado: 2021-07-03 05:25:44 */

/* Validacion del contenido de los campos campos de la tabla SR_DevolucionLimpieza */
abstract class BaseSR_DevolucionLimpiezaBV extends SR_DevolucionLimpiezaBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo LimpiezaId */
    public function setLimpiezaId( $i_LimpiezaId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_LimpiezaId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo LimpiezaId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setLimpiezaId( $i_LimpiezaId );
        return true;
    }

    /* Valida y establece el valor del campo Descripcion */
    public function setDescripcion( $s_Descripcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Descripcion, "VARCHAR", 100, 0, false ) )
            {
                throw new Exception( "El campo Descripcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcion( $s_Descripcion );
        return true;
    }

    /* Valida y establece el valor del campo Cantidad */
    public function setCantidad( $f_Cantidad, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_Cantidad, "DECIMAL", 10, 2, false ) )
            {
                throw new Exception( "El campo Cantidad ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCantidad( $f_Cantidad );
        return true;
    }

    /* Valida y establece el valor del campo Tipo */
    public function setTipo( $s_Tipo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Tipo, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo Tipo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipo( $s_Tipo );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setLimpiezaId( $this->getLimpiezaId(), false );
        $this->setDescripcion( $this->getDescripcion(), true );
        $this->setCantidad( $this->getCantidad(), true );
        $this->setTipo( $this->getTipo(), true );
        return true;
    }
}
?>