<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SR_CotizacionDevolucionCab.xml */
/* Generado: 2021-06-25 09:58:00 */

/* Validacion del contenido de los campos campos de la tabla SR_CotizacionDevolucionCab */
abstract class BaseSR_CotizacionDevolucionCabBV extends SR_CotizacionDevolucionCabBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo CotiDevolucionId */
    public function setCotiDevolucionId( $i_CotiDevolucionId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_CotiDevolucionId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo CotiDevolucionId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCotiDevolucionId( $i_CotiDevolucionId );
        return true;
    }

    /* Valida y establece el valor del campo IdProyecto */
    public function setIdProyecto( $i_IdProyecto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdProyecto, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdProyecto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdProyecto( $i_IdProyecto );
        return true;
    }

    /* Valida y establece el valor del campo NumeroDocumento */
    public function setNumeroDocumento( $s_NumeroDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NumeroDocumento, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo NumeroDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNumeroDocumento( $s_NumeroDocumento );
        return true;
    }

    /* Valida y establece el valor del campo OrdenId */
    public function setOrdenId( $i_OrdenId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_OrdenId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo OrdenId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenId( $i_OrdenId );
        return true;
    }

    /* Valida y establece el valor del campo OrdenTipoComercialId */
    public function setOrdenTipoComercialId( $i_OrdenTipoComercialId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_OrdenTipoComercialId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo OrdenTipoComercialId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenTipoComercialId( $i_OrdenTipoComercialId );
        return true;
    }

    /* Valida y establece el valor del campo OrdenTipoClasificacionId */
    public function setOrdenTipoClasificacionId( $i_OrdenTipoClasificacionId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_OrdenTipoClasificacionId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo OrdenTipoClasificacionId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenTipoClasificacionId( $i_OrdenTipoClasificacionId );
        return true;
    }

    /* Valida y establece el valor del campo IdItem */
    public function setIdItem( $s_IdItem, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdItem, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo IdItem ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdItem( $s_IdItem );
        return true;
    }

    /* Valida y establece el valor del campo IdUnidad */
    public function setIdUnidad( $i_IdUnidad, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdUnidad, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdUnidad ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdUnidad( $i_IdUnidad );
        return true;
    }

    /* Valida y establece el valor del campo ItemDescripcion */
    public function setItemDescripcion( $s_ItemDescripcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ItemDescripcion, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo ItemDescripcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setItemDescripcion( $s_ItemDescripcion );
        return true;
    }

    /* Valida y establece el valor del campo ContadorGuia */
    public function setContadorGuia( $i_ContadorGuia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_ContadorGuia, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo ContadorGuia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setContadorGuia( $i_ContadorGuia );
        return true;
    }

    /* Valida y establece el valor del campo CantidadPedida */
    public function setCantidadPedida( $f_CantidadPedida, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_CantidadPedida, "DECIMAL", 10, 2, false ) )
            {
                throw new Exception( "El campo CantidadPedida ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCantidadPedida( $f_CantidadPedida );
        return true;
    }

    /* Valida y establece el valor del campo CantidadDevuelto */
    public function setCantidadDevuelto( $f_CantidadDevuelto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_CantidadDevuelto, "DECIMAL", 10, 2, false ) )
            {
                throw new Exception( "El campo CantidadDevuelto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCantidadDevuelto( $f_CantidadDevuelto );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setCotiDevolucionId( $this->getCotiDevolucionId(), false );
        $this->setIdProyecto( $this->getIdProyecto(), true );
        $this->setNumeroDocumento( $this->getNumeroDocumento(), true );
        $this->setOrdenId( $this->getOrdenId(), true );
        $this->setOrdenTipoComercialId( $this->getOrdenTipoComercialId(), true );
        $this->setOrdenTipoClasificacionId( $this->getOrdenTipoClasificacionId(), true );
        $this->setIdItem( $this->getIdItem(), true );
        $this->setIdUnidad( $this->getIdUnidad(), true );
        $this->setItemDescripcion( $this->getItemDescripcion(), true );
        $this->setContadorGuia( $this->getContadorGuia(), true );
        $this->setCantidadPedida( $this->getCantidadPedida(), true );
        $this->setCantidadDevuelto( $this->getCantidadDevuelto(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        return true;
    }
}
?>