<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SEG_SubSistema.xml */
/* Generado: 2020-08-18 04:21:30 */

/* Validacion del contenido de los campos campos de la tabla SEG_SubSistema */
abstract class BaseSEG_SubSistemaBV extends SEG_SubSistemaBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdSubSistema */
    public function setIdSubSistema( $s_IdSubSistema, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdSubSistema, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdSubSistema ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSubSistema( $s_IdSubSistema );
        return true;
    }

    /* Valida y establece el valor del campo SubSistemaDescripcion */
    public function setSubSistemaDescripcion( $s_SubSistemaDescripcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_SubSistemaDescripcion, "VARCHAR", 255, 0, false ) )
            {
                throw new Exception( "El campo SubSistemaDescripcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSubSistemaDescripcion( $s_SubSistemaDescripcion );
        return true;
    }

    /* Valida y establece el valor del campo SubSistemaDir */
    public function setSubSistemaDir( $s_SubSistemaDir, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_SubSistemaDir, "VARCHAR", 255, 0, false ) )
            {
                throw new Exception( "El campo SubSistemaDir ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSubSistemaDir( $s_SubSistemaDir );
        return true;
    }

    /* Valida y establece el valor del campo TareaPrefijo */
    public function setTareaPrefijo( $s_TareaPrefijo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TareaPrefijo, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo TareaPrefijo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTareaPrefijo( $s_TareaPrefijo );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdSubSistema( $this->getIdSubSistema(), false );
        $this->setSubSistemaDescripcion( $this->getSubSistemaDescripcion(), true );
        $this->setSubSistemaDir( $this->getSubSistemaDir(), true );
        $this->setTareaPrefijo( $this->getTareaPrefijo(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        return true;
    }
}
?>