<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: products.xml */
/* Generado: 2020-08-18 04:21:32 */

/* Validacion del contenido de los campos campos de la tabla products */
abstract class BaseProductsBV extends ProductsBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo id */
    public function setId( $i_Id, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_Id, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo id ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setId( $i_Id );
        return true;
    }

    /* Valida y establece el valor del campo name */
    public function setName( $s_Name, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Name, "VARCHAR", 255, 0, false ) )
            {
                throw new Exception( "El campo name ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setName( $s_Name );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setId( $this->getId(), false );
        $this->setName( $this->getName(), true );
        return true;
    }
}
?>