<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: PR_TipoGrupo.xml */
/* Generado: 2020-08-18 04:21:29 */

/* Validacion del contenido de los campos campos de la tabla PR_TipoGrupo */
abstract class BasePR_TipoGrupoBV extends PR_TipoGrupoBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdPrTipoId */
    public function setIdPrTipoId( $s_IdPrTipoId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdPrTipoId, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo IdPrTipoId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdPrTipoId( $s_IdPrTipoId );
        return true;
    }

    /* Valida y establece el valor del campo Nombre */
    public function setNombre( $s_Nombre, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Nombre, "VARCHAR", 150, 0, false ) )
            {
                throw new Exception( "El campo Nombre ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNombre( $s_Nombre );
        return true;
    }

    /* Valida y establece el valor del campo PrefijoTipo */
    public function setPrefijoTipo( $s_PrefijoTipo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_PrefijoTipo, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo PrefijoTipo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrefijoTipo( $s_PrefijoTipo );
        return true;
    }

    /* Valida y establece el valor del campo Secuencia */
    public function setSecuencia( $s_Secuencia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Secuencia, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo Secuencia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSecuencia( $s_Secuencia );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdPrTipoId( $this->getIdPrTipoId(), false );
        $this->setNombre( $this->getNombre(), true );
        $this->setPrefijoTipo( $this->getPrefijoTipo(), true );
        $this->setSecuencia( $this->getSecuencia(), true );
        return true;
    }
}
?>