<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: PR_ListaItem.xml */
/* Generado: 2020-08-18 04:21:29 */

/* Validacion del contenido de los campos campos de la tabla PR_ListaItem */
abstract class BasePR_ListaItemBV extends PR_ListaItemBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdPrListaItem */
    public function setIdPrListaItem( $i_IdPrListaItem, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdPrListaItem, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdPrListaItem ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdPrListaItem( $i_IdPrListaItem );
        return true;
    }

    /* Valida y establece el valor del campo IdPrGrupo */
    public function setIdPrGrupo( $s_IdPrGrupo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdPrGrupo, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdPrGrupo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdPrGrupo( $s_IdPrGrupo );
        return true;
    }

    /* Valida y establece el valor del campo TipoPrecio */
    public function setTipoPrecio( $i_TipoPrecio, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_TipoPrecio, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo TipoPrecio ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoPrecio( $i_TipoPrecio );
        return true;
    }

    /* Valida y establece el valor del campo IdItem */
    public function setIdItem( $s_IdItem, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdItem, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo IdItem ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdItem( $s_IdItem );
        return true;
    }

    /* Valida y establece el valor del campo PrecioVenta */
    public function setPrecioVenta( $f_PrecioVenta, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioVenta, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioVenta ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioVenta( $f_PrecioVenta );
        return true;
    }

    /* Valida y establece el valor del campo PrecioDscto */
    public function setPrecioDscto( $f_PrecioDscto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioDscto, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioDscto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioDscto( $f_PrecioDscto );
        return true;
    }

    /* Valida y establece el valor del campo BufferDscto */
    public function setBufferDscto( $f_BufferDscto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_BufferDscto, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo BufferDscto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setBufferDscto( $f_BufferDscto );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdPrListaItem( $this->getIdPrListaItem(), false );
        $this->setIdPrGrupo( $this->getIdPrGrupo(), true );
        $this->setTipoPrecio( $this->getTipoPrecio(), true );
        $this->setIdItem( $this->getIdItem(), true );
        $this->setPrecioVenta( $this->getPrecioVenta(), true );
        $this->setPrecioDscto( $this->getPrecioDscto(), true );
        $this->setBufferDscto( $this->getBufferDscto(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        return true;
    }
}
?>