<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: PR_AccesoRestriccion.xml */
/* Generado: 2020-08-18 04:21:29 */

/* Validacion del contenido de los campos campos de la tabla PR_AccesoRestriccion */
abstract class BasePR_AccesoRestriccionBV extends PR_AccesoRestriccionBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdPrAccRes */
    public function setIdPrAccRes( $i_IdPrAccRes, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdPrAccRes, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdPrAccRes ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdPrAccRes( $i_IdPrAccRes );
        return true;
    }

    /* Valida y establece el valor del campo IdPrGrupo */
    public function setIdPrGrupo( $s_IdPrGrupo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdPrGrupo, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdPrGrupo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdPrGrupo( $s_IdPrGrupo );
        return true;
    }

    /* Valida y establece el valor del campo Tipo */
    public function setTipo( $s_Tipo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Tipo, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo Tipo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipo( $s_Tipo );
        return true;
    }

    /* Valida y establece el valor del campo TipoCondicion */
    public function setTipoCondicion( $s_TipoCondicion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoCondicion, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo TipoCondicion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoCondicion( $s_TipoCondicion );
        return true;
    }

    /* Valida y establece el valor del campo Valor */
    public function setValor( $s_Valor, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Valor, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo Valor ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setValor( $s_Valor );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdPrAccRes( $this->getIdPrAccRes(), false );
        $this->setIdPrGrupo( $this->getIdPrGrupo(), true );
        $this->setTipo( $this->getTipo(), true );
        $this->setTipoCondicion( $this->getTipoCondicion(), true );
        $this->setValor( $this->getValor(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        return true;
    }
}
?>