<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: PLA_MarcacionEmpleado.xml */
/* Generado: 2020-08-18 04:21:29 */

/* Validacion del contenido de los campos campos de la tabla PLA_MarcacionEmpleado */
abstract class BasePLA_MarcacionEmpleadoBV extends PLA_MarcacionEmpleadoBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdDiaSem */
    public function setIdDiaSem( $i_IdDiaSem, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdDiaSem, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdDiaSem ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdDiaSem( $i_IdDiaSem );
        return true;
    }

    /* Valida y establece el valor del campo IdTipo */
    public function setIdTipo( $s_IdTipo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdTipo, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo IdTipo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTipo( $s_IdTipo );
        return true;
    }

    /* Valida y establece el valor del campo IdRegistro */
    public function setIdRegistro( $s_IdRegistro, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdRegistro, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo IdRegistro ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdRegistro( $s_IdRegistro );
        return true;
    }

    /* Valida y establece el valor del campo IdPersona */
    public function setIdPersona( $i_IdPersona, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdPersona, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdPersona ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdPersona( $i_IdPersona );
        return true;
    }

    /* Valida y establece el valor del campo HoraMinutoDesde */
    public function setHoraMinutoDesde( $s_HoraMinutoDesde, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_HoraMinutoDesde, "VARCHAR", 7, 0, false ) )
            {
                throw new Exception( "El campo HoraMinutoDesde ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setHoraMinutoDesde( $s_HoraMinutoDesde );
        return true;
    }

    /* Valida y establece el valor del campo HoraMinutoHasta */
    public function setHoraMinutoHasta( $s_HoraMinutoHasta, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_HoraMinutoHasta, "VARCHAR", 7, 0, false ) )
            {
                throw new Exception( "El campo HoraMinutoHasta ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setHoraMinutoHasta( $s_HoraMinutoHasta );
        return true;
    }

    /* Valida y establece el valor del campo DiaSiguienteFlag */
    public function setDiaSiguienteFlag( $i_DiaSiguienteFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_DiaSiguienteFlag, "TINYINT", 4, 0, false ) )
            {
                throw new Exception( "El campo DiaSiguienteFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDiaSiguienteFlag( $i_DiaSiguienteFlag );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo Eliminado */
    public function setEliminado( $i_Eliminado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_Eliminado, "TINYINT", 4, 0, false ) )
            {
                throw new Exception( "El campo Eliminado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEliminado( $i_Eliminado );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioEliminado */
    public function setUsuarioEliminado( $s_UsuarioEliminado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioEliminado, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioEliminado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioEliminado( $s_UsuarioEliminado );
        return true;
    }

    /* Valida y establece el valor del campo FechaEliminado */
    public function setFechaEliminado( $d_FechaEliminado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaEliminado, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaEliminado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaEliminado( $d_FechaEliminado );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdDiaSem( $this->getIdDiaSem(), false );
        $this->setIdTipo( $this->getIdTipo(), false );
        $this->setIdRegistro( $this->getIdRegistro(), false );
        $this->setIdPersona( $this->getIdPersona(), false );
        $this->setHoraMinutoDesde( $this->getHoraMinutoDesde(), true );
        $this->setHoraMinutoHasta( $this->getHoraMinutoHasta(), true );
        $this->setDiaSiguienteFlag( $this->getDiaSiguienteFlag(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setEliminado( $this->getEliminado(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioEliminado( $this->getUsuarioEliminado(), true );
        $this->setFechaEliminado( $this->getFechaEliminado(), true );
        return true;
    }
}
?>