<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: PLA_Asistencia.xml */
/* Generado: 2020-08-18 04:21:29 */

/* Validacion del contenido de los campos campos de la tabla PLA_Asistencia */
abstract class BasePLA_AsistenciaBV extends PLA_AsistenciaBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdAsistencia */
    public function setIdAsistencia( $i_IdAsistencia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdAsistencia, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdAsistencia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdAsistencia( $i_IdAsistencia );
        return true;
    }

    /* Valida y establece el valor del campo IdDiaSem */
    public function setIdDiaSem( $i_IdDiaSem, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdDiaSem, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdDiaSem ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdDiaSem( $i_IdDiaSem );
        return true;
    }

    /* Valida y establece el valor del campo IdRegistro */
    public function setIdRegistro( $s_IdRegistro, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdRegistro, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo IdRegistro ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdRegistro( $s_IdRegistro );
        return true;
    }

    /* Valida y establece el valor del campo IdTipo */
    public function setIdTipo( $s_IdTipo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdTipo, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo IdTipo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTipo( $s_IdTipo );
        return true;
    }

    /* Valida y establece el valor del campo IdPersona */
    public function setIdPersona( $i_IdPersona, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdPersona, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdPersona ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdPersona( $i_IdPersona );
        return true;
    }

    /* Valida y establece el valor del campo Fecha */
    public function setFecha( $d_Fecha, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_Fecha, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo Fecha ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFecha( $d_Fecha );
        return true;
    }

    /* Valida y establece el valor del campo TipoDocumento */
    public function setTipoDocumento( $s_TipoDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoDocumento, "VARCHAR", 5, 0, false ) )
            {
                throw new Exception( "El campo TipoDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoDocumento( $s_TipoDocumento );
        return true;
    }

    /* Valida y establece el valor del campo NumeroDocumento */
    public function setNumeroDocumento( $s_NumeroDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NumeroDocumento, "VARCHAR", 15, 0, false ) )
            {
                throw new Exception( "El campo NumeroDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNumeroDocumento( $s_NumeroDocumento );
        return true;
    }

    /* Valida y establece el valor del campo HoraMinuto */
    public function setHoraMinuto( $d_HoraMinuto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_HoraMinuto, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo HoraMinuto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setHoraMinuto( $d_HoraMinuto );
        return true;
    }

    /* Valida y establece el valor del campo HoraMinutoPactado */
    public function setHoraMinutoPactado( $d_HoraMinutoPactado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_HoraMinutoPactado, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo HoraMinutoPactado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setHoraMinutoPactado( $d_HoraMinutoPactado );
        return true;
    }

    /* Valida y establece el valor del campo MontoDescuento */
    public function setMontoDescuento( $f_MontoDescuento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoDescuento, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoDescuento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoDescuento( $f_MontoDescuento );
        return true;
    }

    /* Valida y establece el valor del campo IdAsistenciaRef */
    public function setIdAsistenciaRef( $i_IdAsistenciaRef, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdAsistenciaRef, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdAsistenciaRef ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdAsistenciaRef( $i_IdAsistenciaRef );
        return true;
    }

    /* Valida y establece el valor del campo DiaSiguienteFlag */
    public function setDiaSiguienteFlag( $i_DiaSiguienteFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_DiaSiguienteFlag, "TINYINT", 4, 0, false ) )
            {
                throw new Exception( "El campo DiaSiguienteFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDiaSiguienteFlag( $i_DiaSiguienteFlag );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo Eliminado */
    public function setEliminado( $i_Eliminado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_Eliminado, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo Eliminado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEliminado( $i_Eliminado );
        return true;
    }

    /* Valida y establece el valor del campo MotivoEliminado */
    public function setMotivoEliminado( $s_MotivoEliminado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_MotivoEliminado, "VARCHAR", 400, 0, false ) )
            {
                throw new Exception( "El campo MotivoEliminado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMotivoEliminado( $s_MotivoEliminado );
        return true;
    }

    /* Valida y establece el valor del campo FechaEliminado */
    public function setFechaEliminado( $d_FechaEliminado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaEliminado, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaEliminado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaEliminado( $d_FechaEliminado );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioEliminado */
    public function setUsuarioEliminado( $s_UsuarioEliminado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioEliminado, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioEliminado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioEliminado( $s_UsuarioEliminado );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdAsistencia( $this->getIdAsistencia(), false );
        $this->setIdDiaSem( $this->getIdDiaSem(), true );
        $this->setIdRegistro( $this->getIdRegistro(), true );
        $this->setIdTipo( $this->getIdTipo(), true );
        $this->setIdPersona( $this->getIdPersona(), true );
        $this->setFecha( $this->getFecha(), true );
        $this->setTipoDocumento( $this->getTipoDocumento(), true );
        $this->setNumeroDocumento( $this->getNumeroDocumento(), true );
        $this->setHoraMinuto( $this->getHoraMinuto(), true );
        $this->setHoraMinutoPactado( $this->getHoraMinutoPactado(), true );
        $this->setMontoDescuento( $this->getMontoDescuento(), true );
        $this->setIdAsistenciaRef( $this->getIdAsistenciaRef(), true );
        $this->setDiaSiguienteFlag( $this->getDiaSiguienteFlag(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setEliminado( $this->getEliminado(), true );
        $this->setMotivoEliminado( $this->getMotivoEliminado(), true );
        $this->setFechaEliminado( $this->getFechaEliminado(), true );
        $this->setUsuarioEliminado( $this->getUsuarioEliminado(), true );
        return true;
    }
}
?>