<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_TipoNotaCredito.xml */
/* Generado: 2022-03-27 14:30:18 */

/* Validacion del contenido de los campos campos de la tabla MST_TipoNotaCredito */
abstract class BaseMST_TipoNotaCreditoBV extends MST_TipoNotaCreditoBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo Id */
    public function setId( $i_Id, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_Id, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo Id ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setId( $i_Id );
        return true;
    }

    /* Valida y establece el valor del campo CodigoSunat */
    public function setCodigoSunat( $s_CodigoSunat, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CodigoSunat, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo CodigoSunat ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCodigoSunat( $s_CodigoSunat );
        return true;
    }

    /* Valida y establece el valor del campo Descripcion */
    public function setDescripcion( $s_Descripcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Descripcion, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo Descripcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcion( $s_Descripcion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setId( $this->getId(), false );
        $this->setCodigoSunat( $this->getCodigoSunat(), true );
        $this->setDescripcion( $this->getDescripcion(), true );
        return true;
    }
}
?>