<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_ReferenciaProductoColor.xml */
/* Generado: 2024-08-02 05:22:56 */

/* Validacion del contenido de los campos campos de la tabla MST_ReferenciaProductoColor */
abstract class BaseMST_ReferenciaProductoColorBV extends MST_ReferenciaProductoColorBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdReferencia */
    public function setIdReferencia( $i_IdReferencia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdReferencia, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdReferencia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdReferencia( $i_IdReferencia );
        return true;
    }

    /* Valida y establece el valor del campo IdColor */
    public function setIdColor( $i_IdColor, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdColor, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdColor ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdColor( $i_IdColor );
        return true;
    }

    /* Valida y establece el valor del campo ImagenFlag */
    public function setImagenFlag( $i_ImagenFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_ImagenFlag, "TINYINT", 3, 0, false ) )
            {
                throw new Exception( "El campo ImagenFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setImagenFlag( $i_ImagenFlag );
        return true;
    }

    /* Valida y establece el valor del campo ImagenReferenciaNombre */
    public function setImagenReferenciaNombre( $s_ImagenReferenciaNombre, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ImagenReferenciaNombre, "VARCHAR", 500, 0, false ) )
            {
                throw new Exception( "El campo ImagenReferenciaNombre ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setImagenReferenciaNombre( $s_ImagenReferenciaNombre );
        return true;
    }

    /* Valida y establece el valor del campo ImagenReferenciaFisico */
    public function setImagenReferenciaFisico( $s_ImagenReferenciaFisico, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ImagenReferenciaFisico, "VARCHAR", 500, 0, false ) )
            {
                throw new Exception( "El campo ImagenReferenciaFisico ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setImagenReferenciaFisico( $s_ImagenReferenciaFisico );
        return true;
    }

    /* Valida y establece el valor del campo ImagenReferenciaWeb */
    public function setImagenReferenciaWeb( $s_ImagenReferenciaWeb, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ImagenReferenciaWeb, "VARCHAR", 500, 0, false ) )
            {
                throw new Exception( "El campo ImagenReferenciaWeb ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setImagenReferenciaWeb( $s_ImagenReferenciaWeb );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdReferencia( $this->getIdReferencia(), false );
        $this->setIdColor( $this->getIdColor(), false );
        $this->setImagenFlag( $this->getImagenFlag(), true );
        $this->setImagenReferenciaNombre( $this->getImagenReferenciaNombre(), true );
        $this->setImagenReferenciaFisico( $this->getImagenReferenciaFisico(), true );
        $this->setImagenReferenciaWeb( $this->getImagenReferenciaWeb(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        return true;
    }
}
?>