<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_PersonaEmpleado.xml */
/* Generado: 2020-08-18 04:21:28 */

/* Validacion del contenido de los campos campos de la tabla MST_PersonaEmpleado */
abstract class BaseMST_PersonaEmpleadoBV extends MST_PersonaEmpleadoBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdPersona */
    public function setIdPersona( $i_IdPersona, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdPersona, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdPersona ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdPersona( $i_IdPersona );
        return true;
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo IdSede */
    public function setIdSede( $i_IdSede, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSede, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSede ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSede( $i_IdSede );
        return true;
    }

    /* Valida y establece el valor del campo IdCargo */
    public function setIdCargo( $i_IdCargo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCargo, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCargo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCargo( $i_IdCargo );
        return true;
    }

    /* Valida y establece el valor del campo EmpleadoNombres */
    public function setEmpleadoNombres( $s_EmpleadoNombres, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EmpleadoNombres, "VARCHAR", 150, 0, false ) )
            {
                throw new Exception( "El campo EmpleadoNombres ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEmpleadoNombres( $s_EmpleadoNombres );
        return true;
    }

    /* Valida y establece el valor del campo EmpleadoApellidoPaterno */
    public function setEmpleadoApellidoPaterno( $s_EmpleadoApellidoPaterno, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EmpleadoApellidoPaterno, "VARCHAR", 150, 0, false ) )
            {
                throw new Exception( "El campo EmpleadoApellidoPaterno ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEmpleadoApellidoPaterno( $s_EmpleadoApellidoPaterno );
        return true;
    }

    /* Valida y establece el valor del campo EmpleadoApellidoMaterno */
    public function setEmpleadoApellidoMaterno( $s_EmpleadoApellidoMaterno, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EmpleadoApellidoMaterno, "VARCHAR", 150, 0, false ) )
            {
                throw new Exception( "El campo EmpleadoApellidoMaterno ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEmpleadoApellidoMaterno( $s_EmpleadoApellidoMaterno );
        return true;
    }

    /* Valida y establece el valor del campo TipoDocumento */
    public function setTipoDocumento( $s_TipoDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoDocumento, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo TipoDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoDocumento( $s_TipoDocumento );
        return true;
    }

    /* Valida y establece el valor del campo NumeroDocumento */
    public function setNumeroDocumento( $s_NumeroDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NumeroDocumento, "VARCHAR", 15, 0, false ) )
            {
                throw new Exception( "El campo NumeroDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNumeroDocumento( $s_NumeroDocumento );
        return true;
    }

    /* Valida y establece el valor del campo Sueldo */
    public function setSueldo( $f_Sueldo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_Sueldo, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo Sueldo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSueldo( $f_Sueldo );
        return true;
    }

    /* Valida y establece el valor del campo FechaInicio */
    public function setFechaInicio( $d_FechaInicio, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaInicio, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaInicio ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaInicio( $d_FechaInicio );
        return true;
    }

    /* Valida y establece el valor del campo FechaCese */
    public function setFechaCese( $d_FechaCese, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCese, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCese ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCese( $d_FechaCese );
        return true;
    }

    /* Valida y establece el valor del campo FlagEstadoAsistencia */
    public function setFlagEstadoAsistencia( $s_FlagEstadoAsistencia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_FlagEstadoAsistencia, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo FlagEstadoAsistencia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFlagEstadoAsistencia( $s_FlagEstadoAsistencia );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdPersona( $this->getIdPersona(), false );
        $this->setIdCompania( $this->getIdCompania(), true );
        $this->setIdSede( $this->getIdSede(), true );
        $this->setIdCargo( $this->getIdCargo(), true );
        $this->setEmpleadoNombres( $this->getEmpleadoNombres(), true );
        $this->setEmpleadoApellidoPaterno( $this->getEmpleadoApellidoPaterno(), true );
        $this->setEmpleadoApellidoMaterno( $this->getEmpleadoApellidoMaterno(), true );
        $this->setTipoDocumento( $this->getTipoDocumento(), true );
        $this->setNumeroDocumento( $this->getNumeroDocumento(), true );
        $this->setSueldo( $this->getSueldo(), true );
        $this->setFechaInicio( $this->getFechaInicio(), true );
        $this->setFechaCese( $this->getFechaCese(), true );
        $this->setFlagEstadoAsistencia( $this->getFlagEstadoAsistencia(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        return true;
    }
}
?>