<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_Pais.xml */
/* Generado: 2021-08-07 04:50:36 */

/* Validacion del contenido de los campos campos de la tabla MST_Pais */
abstract class BaseMST_PaisBV extends MST_PaisBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo Id */
    public function setId( $s_Id, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Id, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo Id ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setId( $s_Id );
        return true;
    }

    /* Valida y establece el valor del campo Nombre */
    public function setNombre( $s_Nombre, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Nombre, "VARCHAR", 200, 0, false ) )
            {
                throw new Exception( "El campo Nombre ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNombre( $s_Nombre );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setId( $this->getId(), false );
        $this->setNombre( $this->getNombre(), true );
        return true;
    }
}
?>