<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_Division.xml */
/* Generado: 2020-08-18 04:21:27 */

/* Validacion del contenido de los campos campos de la tabla MST_Division */
abstract class BaseMST_DivisionBV extends MST_DivisionBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo DivisionId */
    public function setDivisionId( $i_DivisionId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_DivisionId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo DivisionId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDivisionId( $i_DivisionId );
        return true;
    }

    /* Valida y establece el valor del campo DivisionDescripcion */
    public function setDivisionDescripcion( $s_DivisionDescripcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DivisionDescripcion, "VARCHAR", 100, 0, false ) )
            {
                throw new Exception( "El campo DivisionDescripcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDivisionDescripcion( $s_DivisionDescripcion );
        return true;
    }

    /* Valida y establece el valor del campo DivisionEstado */
    public function setDivisionEstado( $s_DivisionEstado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DivisionEstado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo DivisionEstado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDivisionEstado( $s_DivisionEstado );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setDivisionId( $this->getDivisionId(), false );
        $this->setDivisionDescripcion( $this->getDivisionDescripcion(), true );
        $this->setDivisionEstado( $this->getDivisionEstado(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        return true;
    }
}
?>