<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MKT_PromocionCab.xml */
/* Generado: 2022-02-09 07:47:18 */

/* Validacion del contenido de los campos campos de la tabla MKT_PromocionCab */
abstract class BaseMKT_PromocionCabBV extends MKT_PromocionCabBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdPromoCab */
    public function setIdPromoCab( $i_IdPromoCab, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdPromoCab, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdPromoCab ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdPromoCab( $i_IdPromoCab );
        return true;
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo IdSucursal */
    public function setIdSucursal( $i_IdSucursal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSucursal, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSucursal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSucursal( $i_IdSucursal );
        return true;
    }

    /* Valida y establece el valor del campo IdAlmacen */
    public function setIdAlmacen( $s_IdAlmacen, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdAlmacen, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdAlmacen ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdAlmacen( $s_IdAlmacen );
        return true;
    }

    /* Valida y establece el valor del campo IdItemTipo */
    public function setIdItemTipo( $s_IdItemTipo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdItemTipo, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo IdItemTipo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdItemTipo( $s_IdItemTipo );
        return true;
    }

    /* Valida y establece el valor del campo CodigoPromo */
    public function setCodigoPromo( $s_CodigoPromo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CodigoPromo, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo CodigoPromo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCodigoPromo( $s_CodigoPromo );
        return true;
    }

    /* Valida y establece el valor del campo DescripcionPromo */
    public function setDescripcionPromo( $s_DescripcionPromo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DescripcionPromo, "VARCHAR", 100, 0, false ) )
            {
                throw new Exception( "El campo DescripcionPromo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcionPromo( $s_DescripcionPromo );
        return true;
    }

    /* Valida y establece el valor del campo FechaInicio */
    public function setFechaInicio( $d_FechaInicio, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaInicio, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaInicio ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaInicio( $d_FechaInicio );
        return true;
    }

    /* Valida y establece el valor del campo FechaFin */
    public function setFechaFin( $d_FechaFin, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaFin, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaFin ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaFin( $d_FechaFin );
        return true;
    }

    /* Valida y establece el valor del campo EstadoPromo */
    public function setEstadoPromo( $s_EstadoPromo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EstadoPromo, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo EstadoPromo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstadoPromo( $s_EstadoPromo );
        return true;
    }

    /* Valida y establece el valor del campo CantidadPromo */
    public function setCantidadPromo( $i_CantidadPromo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_CantidadPromo, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo CantidadPromo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCantidadPromo( $i_CantidadPromo );
        return true;
    }

    /* Valida y establece el valor del campo CantidadFacturado */
    public function setCantidadFacturado( $i_CantidadFacturado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_CantidadFacturado, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo CantidadFacturado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCantidadFacturado( $i_CantidadFacturado );
        return true;
    }

    /* Valida y establece el valor del campo CostoConIGVPromo */
    public function setCostoConIGVPromo( $f_CostoConIGVPromo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_CostoConIGVPromo, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo CostoConIGVPromo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCostoConIGVPromo( $f_CostoConIGVPromo );
        return true;
    }

    /* Valida y establece el valor del campo PrecioSinIGVPromo */
    public function setPrecioSinIGVPromo( $f_PrecioSinIGVPromo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioSinIGVPromo, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioSinIGVPromo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioSinIGVPromo( $f_PrecioSinIGVPromo );
        return true;
    }

    /* Valida y establece el valor del campo MontoIGVPromo */
    public function setMontoIGVPromo( $f_MontoIGVPromo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoIGVPromo, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoIGVPromo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoIGVPromo( $f_MontoIGVPromo );
        return true;
    }

    /* Valida y establece el valor del campo PrecioConIGVPromo */
    public function setPrecioConIGVPromo( $f_PrecioConIGVPromo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioConIGVPromo, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioConIGVPromo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioConIGVPromo( $f_PrecioConIGVPromo );
        return true;
    }

    /* Valida y establece el valor del campo DescuentoTotalPromo */
    public function setDescuentoTotalPromo( $f_DescuentoTotalPromo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_DescuentoTotalPromo, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo DescuentoTotalPromo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescuentoTotalPromo( $f_DescuentoTotalPromo );
        return true;
    }

    /* Valida y establece el valor del campo ComentarioPromo */
    public function setComentarioPromo( $s_ComentarioPromo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ComentarioPromo, "VARCHAR", 1000, 0, false ) )
            {
                throw new Exception( "El campo ComentarioPromo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setComentarioPromo( $s_ComentarioPromo );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 60, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdPromoCab( $this->getIdPromoCab(), false );
        $this->setIdCompania( $this->getIdCompania(), true );
        $this->setIdSucursal( $this->getIdSucursal(), true );
        $this->setIdAlmacen( $this->getIdAlmacen(), true );
        $this->setIdItemTipo( $this->getIdItemTipo(), true );
        $this->setCodigoPromo( $this->getCodigoPromo(), true );
        $this->setDescripcionPromo( $this->getDescripcionPromo(), true );
        $this->setFechaInicio( $this->getFechaInicio(), true );
        $this->setFechaFin( $this->getFechaFin(), true );
        $this->setEstadoPromo( $this->getEstadoPromo(), true );
        $this->setCantidadPromo( $this->getCantidadPromo(), true );
        $this->setCantidadFacturado( $this->getCantidadFacturado(), true );
        $this->setCostoConIGVPromo( $this->getCostoConIGVPromo(), true );
        $this->setPrecioSinIGVPromo( $this->getPrecioSinIGVPromo(), true );
        $this->setMontoIGVPromo( $this->getMontoIGVPromo(), true );
        $this->setPrecioConIGVPromo( $this->getPrecioConIGVPromo(), true );
        $this->setDescuentoTotalPromo( $this->getDescuentoTotalPromo(), true );
        $this->setComentarioPromo( $this->getComentarioPromo(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        return true;
    }
}
?>