<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: GSS_SucursalDocumento.xml */
/* Generado: 2020-08-18 04:21:26 */

/* Validacion del contenido de los campos campos de la tabla GSS_SucursalDocumento */
abstract class BaseGSS_SucursalDocumentoBV extends GSS_SucursalDocumentoBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdSucursalDocumento */
    public function setIdSucursalDocumento( $i_IdSucursalDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSucursalDocumento, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSucursalDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSucursalDocumento( $i_IdSucursalDocumento );
        return true;
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo IdSucursal */
    public function setIdSucursal( $i_IdSucursal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSucursal, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSucursal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSucursal( $i_IdSucursal );
        return true;
    }

    /* Valida y establece el valor del campo IdTipoDocumento */
    public function setIdTipoDocumento( $s_IdTipoDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdTipoDocumento, "CHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo IdTipoDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTipoDocumento( $s_IdTipoDocumento );
        return true;
    }

    /* Valida y establece el valor del campo DocumentoTicketFlag */
    public function setDocumentoTicketFlag( $s_DocumentoTicketFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DocumentoTicketFlag, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo DocumentoTicketFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDocumentoTicketFlag( $s_DocumentoTicketFlag );
        return true;
    }

    /* Valida y establece el valor del campo AutorizacionSunatTicket */
    public function setAutorizacionSunatTicket( $s_AutorizacionSunatTicket, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_AutorizacionSunatTicket, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo AutorizacionSunatTicket ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAutorizacionSunatTicket( $s_AutorizacionSunatTicket );
        return true;
    }

    /* Valida y establece el valor del campo SerieTicket */
    public function setSerieTicket( $s_SerieTicket, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_SerieTicket, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo SerieTicket ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSerieTicket( $s_SerieTicket );
        return true;
    }

    /* Valida y establece el valor del campo DocumentoFormatoFlag */
    public function setDocumentoFormatoFlag( $s_DocumentoFormatoFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DocumentoFormatoFlag, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo DocumentoFormatoFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDocumentoFormatoFlag( $s_DocumentoFormatoFlag );
        return true;
    }

    /* Valida y establece el valor del campo EmpresaImprimioFormato */
    public function setEmpresaImprimioFormato( $s_EmpresaImprimioFormato, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EmpresaImprimioFormato, "VARCHAR", 60, 0, false ) )
            {
                throw new Exception( "El campo EmpresaImprimioFormato ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEmpresaImprimioFormato( $s_EmpresaImprimioFormato );
        return true;
    }

    /* Valida y establece el valor del campo RUCImprimioFormato */
    public function setRUCImprimioFormato( $s_RUCImprimioFormato, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_RUCImprimioFormato, "VARCHAR", 60, 0, false ) )
            {
                throw new Exception( "El campo RUCImprimioFormato ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setRUCImprimioFormato( $s_RUCImprimioFormato );
        return true;
    }

    /* Valida y establece el valor del campo AutorizacionImprimioFormato */
    public function setAutorizacionImprimioFormato( $s_AutorizacionImprimioFormato, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_AutorizacionImprimioFormato, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo AutorizacionImprimioFormato ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAutorizacionImprimioFormato( $s_AutorizacionImprimioFormato );
        return true;
    }

    /* Valida y establece el valor del campo FechaInicioFormato */
    public function setFechaInicioFormato( $d_FechaInicioFormato, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaInicioFormato, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaInicioFormato ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaInicioFormato( $d_FechaInicioFormato );
        return true;
    }

    /* Valida y establece el valor del campo FechaFinFormato */
    public function setFechaFinFormato( $d_FechaFinFormato, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaFinFormato, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaFinFormato ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaFinFormato( $d_FechaFinFormato );
        return true;
    }

    /* Valida y establece el valor del campo SerieFormato */
    public function setSerieFormato( $s_SerieFormato, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_SerieFormato, "VARCHAR", 4, 0, false ) )
            {
                throw new Exception( "El campo SerieFormato ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSerieFormato( $s_SerieFormato );
        return true;
    }

    /* Valida y establece el valor del campo NumeroActual */
    public function setNumeroActual( $i_NumeroActual, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_NumeroActual, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo NumeroActual ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNumeroActual( $i_NumeroActual );
        return true;
    }

    /* Valida y establece el valor del campo RangoDesdeFormato */
    public function setRangoDesdeFormato( $i_RangoDesdeFormato, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_RangoDesdeFormato, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo RangoDesdeFormato ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setRangoDesdeFormato( $i_RangoDesdeFormato );
        return true;
    }

    /* Valida y establece el valor del campo RangoHastaFormato */
    public function setRangoHastaFormato( $i_RangoHastaFormato, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_RangoHastaFormato, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo RangoHastaFormato ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setRangoHastaFormato( $i_RangoHastaFormato );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdSucursalDocumento( $this->getIdSucursalDocumento(), false );
        $this->setIdCompania( $this->getIdCompania(), true );
        $this->setIdSucursal( $this->getIdSucursal(), true );
        $this->setIdTipoDocumento( $this->getIdTipoDocumento(), true );
        $this->setDocumentoTicketFlag( $this->getDocumentoTicketFlag(), true );
        $this->setAutorizacionSunatTicket( $this->getAutorizacionSunatTicket(), true );
        $this->setSerieTicket( $this->getSerieTicket(), true );
        $this->setDocumentoFormatoFlag( $this->getDocumentoFormatoFlag(), true );
        $this->setEmpresaImprimioFormato( $this->getEmpresaImprimioFormato(), true );
        $this->setRUCImprimioFormato( $this->getRUCImprimioFormato(), true );
        $this->setAutorizacionImprimioFormato( $this->getAutorizacionImprimioFormato(), true );
        $this->setFechaInicioFormato( $this->getFechaInicioFormato(), true );
        $this->setFechaFinFormato( $this->getFechaFinFormato(), true );
        $this->setSerieFormato( $this->getSerieFormato(), true );
        $this->setNumeroActual( $this->getNumeroActual(), true );
        $this->setRangoDesdeFormato( $this->getRangoDesdeFormato(), true );
        $this->setRangoHastaFormato( $this->getRangoHastaFormato(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        return true;
    }
}
?>