<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: GSS_Impuesto.xml */
/* Generado: 2021-10-11 19:18:18 */

/* Validacion del contenido de los campos campos de la tabla GSS_Impuesto */
abstract class BaseGSS_ImpuestoBV extends GSS_ImpuestoBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdImpuesto */
    public function setIdImpuesto( $i_IdImpuesto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdImpuesto, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdImpuesto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdImpuesto( $i_IdImpuesto );
        return true;
    }

    /* Valida y establece el valor del campo Codigo */
    public function setCodigo( $s_Codigo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Codigo, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo Codigo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCodigo( $s_Codigo );
        return true;
    }

    /* Valida y establece el valor del campo Descripcion */
    public function setDescripcion( $s_Descripcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Descripcion, "VARCHAR", 200, 0, false ) )
            {
                throw new Exception( "El campo Descripcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcion( $s_Descripcion );
        return true;
    }

    /* Valida y establece el valor del campo Valor */
    public function setValor( $f_Valor, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_Valor, "DECIMAL", 10, 2, false ) )
            {
                throw new Exception( "El campo Valor ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setValor( $f_Valor );
        return true;
    }

    /* Valida y establece el valor del campo CodigoSunat */
    public function setCodigoSunat( $s_CodigoSunat, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CodigoSunat, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo CodigoSunat ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCodigoSunat( $s_CodigoSunat );
        return true;
    }

    /* Valida y establece el valor del campo CuentaContable */
    public function setCuentaContable( $s_CuentaContable, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CuentaContable, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo CuentaContable ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCuentaContable( $s_CuentaContable );
        return true;
    }

    /* Valida y establece el valor del campo TipoRegistro */
    public function setTipoRegistro( $s_TipoRegistro, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoRegistro, "VARCHAR", 15, 0, false ) )
            {
                throw new Exception( "El campo TipoRegistro ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoRegistro( $s_TipoRegistro );
        return true;
    }

    /* Valida y establece el valor del campo FechaDesde */
    public function setFechaDesde( $d_FechaDesde, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaDesde, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaDesde ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaDesde( $d_FechaDesde );
        return true;
    }

    /* Valida y establece el valor del campo FechaHasta */
    public function setFechaHasta( $d_FechaHasta, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaHasta, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaHasta ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaHasta( $d_FechaHasta );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdImpuesto( $this->getIdImpuesto(), false );
        $this->setCodigo( $this->getCodigo(), true );
        $this->setDescripcion( $this->getDescripcion(), true );
        $this->setValor( $this->getValor(), true );
        $this->setCodigoSunat( $this->getCodigoSunat(), true );
        $this->setCuentaContable( $this->getCuentaContable(), true );
        $this->setTipoRegistro( $this->getTipoRegistro(), true );
        $this->setFechaDesde( $this->getFechaDesde(), true );
        $this->setFechaHasta( $this->getFechaHasta(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        return true;
    }
}
?>