<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: GSS_Detraccion.xml */
/* Generado: 2021-10-09 18:38:22 */

/* Validacion del contenido de los campos campos de la tabla GSS_Detraccion */
abstract class BaseGSS_DetraccionBV extends GSS_DetraccionBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdDetraccion */
    public function setIdDetraccion( $i_IdDetraccion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdDetraccion, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdDetraccion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdDetraccion( $i_IdDetraccion );
        return true;
    }

    /* Valida y establece el valor del campo Descripcion */
    public function setDescripcion( $s_Descripcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Descripcion, "VARCHAR", 120, 0, false ) )
            {
                throw new Exception( "El campo Descripcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcion( $s_Descripcion );
        return true;
    }

    /* Valida y establece el valor del campo CodigoSunat */
    public function setCodigoSunat( $s_CodigoSunat, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CodigoSunat, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo CodigoSunat ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCodigoSunat( $s_CodigoSunat );
        return true;
    }

    /* Valida y establece el valor del campo CodigoSunatPr */
    public function setCodigoSunatPr( $s_CodigoSunatPr, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CodigoSunatPr, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo CodigoSunatPr ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCodigoSunatPr( $s_CodigoSunatPr );
        return true;
    }

    /* Valida y establece el valor del campo Porcentaje */
    public function setPorcentaje( $f_Porcentaje, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_Porcentaje, "DECIMAL", 6, 2, false ) )
            {
                throw new Exception( "El campo Porcentaje ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPorcentaje( $f_Porcentaje );
        return true;
    }

    /* Valida y establece el valor del campo MontoMinimo */
    public function setMontoMinimo( $f_MontoMinimo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoMinimo, "DECIMAL", 10, 2, false ) )
            {
                throw new Exception( "El campo MontoMinimo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoMinimo( $f_MontoMinimo );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FehaEliminacion */
    public function setFehaEliminacion( $d_FehaEliminacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FehaEliminacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FehaEliminacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFehaEliminacion( $d_FehaEliminacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioEliminacion */
    public function setUsuarioEliminacion( $s_UsuarioEliminacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioEliminacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioEliminacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioEliminacion( $s_UsuarioEliminacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdDetraccion( $this->getIdDetraccion(), false );
        $this->setDescripcion( $this->getDescripcion(), true );
        $this->setCodigoSunat( $this->getCodigoSunat(), true );
        $this->setCodigoSunatPr( $this->getCodigoSunatPr(), true );
        $this->setPorcentaje( $this->getPorcentaje(), true );
        $this->setMontoMinimo( $this->getMontoMinimo(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFehaEliminacion( $this->getFehaEliminacion(), true );
        $this->setUsuarioEliminacion( $this->getUsuarioEliminacion(), true );
        return true;
    }
}
?>