<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: GSS_CorrelativoMast.xml */
/* Generado: 2020-08-18 04:21:26 */

/* Validacion del contenido de los campos campos de la tabla GSS_CorrelativoMast */
abstract class BaseGSS_CorrelativoMastBV extends GSS_CorrelativoMastBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo IdTipocomprobante */
    public function setIdTipocomprobante( $s_IdTipocomprobante, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdTipocomprobante, "VARCHAR", 6, 0, false ) )
            {
                throw new Exception( "El campo IdTipocomprobante ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTipocomprobante( $s_IdTipocomprobante );
        return true;
    }

    /* Valida y establece el valor del campo IdSerie */
    public function setIdSerie( $s_IdSerie, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdSerie, "VARCHAR", 4, 0, false ) )
            {
                throw new Exception( "El campo IdSerie ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSerie( $s_IdSerie );
        return true;
    }

    /* Valida y establece el valor del campo Descripcion */
    public function setDescripcion( $s_Descripcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Descripcion, "VARCHAR", 80, 0, false ) )
            {
                throw new Exception( "El campo Descripcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcion( $s_Descripcion );
        return true;
    }

    /* Valida y establece el valor del campo CorrelativoNumero */
    public function setCorrelativoNumero( $i_CorrelativoNumero, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_CorrelativoNumero, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo CorrelativoNumero ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCorrelativoNumero( $i_CorrelativoNumero );
        return true;
    }

    /* Valida y establece el valor del campo CorrelativoDesde */
    public function setCorrelativoDesde( $i_CorrelativoDesde, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_CorrelativoDesde, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo CorrelativoDesde ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCorrelativoDesde( $i_CorrelativoDesde );
        return true;
    }

    /* Valida y establece el valor del campo CorrelativoHasta */
    public function setCorrelativoHasta( $i_CorrelativoHasta, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_CorrelativoHasta, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo CorrelativoHasta ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCorrelativoHasta( $i_CorrelativoHasta );
        return true;
    }

    /* Valida y establece el valor del campo AlmacenCodigo */
    public function setAlmacenCodigo( $s_AlmacenCodigo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_AlmacenCodigo, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo AlmacenCodigo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAlmacenCodigo( $s_AlmacenCodigo );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdCompania( $this->getIdCompania(), false );
        $this->setIdTipocomprobante( $this->getIdTipocomprobante(), false );
        $this->setIdSerie( $this->getIdSerie(), false );
        $this->setDescripcion( $this->getDescripcion(), true );
        $this->setCorrelativoNumero( $this->getCorrelativoNumero(), true );
        $this->setCorrelativoDesde( $this->getCorrelativoDesde(), true );
        $this->setCorrelativoHasta( $this->getCorrelativoHasta(), true );
        $this->setAlmacenCodigo( $this->getAlmacenCodigo(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        return true;
    }
}
?>