<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: GSS_Auditoria.xml */
/* Generado: 2020-08-18 04:21:26 */

/* Validacion del contenido de los campos campos de la tabla GSS_Auditoria */
abstract class BaseGSS_AuditoriaBV extends GSS_AuditoriaBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdAuditoria */
    public function setIdAuditoria( $i_IdAuditoria, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdAuditoria, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdAuditoria ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdAuditoria( $i_IdAuditoria );
        return true;
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo Modulo */
    public function setModulo( $s_Modulo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Modulo, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo Modulo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setModulo( $s_Modulo );
        return true;
    }

    /* Valida y establece el valor del campo Sentencia */
    public function setSentencia( $u_Sentencia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $u_Sentencia, "TEXT", 0, 0, false ) )
            {
                throw new Exception( "El campo Sentencia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSentencia( $u_Sentencia );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdAuditoria( $this->getIdAuditoria(), true );
        $this->setIdCompania( $this->getIdCompania(), true );
        $this->setModulo( $this->getModulo(), true );
        $this->setSentencia( $this->getSentencia(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        return true;
    }
}
?>