<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: FCO_CierreAplicacionTipo.xml */
/* Generado: 2020-08-18 04:21:25 */

/* Validacion del contenido de los campos campos de la tabla FCO_CierreAplicacionTipo */
abstract class BaseFCO_CierreAplicacionTipoBV extends FCO_CierreAplicacionTipoBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdCierre */
    public function setIdCierre( $i_IdCierre, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCierre, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCierre ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCierre( $i_IdCierre );
        return true;
    }

    /* Valida y establece el valor del campo IdTipoPago */
    public function setIdTipoPago( $i_IdTipoPago, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdTipoPago, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdTipoPago ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTipoPago( $i_IdTipoPago );
        return true;
    }

    /* Valida y establece el valor del campo IdMoneda */
    public function setIdMoneda( $s_IdMoneda, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdMoneda, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo IdMoneda ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdMoneda( $s_IdMoneda );
        return true;
    }

    /* Valida y establece el valor del campo MonedaDes */
    public function setMonedaDes( $s_MonedaDes, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_MonedaDes, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo MonedaDes ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMonedaDes( $s_MonedaDes );
        return true;
    }

    /* Valida y establece el valor del campo CierreCantTrans */
    public function setCierreCantTrans( $i_CierreCantTrans, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_CierreCantTrans, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo CierreCantTrans ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCierreCantTrans( $i_CierreCantTrans );
        return true;
    }

    /* Valida y establece el valor del campo CierreMontoTrans */
    public function setCierreMontoTrans( $f_CierreMontoTrans, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_CierreMontoTrans, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo CierreMontoTrans ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCierreMontoTrans( $f_CierreMontoTrans );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 60, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdCierre( $this->getIdCierre(), false );
        $this->setIdTipoPago( $this->getIdTipoPago(), false );
        $this->setIdMoneda( $this->getIdMoneda(), false );
        $this->setMonedaDes( $this->getMonedaDes(), true );
        $this->setCierreCantTrans( $this->getCierreCantTrans(), true );
        $this->setCierreMontoTrans( $this->getCierreMontoTrans(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        return true;
    }
}
?>