<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: COM_OrdenCompraDetalle.xml */
/* Generado: 2021-08-14 08:48:00 */

/* Validacion del contenido de los campos campos de la tabla COM_OrdenCompraDetalle */
abstract class BaseCOM_OrdenCompraDetalleBV extends COM_OrdenCompraDetalleBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdOrdenCompra */
    public function setIdOrdenCompra( $i_IdOrdenCompra, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdOrdenCompra, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdOrdenCompra ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdOrdenCompra( $i_IdOrdenCompra );
        return true;
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo IdSecuencia */
    public function setIdSecuencia( $i_IdSecuencia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSecuencia, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSecuencia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSecuencia( $i_IdSecuencia );
        return true;
    }

    /* Valida y establece el valor del campo IdItem */
    public function setIdItem( $s_IdItem, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdItem, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo IdItem ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdItem( $s_IdItem );
        return true;
    }

    /* Valida y establece el valor del campo Descripcion */
    public function setDescripcion( $s_Descripcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Descripcion, "VARCHAR", 300, 0, false ) )
            {
                throw new Exception( "El campo Descripcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcion( $s_Descripcion );
        return true;
    }

    /* Valida y establece el valor del campo CantidadPedida */
    public function setCantidadPedida( $f_CantidadPedida, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_CantidadPedida, "DECIMAL", 10, 2, false ) )
            {
                throw new Exception( "El campo CantidadPedida ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCantidadPedida( $f_CantidadPedida );
        return true;
    }

    /* Valida y establece el valor del campo CantidadRecibida */
    public function setCantidadRecibida( $f_CantidadRecibida, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_CantidadRecibida, "DECIMAL", 10, 2, false ) )
            {
                throw new Exception( "El campo CantidadRecibida ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCantidadRecibida( $f_CantidadRecibida );
        return true;
    }

    /* Valida y establece el valor del campo MuestraUni */
    public function setMuestraUni( $f_MuestraUni, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MuestraUni, "DECIMAL", 10, 2, false ) )
            {
                throw new Exception( "El campo MuestraUni ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMuestraUni( $f_MuestraUni );
        return true;
    }

    /* Valida y establece el valor del campo MuestraKgr */
    public function setMuestraKgr( $f_MuestraKgr, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MuestraKgr, "DECIMAL", 10, 2, false ) )
            {
                throw new Exception( "El campo MuestraKgr ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMuestraKgr( $f_MuestraKgr );
        return true;
    }

    /* Valida y establece el valor del campo IdUnidad */
    public function setIdUnidad( $s_IdUnidad, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdUnidad, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo IdUnidad ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdUnidad( $s_IdUnidad );
        return true;
    }

    /* Valida y establece el valor del campo IdCondicion */
    public function setIdCondicion( $i_IdCondicion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCondicion, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCondicion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCondicion( $i_IdCondicion );
        return true;
    }

    /* Valida y establece el valor del campo IdLote */
    public function setIdLote( $s_IdLote, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdLote, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo IdLote ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdLote( $s_IdLote );
        return true;
    }

    /* Valida y establece el valor del campo FechaVencimiento */
    public function setFechaVencimiento( $d_FechaVencimiento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaVencimiento, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaVencimiento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaVencimiento( $d_FechaVencimiento );
        return true;
    }

    /* Valida y establece el valor del campo PrecioUnitarioInicial */
    public function setPrecioUnitarioInicial( $f_PrecioUnitarioInicial, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioUnitarioInicial, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioUnitarioInicial ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioUnitarioInicial( $f_PrecioUnitarioInicial );
        return true;
    }

    /* Valida y establece el valor del campo PrecioUnitario */
    public function setPrecioUnitario( $f_PrecioUnitario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioUnitario, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioUnitario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioUnitario( $f_PrecioUnitario );
        return true;
    }

    /* Valida y establece el valor del campo PrecioUnitarioFinal */
    public function setPrecioUnitarioFinal( $f_PrecioUnitarioFinal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioUnitarioFinal, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioUnitarioFinal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioUnitarioFinal( $f_PrecioUnitarioFinal );
        return true;
    }

    /* Valida y establece el valor del campo SubTotal */
    public function setSubTotal( $f_SubTotal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_SubTotal, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo SubTotal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSubTotal( $f_SubTotal );
        return true;
    }

    /* Valida y establece el valor del campo ValorIGV */
    public function setValorIGV( $f_ValorIGV, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_ValorIGV, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo ValorIGV ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setValorIGV( $f_ValorIGV );
        return true;
    }

    /* Valida y establece el valor del campo PrecioTotalConIGV */
    public function setPrecioTotalConIGV( $f_PrecioTotalConIGV, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioTotalConIGV, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioTotalConIGV ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioTotalConIGV( $f_PrecioTotalConIGV );
        return true;
    }

    /* Valida y establece el valor del campo IGVExonerado */
    public function setIGVExonerado( $s_IGVExonerado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IGVExonerado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo IGVExonerado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIGVExonerado( $s_IGVExonerado );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo Comentario */
    public function setComentario( $u_Comentario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $u_Comentario, "TEXT", 0, 0, false ) )
            {
                throw new Exception( "El campo Comentario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setComentario( $u_Comentario );
        return true;
    }

    /* Valida y establece el valor del campo Descuento */
    public function setDescuento( $f_Descuento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_Descuento, "DECIMAL", 12, 2, false ) )
            {
                throw new Exception( "El campo Descuento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescuento( $f_Descuento );
        return true;
    }

    /* Valida y establece el valor del campo PrecioUnitarioIGV */
    public function setPrecioUnitarioIGV( $f_PrecioUnitarioIGV, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioUnitarioIGV, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioUnitarioIGV ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioUnitarioIGV( $f_PrecioUnitarioIGV );
        return true;
    }

    /* Valida y establece el valor del campo CostoFinalDolares */
    public function setCostoFinalDolares( $f_CostoFinalDolares, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_CostoFinalDolares, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo CostoFinalDolares ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCostoFinalDolares( $f_CostoFinalDolares );
        return true;
    }

    /* Valida y establece el valor del campo CostoFinalSoles */
    public function setCostoFinalSoles( $f_CostoFinalSoles, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_CostoFinalSoles, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo CostoFinalSoles ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCostoFinalSoles( $f_CostoFinalSoles );
        return true;
    }

    /* Valida y establece el valor del campo IdRequerimientoDetalle */
    public function setIdRequerimientoDetalle( $i_IdRequerimientoDetalle, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdRequerimientoDetalle, "INT", 10, 0, false ) )
            {
                throw new Exception( "El campo IdRequerimientoDetalle ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdRequerimientoDetalle( $i_IdRequerimientoDetalle );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaEntrega */
    public function setFechaEntrega( $d_FechaEntrega, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaEntrega, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaEntrega ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaEntrega( $d_FechaEntrega );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdOrdenCompra( $this->getIdOrdenCompra(), false );
        $this->setIdCompania( $this->getIdCompania(), false );
        $this->setIdSecuencia( $this->getIdSecuencia(), false );
        $this->setIdItem( $this->getIdItem(), true );
        $this->setDescripcion( $this->getDescripcion(), true );
        $this->setCantidadPedida( $this->getCantidadPedida(), true );
        $this->setCantidadRecibida( $this->getCantidadRecibida(), true );
        $this->setMuestraUni( $this->getMuestraUni(), true );
        $this->setMuestraKgr( $this->getMuestraKgr(), true );
        $this->setIdUnidad( $this->getIdUnidad(), true );
        $this->setIdCondicion( $this->getIdCondicion(), true );
        $this->setIdLote( $this->getIdLote(), true );
        $this->setFechaVencimiento( $this->getFechaVencimiento(), true );
        $this->setPrecioUnitarioInicial( $this->getPrecioUnitarioInicial(), true );
        $this->setPrecioUnitario( $this->getPrecioUnitario(), true );
        $this->setPrecioUnitarioFinal( $this->getPrecioUnitarioFinal(), true );
        $this->setSubTotal( $this->getSubTotal(), true );
        $this->setValorIGV( $this->getValorIGV(), true );
        $this->setPrecioTotalConIGV( $this->getPrecioTotalConIGV(), true );
        $this->setIGVExonerado( $this->getIGVExonerado(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setComentario( $this->getComentario(), true );
        $this->setDescuento( $this->getDescuento(), true );
        $this->setPrecioUnitarioIGV( $this->getPrecioUnitarioIGV(), true );
        $this->setCostoFinalDolares( $this->getCostoFinalDolares(), true );
        $this->setCostoFinalSoles( $this->getCostoFinalSoles(), true );
        $this->setIdRequerimientoDetalle( $this->getIdRequerimientoDetalle(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFechaEntrega( $this->getFechaEntrega(), true );
        return true;
    }
}
?>