<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: COM_ImportacionCabecera.xml */
/* Generado: 2021-08-14 18:19:08 */

/* Validacion del contenido de los campos campos de la tabla COM_ImportacionCabecera */
abstract class BaseCOM_ImportacionCabeceraBV extends COM_ImportacionCabeceraBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdOrdenCompra */
    public function setIdOrdenCompra( $i_IdOrdenCompra, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdOrdenCompra, "INT", 10, 0, false ) )
            {
                throw new Exception( "El campo IdOrdenCompra ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdOrdenCompra( $i_IdOrdenCompra );
        return true;
    }

    /* Valida y establece el valor del campo DuaSerie */
    public function setDuaSerie( $s_DuaSerie, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DuaSerie, "VARCHAR", 5, 0, false ) )
            {
                throw new Exception( "El campo DuaSerie ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDuaSerie( $s_DuaSerie );
        return true;
    }

    /* Valida y establece el valor del campo DuaNumero */
    public function setDuaNumero( $s_DuaNumero, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DuaNumero, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo DuaNumero ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDuaNumero( $s_DuaNumero );
        return true;
    }

    /* Valida y establece el valor del campo DuaSerieNumero */
    public function setDuaSerieNumero( $s_DuaSerieNumero, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DuaSerieNumero, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo DuaSerieNumero ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDuaSerieNumero( $s_DuaSerieNumero );
        return true;
    }

    /* Valida y establece el valor del campo DuaPagoFecha */
    public function setDuaPagoFecha( $d_DuaPagoFecha, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_DuaPagoFecha, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo DuaPagoFecha ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDuaPagoFecha( $d_DuaPagoFecha );
        return true;
    }

    /* Valida y establece el valor del campo InvoiceSerie */
    public function setInvoiceSerie( $s_InvoiceSerie, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_InvoiceSerie, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo InvoiceSerie ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setInvoiceSerie( $s_InvoiceSerie );
        return true;
    }

    /* Valida y establece el valor del campo InvoiceNumero */
    public function setInvoiceNumero( $s_InvoiceNumero, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_InvoiceNumero, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo InvoiceNumero ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setInvoiceNumero( $s_InvoiceNumero );
        return true;
    }

    /* Valida y establece el valor del campo InvoiceSerieNumero */
    public function setInvoiceSerieNumero( $s_InvoiceSerieNumero, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_InvoiceSerieNumero, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo InvoiceSerieNumero ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setInvoiceSerieNumero( $s_InvoiceSerieNumero );
        return true;
    }

    /* Valida y establece el valor del campo InvoiceFecha */
    public function setInvoiceFecha( $d_InvoiceFecha, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_InvoiceFecha, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo InvoiceFecha ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setInvoiceFecha( $d_InvoiceFecha );
        return true;
    }

    /* Valida y establece el valor del campo DuaNroOrden */
    public function setDuaNroOrden( $s_DuaNroOrden, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DuaNroOrden, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo DuaNroOrden ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDuaNroOrden( $s_DuaNroOrden );
        return true;
    }

    /* Valida y establece el valor del campo IncotermsCod */
    public function setIncotermsCod( $s_IncotermsCod, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IncotermsCod, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IncotermsCod ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIncotermsCod( $s_IncotermsCod );
        return true;
    }

    /* Valida y establece el valor del campo IncotermsDesc */
    public function setIncotermsDesc( $s_IncotermsDesc, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IncotermsDesc, "VARCHAR", 100, 0, false ) )
            {
                throw new Exception( "El campo IncotermsDesc ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIncotermsDesc( $s_IncotermsDesc );
        return true;
    }

    /* Valida y establece el valor del campo PaisProcedenciaCod */
    public function setPaisProcedenciaCod( $s_PaisProcedenciaCod, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_PaisProcedenciaCod, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo PaisProcedenciaCod ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPaisProcedenciaCod( $s_PaisProcedenciaCod );
        return true;
    }

    /* Valida y establece el valor del campo PaisProcedenciaDesc */
    public function setPaisProcedenciaDesc( $s_PaisProcedenciaDesc, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_PaisProcedenciaDesc, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo PaisProcedenciaDesc ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPaisProcedenciaDesc( $s_PaisProcedenciaDesc );
        return true;
    }

    /* Valida y establece el valor del campo TotalFOB */
    public function setTotalFOB( $f_TotalFOB, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_TotalFOB, "DECIMAL", 20, 6, false ) )
            {
                throw new Exception( "El campo TotalFOB ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTotalFOB( $f_TotalFOB );
        return true;
    }

    /* Valida y establece el valor del campo TotalTransPuerto */
    public function setTotalTransPuerto( $f_TotalTransPuerto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_TotalTransPuerto, "DECIMAL", 20, 6, false ) )
            {
                throw new Exception( "El campo TotalTransPuerto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTotalTransPuerto( $f_TotalTransPuerto );
        return true;
    }

    /* Valida y establece el valor del campo TotalEmicionBL */
    public function setTotalEmicionBL( $f_TotalEmicionBL, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_TotalEmicionBL, "DECIMAL", 20, 6, false ) )
            {
                throw new Exception( "El campo TotalEmicionBL ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTotalEmicionBL( $f_TotalEmicionBL );
        return true;
    }

    /* Valida y establece el valor del campo TotalOtrosGastosEXW */
    public function setTotalOtrosGastosEXW( $f_TotalOtrosGastosEXW, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_TotalOtrosGastosEXW, "DECIMAL", 20, 6, false ) )
            {
                throw new Exception( "El campo TotalOtrosGastosEXW ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTotalOtrosGastosEXW( $f_TotalOtrosGastosEXW );
        return true;
    }

    /* Valida y establece el valor del campo TotalFlete */
    public function setTotalFlete( $f_TotalFlete, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_TotalFlete, "DECIMAL", 20, 6, false ) )
            {
                throw new Exception( "El campo TotalFlete ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTotalFlete( $f_TotalFlete );
        return true;
    }

    /* Valida y establece el valor del campo TotalSeguro */
    public function setTotalSeguro( $f_TotalSeguro, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_TotalSeguro, "DECIMAL", 20, 6, false ) )
            {
                throw new Exception( "El campo TotalSeguro ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTotalSeguro( $f_TotalSeguro );
        return true;
    }

    /* Valida y establece el valor del campo TotalCIF */
    public function setTotalCIF( $f_TotalCIF, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_TotalCIF, "DECIMAL", 20, 6, false ) )
            {
                throw new Exception( "El campo TotalCIF ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTotalCIF( $f_TotalCIF );
        return true;
    }

    /* Valida y establece el valor del campo TipoCambio */
    public function setTipoCambio( $f_TipoCambio, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_TipoCambio, "DECIMAL", 20, 6, false ) )
            {
                throw new Exception( "El campo TipoCambio ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoCambio( $f_TipoCambio );
        return true;
    }

    /* Valida y establece el valor del campo TotalAdValorem */
    public function setTotalAdValorem( $f_TotalAdValorem, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_TotalAdValorem, "DECIMAL", 20, 6, false ) )
            {
                throw new Exception( "El campo TotalAdValorem ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTotalAdValorem( $f_TotalAdValorem );
        return true;
    }

    /* Valida y establece el valor del campo TotalIPM2 */
    public function setTotalIPM2( $f_TotalIPM2, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_TotalIPM2, "DECIMAL", 20, 6, false ) )
            {
                throw new Exception( "El campo TotalIPM2 ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTotalIPM2( $f_TotalIPM2 );
        return true;
    }

    /* Valida y establece el valor del campo TotalIGV16 */
    public function setTotalIGV16( $f_TotalIGV16, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_TotalIGV16, "DECIMAL", 20, 6, false ) )
            {
                throw new Exception( "El campo TotalIGV16 ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTotalIGV16( $f_TotalIGV16 );
        return true;
    }

    /* Valida y establece el valor del campo SumaTotalIGV */
    public function setSumaTotalIGV( $f_SumaTotalIGV, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_SumaTotalIGV, "DECIMAL", 20, 6, false ) )
            {
                throw new Exception( "El campo SumaTotalIGV ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSumaTotalIGV( $f_SumaTotalIGV );
        return true;
    }

    /* Valida y establece el valor del campo TotalServicioDespacho */
    public function setTotalServicioDespacho( $f_TotalServicioDespacho, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_TotalServicioDespacho, "DECIMAL", 20, 6, false ) )
            {
                throw new Exception( "El campo TotalServicioDespacho ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTotalServicioDespacho( $f_TotalServicioDespacho );
        return true;
    }

    /* Valida y establece el valor del campo TotalPercepcion */
    public function setTotalPercepcion( $f_TotalPercepcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_TotalPercepcion, "DECIMAL", 20, 6, false ) )
            {
                throw new Exception( "El campo TotalPercepcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTotalPercepcion( $f_TotalPercepcion );
        return true;
    }

    /* Valida y establece el valor del campo PorIGV */
    public function setPorIGV( $i_PorIGV, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_PorIGV, "INT", 10, 0, false ) )
            {
                throw new Exception( "El campo PorIGV ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPorIGV( $i_PorIGV );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdOrdenCompra( $this->getIdOrdenCompra(), false );
        $this->setDuaSerie( $this->getDuaSerie(), true );
        $this->setDuaNumero( $this->getDuaNumero(), true );
        $this->setDuaSerieNumero( $this->getDuaSerieNumero(), true );
        $this->setDuaPagoFecha( $this->getDuaPagoFecha(), true );
        $this->setInvoiceSerie( $this->getInvoiceSerie(), true );
        $this->setInvoiceNumero( $this->getInvoiceNumero(), true );
        $this->setInvoiceSerieNumero( $this->getInvoiceSerieNumero(), true );
        $this->setInvoiceFecha( $this->getInvoiceFecha(), true );
        $this->setDuaNroOrden( $this->getDuaNroOrden(), true );
        $this->setIncotermsCod( $this->getIncotermsCod(), true );
        $this->setIncotermsDesc( $this->getIncotermsDesc(), true );
        $this->setPaisProcedenciaCod( $this->getPaisProcedenciaCod(), true );
        $this->setPaisProcedenciaDesc( $this->getPaisProcedenciaDesc(), true );
        $this->setTotalFOB( $this->getTotalFOB(), true );
        $this->setTotalTransPuerto( $this->getTotalTransPuerto(), true );
        $this->setTotalEmicionBL( $this->getTotalEmicionBL(), true );
        $this->setTotalOtrosGastosEXW( $this->getTotalOtrosGastosEXW(), true );
        $this->setTotalFlete( $this->getTotalFlete(), true );
        $this->setTotalSeguro( $this->getTotalSeguro(), true );
        $this->setTotalCIF( $this->getTotalCIF(), true );
        $this->setTipoCambio( $this->getTipoCambio(), true );
        $this->setTotalAdValorem( $this->getTotalAdValorem(), true );
        $this->setTotalIPM2( $this->getTotalIPM2(), true );
        $this->setTotalIGV16( $this->getTotalIGV16(), true );
        $this->setSumaTotalIGV( $this->getSumaTotalIGV(), true );
        $this->setTotalServicioDespacho( $this->getTotalServicioDespacho(), true );
        $this->setTotalPercepcion( $this->getTotalPercepcion(), true );
        $this->setPorIGV( $this->getPorIGV(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        return true;
    }
}
?>