<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: CAR_Vehiculo.xml */
/* Generado: 2024-12-31 05:16:49 */

/* Validacion del contenido de los campos campos de la tabla CAR_Vehiculo */
abstract class BaseCAR_VehiculoBV extends CAR_VehiculoBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo Placa */
    public function setPlaca( $s_Placa, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Placa, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo Placa ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPlaca( $s_Placa );
        return true;
    }

    /* Valida y establece el valor del campo Pais */
    public function setPais( $s_Pais, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Pais, "VARCHAR", 18, 0, false ) )
            {
                throw new Exception( "El campo Pais ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPais( $s_Pais );
        return true;
    }

    /* Valida y establece el valor del campo IdVehiculoTipo */
    public function setIdVehiculoTipo( $i_IdVehiculoTipo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdVehiculoTipo, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdVehiculoTipo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdVehiculoTipo( $i_IdVehiculoTipo );
        return true;
    }

    /* Valida y establece el valor del campo IdVehiculoMarca */
    public function setIdVehiculoMarca( $i_IdVehiculoMarca, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdVehiculoMarca, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdVehiculoMarca ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdVehiculoMarca( $i_IdVehiculoMarca );
        return true;
    }

    /* Valida y establece el valor del campo IdVehiculoModelo */
    public function setIdVehiculoModelo( $i_IdVehiculoModelo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdVehiculoModelo, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdVehiculoModelo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdVehiculoModelo( $i_IdVehiculoModelo );
        return true;
    }

    /* Valida y establece el valor del campo NombreTipoVehiculo */
    public function setNombreTipoVehiculo( $s_NombreTipoVehiculo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NombreTipoVehiculo, "VARCHAR", 40, 0, false ) )
            {
                throw new Exception( "El campo NombreTipoVehiculo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNombreTipoVehiculo( $s_NombreTipoVehiculo );
        return true;
    }

    /* Valida y establece el valor del campo NombreMarca */
    public function setNombreMarca( $s_NombreMarca, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NombreMarca, "VARCHAR", 80, 0, false ) )
            {
                throw new Exception( "El campo NombreMarca ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNombreMarca( $s_NombreMarca );
        return true;
    }

    /* Valida y establece el valor del campo NombreModelo */
    public function setNombreModelo( $s_NombreModelo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NombreModelo, "VARCHAR", 80, 0, false ) )
            {
                throw new Exception( "El campo NombreModelo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNombreModelo( $s_NombreModelo );
        return true;
    }

    /* Valida y establece el valor del campo Color */
    public function setColor( $s_Color, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Color, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo Color ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setColor( $s_Color );
        return true;
    }

    /* Valida y establece el valor del campo NumeroMotor */
    public function setNumeroMotor( $s_NumeroMotor, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NumeroMotor, "VARCHAR", 40, 0, false ) )
            {
                throw new Exception( "El campo NumeroMotor ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNumeroMotor( $s_NumeroMotor );
        return true;
    }

    /* Valida y establece el valor del campo Vin */
    public function setVin( $s_Vin, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Vin, "VARCHAR", 40, 0, false ) )
            {
                throw new Exception( "El campo Vin ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setVin( $s_Vin );
        return true;
    }

    /* Valida y establece el valor del campo JsonCad */
    public function setJsonCad( $s_JsonCad, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_JsonCad, "VARCHAR", 5000, 0, false ) )
            {
                throw new Exception( "El campo JsonCad ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setJsonCad( $s_JsonCad );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setPlaca( $this->getPlaca(), false );
        $this->setPais( $this->getPais(), true );
        $this->setIdVehiculoTipo( $this->getIdVehiculoTipo(), true );
        $this->setIdVehiculoMarca( $this->getIdVehiculoMarca(), true );
        $this->setIdVehiculoModelo( $this->getIdVehiculoModelo(), true );
        $this->setNombreTipoVehiculo( $this->getNombreTipoVehiculo(), true );
        $this->setNombreMarca( $this->getNombreMarca(), true );
        $this->setNombreModelo( $this->getNombreModelo(), true );
        $this->setColor( $this->getColor(), true );
        $this->setNumeroMotor( $this->getNumeroMotor(), true );
        $this->setVin( $this->getVin(), true );
        $this->setJsonCad( $this->getJsonCad(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        return true;
    }
}
?>