<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_TransferenciaCabecera.xml */
/* Generado: 2021-03-29 18:07:02 */

/* Validacion del contenido de los campos campos de la tabla ALM_TransferenciaCabecera */
abstract class BaseALM_TransferenciaCabeceraBV extends ALM_TransferenciaCabeceraBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdTransferencia */
    public function setIdTransferencia( $i_IdTransferencia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdTransferencia, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdTransferencia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTransferencia( $i_IdTransferencia );
        return true;
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo IdSucursal */
    public function setIdSucursal( $i_IdSucursal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSucursal, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSucursal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSucursal( $i_IdSucursal );
        return true;
    }

    /* Valida y establece el valor del campo IdTipoDocumento */
    public function setIdTipoDocumento( $s_IdTipoDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdTipoDocumento, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo IdTipoDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTipoDocumento( $s_IdTipoDocumento );
        return true;
    }

    /* Valida y establece el valor del campo IdNumeroDocumento */
    public function setIdNumeroDocumento( $s_IdNumeroDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdNumeroDocumento, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdNumeroDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdNumeroDocumento( $s_IdNumeroDocumento );
        return true;
    }

    /* Valida y establece el valor del campo IdTransaccion */
    public function setIdTransaccion( $s_IdTransaccion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdTransaccion, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo IdTransaccion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTransaccion( $s_IdTransaccion );
        return true;
    }

    /* Valida y establece el valor del campo IdAlmacen */
    public function setIdAlmacen( $s_IdAlmacen, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdAlmacen, "CHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdAlmacen ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdAlmacen( $s_IdAlmacen );
        return true;
    }

    /* Valida y establece el valor del campo AlmacenTraslado */
    public function setAlmacenTraslado( $s_AlmacenTraslado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_AlmacenTraslado, "CHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo AlmacenTraslado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAlmacenTraslado( $s_AlmacenTraslado );
        return true;
    }

    /* Valida y establece el valor del campo IdTransaccionOperacion */
    public function setIdTransaccionOperacion( $s_IdTransaccionOperacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdTransaccionOperacion, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo IdTransaccionOperacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTransaccionOperacion( $s_IdTransaccionOperacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaDocumento */
    public function setFechaDocumento( $d_FechaDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaDocumento, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaDocumento( $d_FechaDocumento );
        return true;
    }

    /* Valida y establece el valor del campo TipodeCambio */
    public function setTipodeCambio( $f_TipodeCambio, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_TipodeCambio, "DECIMAL", 10, 4, false ) )
            {
                throw new Exception( "El campo TipodeCambio ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipodeCambio( $f_TipodeCambio );
        return true;
    }

    /* Valida y establece el valor del campo Periodo */
    public function setPeriodo( $s_Periodo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Periodo, "VARCHAR", 6, 0, false ) )
            {
                throw new Exception( "El campo Periodo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPeriodo( $s_Periodo );
        return true;
    }

    /* Valida y establece el valor del campo PeriodoAnulacion */
    public function setPeriodoAnulacion( $s_PeriodoAnulacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_PeriodoAnulacion, "VARCHAR", 6, 0, false ) )
            {
                throw new Exception( "El campo PeriodoAnulacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPeriodoAnulacion( $s_PeriodoAnulacion );
        return true;
    }

    /* Valida y establece el valor del campo Voucher */
    public function setVoucher( $s_Voucher, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Voucher, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo Voucher ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setVoucher( $s_Voucher );
        return true;
    }

    /* Valida y establece el valor del campo CentroCostoConsumo */
    public function setCentroCostoConsumo( $s_CentroCostoConsumo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CentroCostoConsumo, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo CentroCostoConsumo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCentroCostoConsumo( $s_CentroCostoConsumo );
        return true;
    }

    /* Valida y establece el valor del campo ImprimirGuia */
    public function setImprimirGuia( $s_ImprimirGuia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ImprimirGuia, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo ImprimirGuia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setImprimirGuia( $s_ImprimirGuia );
        return true;
    }

    /* Valida y establece el valor del campo ReferenciaTipoDocumento */
    public function setReferenciaTipoDocumento( $s_ReferenciaTipoDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReferenciaTipoDocumento, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo ReferenciaTipoDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReferenciaTipoDocumento( $s_ReferenciaTipoDocumento );
        return true;
    }

    /* Valida y establece el valor del campo ReferenciaSerieDocumento */
    public function setReferenciaSerieDocumento( $s_ReferenciaSerieDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReferenciaSerieDocumento, "VARCHAR", 5, 0, false ) )
            {
                throw new Exception( "El campo ReferenciaSerieDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReferenciaSerieDocumento( $s_ReferenciaSerieDocumento );
        return true;
    }

    /* Valida y establece el valor del campo ReferenciaNumeroDocumento */
    public function setReferenciaNumeroDocumento( $s_ReferenciaNumeroDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReferenciaNumeroDocumento, "VARCHAR", 14, 0, false ) )
            {
                throw new Exception( "El campo ReferenciaNumeroDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReferenciaNumeroDocumento( $s_ReferenciaNumeroDocumento );
        return true;
    }

    /* Valida y establece el valor del campo GuiaProveedor */
    public function setGuiaProveedor( $s_GuiaProveedor, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_GuiaProveedor, "VARCHAR", 14, 0, false ) )
            {
                throw new Exception( "El campo GuiaProveedor ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setGuiaProveedor( $s_GuiaProveedor );
        return true;
    }

    /* Valida y establece el valor del campo IdOrdenProd */
    public function setIdOrdenProd( $i_IdOrdenProd, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdOrdenProd, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdOrdenProd ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdOrdenProd( $i_IdOrdenProd );
        return true;
    }

    /* Valida y establece el valor del campo IdProyecto */
    public function setIdProyecto( $i_IdProyecto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdProyecto, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdProyecto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdProyecto( $i_IdProyecto );
        return true;
    }

    /* Valida y establece el valor del campo ReferenciaNumeroInterno */
    public function setReferenciaNumeroInterno( $i_ReferenciaNumeroInterno, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_ReferenciaNumeroInterno, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo ReferenciaNumeroInterno ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReferenciaNumeroInterno( $i_ReferenciaNumeroInterno );
        return true;
    }

    /* Valida y establece el valor del campo ReferenciaInterno */
    public function setReferenciaInterno( $s_ReferenciaInterno, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReferenciaInterno, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo ReferenciaInterno ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReferenciaInterno( $s_ReferenciaInterno );
        return true;
    }

    /* Valida y establece el valor del campo IdChofer */
    public function setIdChofer( $i_IdChofer, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdChofer, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdChofer ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdChofer( $i_IdChofer );
        return true;
    }

    /* Valida y establece el valor del campo IdVehiculo */
    public function setIdVehiculo( $i_IdVehiculo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdVehiculo, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdVehiculo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdVehiculo( $i_IdVehiculo );
        return true;
    }

    /* Valida y establece el valor del campo Transportista */
    public function setTransportista( $i_Transportista, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_Transportista, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo Transportista ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTransportista( $i_Transportista );
        return true;
    }

    /* Valida y establece el valor del campo VehiculoMarca */
    public function setVehiculoMarca( $s_VehiculoMarca, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_VehiculoMarca, "VARCHAR", 100, 0, false ) )
            {
                throw new Exception( "El campo VehiculoMarca ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setVehiculoMarca( $s_VehiculoMarca );
        return true;
    }

    /* Valida y establece el valor del campo VehiculoPlaca */
    public function setVehiculoPlaca( $s_VehiculoPlaca, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_VehiculoPlaca, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo VehiculoPlaca ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setVehiculoPlaca( $s_VehiculoPlaca );
        return true;
    }

    /* Valida y establece el valor del campo LicenciaConducir */
    public function setLicenciaConducir( $s_LicenciaConducir, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_LicenciaConducir, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo LicenciaConducir ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setLicenciaConducir( $s_LicenciaConducir );
        return true;
    }

    /* Valida y establece el valor del campo ResponsableTraslado */
    public function setResponsableTraslado( $s_ResponsableTraslado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ResponsableTraslado, "VARCHAR", 200, 0, false ) )
            {
                throw new Exception( "El campo ResponsableTraslado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setResponsableTraslado( $s_ResponsableTraslado );
        return true;
    }

    /* Valida y establece el valor del campo MotivoDevolucion */
    public function setMotivoDevolucion( $s_MotivoDevolucion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_MotivoDevolucion, "VARCHAR", 4, 0, false ) )
            {
                throw new Exception( "El campo MotivoDevolucion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMotivoDevolucion( $s_MotivoDevolucion );
        return true;
    }

    /* Valida y establece el valor del campo UnidadNegocio */
    public function setUnidadNegocio( $s_UnidadNegocio, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UnidadNegocio, "VARCHAR", 4, 0, false ) )
            {
                throw new Exception( "El campo UnidadNegocio ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUnidadNegocio( $s_UnidadNegocio );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo CompaniaDescripcion */
    public function setCompaniaDescripcion( $s_CompaniaDescripcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CompaniaDescripcion, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo CompaniaDescripcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCompaniaDescripcion( $s_CompaniaDescripcion );
        return true;
    }

    /* Valida y establece el valor del campo Comentario */
    public function setComentario( $u_Comentario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $u_Comentario, "TEXT", 0, 0, false ) )
            {
                throw new Exception( "El campo Comentario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setComentario( $u_Comentario );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdTransferencia( $this->getIdTransferencia(), false );
        $this->setIdCompania( $this->getIdCompania(), true );
        $this->setIdSucursal( $this->getIdSucursal(), true );
        $this->setIdTipoDocumento( $this->getIdTipoDocumento(), true );
        $this->setIdNumeroDocumento( $this->getIdNumeroDocumento(), true );
        $this->setIdTransaccion( $this->getIdTransaccion(), true );
        $this->setIdAlmacen( $this->getIdAlmacen(), true );
        $this->setAlmacenTraslado( $this->getAlmacenTraslado(), true );
        $this->setIdTransaccionOperacion( $this->getIdTransaccionOperacion(), true );
        $this->setFechaDocumento( $this->getFechaDocumento(), true );
        $this->setTipodeCambio( $this->getTipodeCambio(), true );
        $this->setPeriodo( $this->getPeriodo(), true );
        $this->setPeriodoAnulacion( $this->getPeriodoAnulacion(), true );
        $this->setVoucher( $this->getVoucher(), true );
        $this->setCentroCostoConsumo( $this->getCentroCostoConsumo(), true );
        $this->setImprimirGuia( $this->getImprimirGuia(), true );
        $this->setReferenciaTipoDocumento( $this->getReferenciaTipoDocumento(), true );
        $this->setReferenciaSerieDocumento( $this->getReferenciaSerieDocumento(), true );
        $this->setReferenciaNumeroDocumento( $this->getReferenciaNumeroDocumento(), true );
        $this->setGuiaProveedor( $this->getGuiaProveedor(), true );
        $this->setIdOrdenProd( $this->getIdOrdenProd(), true );
        $this->setIdProyecto( $this->getIdProyecto(), true );
        $this->setReferenciaNumeroInterno( $this->getReferenciaNumeroInterno(), true );
        $this->setReferenciaInterno( $this->getReferenciaInterno(), true );
        $this->setIdChofer( $this->getIdChofer(), true );
        $this->setIdVehiculo( $this->getIdVehiculo(), true );
        $this->setTransportista( $this->getTransportista(), true );
        $this->setVehiculoMarca( $this->getVehiculoMarca(), true );
        $this->setVehiculoPlaca( $this->getVehiculoPlaca(), true );
        $this->setLicenciaConducir( $this->getLicenciaConducir(), true );
        $this->setResponsableTraslado( $this->getResponsableTraslado(), true );
        $this->setMotivoDevolucion( $this->getMotivoDevolucion(), true );
        $this->setUnidadNegocio( $this->getUnidadNegocio(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setCompaniaDescripcion( $this->getCompaniaDescripcion(), true );
        $this->setComentario( $this->getComentario(), true );
        return true;
    }
}
?>