<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_TransaccionMast.xml */
/* Generado: 2021-01-04 10:12:58 */

/* Validacion del contenido de los campos campos de la tabla ALM_TransaccionMast */
abstract class BaseALM_TransaccionMastBV extends ALM_TransaccionMastBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdTransaccion */
    public function setIdTransaccion( $s_IdTransaccion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdTransaccion, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo IdTransaccion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTransaccion( $s_IdTransaccion );
        return true;
    }

    /* Valida y establece el valor del campo CodigoSunat */
    public function setCodigoSunat( $s_CodigoSunat, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CodigoSunat, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo CodigoSunat ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCodigoSunat( $s_CodigoSunat );
        return true;
    }

    /* Valida y establece el valor del campo DescripcionLocal */
    public function setDescripcionLocal( $s_DescripcionLocal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DescripcionLocal, "VARCHAR", 100, 0, false ) )
            {
                throw new Exception( "El campo DescripcionLocal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcionLocal( $s_DescripcionLocal );
        return true;
    }

    /* Valida y establece el valor del campo DescripcionIngles */
    public function setDescripcionIngles( $s_DescripcionIngles, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DescripcionIngles, "VARCHAR", 100, 0, false ) )
            {
                throw new Exception( "El campo DescripcionIngles ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcionIngles( $s_DescripcionIngles );
        return true;
    }

    /* Valida y establece el valor del campo IngresoEgresoFlag */
    public function setIngresoEgresoFlag( $s_IngresoEgresoFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IngresoEgresoFlag, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo IngresoEgresoFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIngresoEgresoFlag( $s_IngresoEgresoFlag );
        return true;
    }

    /* Valida y establece el valor del campo TipoDocumentoGenerado */
    public function setTipoDocumentoGenerado( $s_TipoDocumentoGenerado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoDocumentoGenerado, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo TipoDocumentoGenerado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoDocumentoGenerado( $s_TipoDocumentoGenerado );
        return true;
    }

    /* Valida y establece el valor del campo TipoDocumentoValidado */
    public function setTipoDocumentoValidado( $s_TipoDocumentoValidado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoDocumentoValidado, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo TipoDocumentoValidado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoDocumentoValidado( $s_TipoDocumentoValidado );
        return true;
    }

    /* Valida y establece el valor del campo TransacciondelSistemaFlag */
    public function setTransacciondelSistemaFlag( $s_TransacciondelSistemaFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TransacciondelSistemaFlag, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo TransacciondelSistemaFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTransacciondelSistemaFlag( $s_TransacciondelSistemaFlag );
        return true;
    }

    /* Valida y establece el valor del campo NumeracionAutomaticaFlag */
    public function setNumeracionAutomaticaFlag( $s_NumeracionAutomaticaFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NumeracionAutomaticaFlag, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo NumeracionAutomaticaFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNumeracionAutomaticaFlag( $s_NumeracionAutomaticaFlag );
        return true;
    }

    /* Valida y establece el valor del campo CampoReferenciaFlag */
    public function setCampoReferenciaFlag( $s_CampoReferenciaFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CampoReferenciaFlag, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo CampoReferenciaFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCampoReferenciaFlag( $s_CampoReferenciaFlag );
        return true;
    }

    /* Valida y establece el valor del campo GenerarVoucherFlag */
    public function setGenerarVoucherFlag( $s_GenerarVoucherFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_GenerarVoucherFlag, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo GenerarVoucherFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setGenerarVoucherFlag( $s_GenerarVoucherFlag );
        return true;
    }

    /* Valida y establece el valor del campo AjusteInventarioFlag */
    public function setAjusteInventarioFlag( $s_AjusteInventarioFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_AjusteInventarioFlag, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo AjusteInventarioFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAjusteInventarioFlag( $s_AjusteInventarioFlag );
        return true;
    }

    /* Valida y establece el valor del campo AjusteInventarioCuenta */
    public function setAjusteInventarioCuenta( $s_AjusteInventarioCuenta, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_AjusteInventarioCuenta, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo AjusteInventarioCuenta ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAjusteInventarioCuenta( $s_AjusteInventarioCuenta );
        return true;
    }

    /* Valida y establece el valor del campo TransaccionVentaFlag */
    public function setTransaccionVentaFlag( $s_TransaccionVentaFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TransaccionVentaFlag, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo TransaccionVentaFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTransaccionVentaFlag( $s_TransaccionVentaFlag );
        return true;
    }

    /* Valida y establece el valor del campo DireccionDestinoFlag */
    public function setDireccionDestinoFlag( $s_DireccionDestinoFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DireccionDestinoFlag, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo DireccionDestinoFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDireccionDestinoFlag( $s_DireccionDestinoFlag );
        return true;
    }

    /* Valida y establece el valor del campo ValorizacionManualFlag */
    public function setValorizacionManualFlag( $s_ValorizacionManualFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ValorizacionManualFlag, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo ValorizacionManualFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setValorizacionManualFlag( $s_ValorizacionManualFlag );
        return true;
    }

    /* Valida y establece el valor del campo Clasificacion */
    public function setClasificacion( $s_Clasificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Clasificacion, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo Clasificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setClasificacion( $s_Clasificacion );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdTransaccion( $this->getIdTransaccion(), false );
        $this->setCodigoSunat( $this->getCodigoSunat(), true );
        $this->setDescripcionLocal( $this->getDescripcionLocal(), true );
        $this->setDescripcionIngles( $this->getDescripcionIngles(), true );
        $this->setIngresoEgresoFlag( $this->getIngresoEgresoFlag(), true );
        $this->setTipoDocumentoGenerado( $this->getTipoDocumentoGenerado(), true );
        $this->setTipoDocumentoValidado( $this->getTipoDocumentoValidado(), true );
        $this->setTransacciondelSistemaFlag( $this->getTransacciondelSistemaFlag(), true );
        $this->setNumeracionAutomaticaFlag( $this->getNumeracionAutomaticaFlag(), true );
        $this->setCampoReferenciaFlag( $this->getCampoReferenciaFlag(), true );
        $this->setGenerarVoucherFlag( $this->getGenerarVoucherFlag(), true );
        $this->setAjusteInventarioFlag( $this->getAjusteInventarioFlag(), true );
        $this->setAjusteInventarioCuenta( $this->getAjusteInventarioCuenta(), true );
        $this->setTransaccionVentaFlag( $this->getTransaccionVentaFlag(), true );
        $this->setDireccionDestinoFlag( $this->getDireccionDestinoFlag(), true );
        $this->setValorizacionManualFlag( $this->getValorizacionManualFlag(), true );
        $this->setClasificacion( $this->getClasificacion(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        return true;
    }
}
?>