<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_TransaccionDetalle.xml */
/* Generado: 2021-11-07 00:42:13 */

/* Validacion del contenido de los campos campos de la tabla ALM_TransaccionDetalle */
abstract class BaseALM_TransaccionDetalleBV extends ALM_TransaccionDetalleBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo IdTipoDocumento */
    public function setIdTipoDocumento( $s_IdTipoDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdTipoDocumento, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo IdTipoDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTipoDocumento( $s_IdTipoDocumento );
        return true;
    }

    /* Valida y establece el valor del campo IdNumeroDocumento */
    public function setIdNumeroDocumento( $s_IdNumeroDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdNumeroDocumento, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdNumeroDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdNumeroDocumento( $s_IdNumeroDocumento );
        return true;
    }

    /* Valida y establece el valor del campo IdSucursal */
    public function setIdSucursal( $i_IdSucursal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSucursal, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSucursal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSucursal( $i_IdSucursal );
        return true;
    }

    /* Valida y establece el valor del campo IdCondicion */
    public function setIdCondicion( $s_IdCondicion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdCondicion, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo IdCondicion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCondicion( $s_IdCondicion );
        return true;
    }

    /* Valida y establece el valor del campo IdSecuencia */
    public function setIdSecuencia( $i_IdSecuencia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSecuencia, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSecuencia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSecuencia( $i_IdSecuencia );
        return true;
    }

    /* Valida y establece el valor del campo IdItem */
    public function setIdItem( $s_IdItem, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdItem, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo IdItem ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdItem( $s_IdItem );
        return true;
    }

    /* Valida y establece el valor del campo Lote */
    public function setLote( $s_Lote, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Lote, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo Lote ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setLote( $s_Lote );
        return true;
    }

    /* Valida y establece el valor del campo IdTransaccionCab */
    public function setIdTransaccionCab( $s_IdTransaccionCab, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdTransaccionCab, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo IdTransaccionCab ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTransaccionCab( $s_IdTransaccionCab );
        return true;
    }

    /* Valida y establece el valor del campo FechaDocumentoCab */
    public function setFechaDocumentoCab( $d_FechaDocumentoCab, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaDocumentoCab, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaDocumentoCab ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaDocumentoCab( $d_FechaDocumentoCab );
        return true;
    }

    /* Valida y establece el valor del campo IdAlmacen */
    public function setIdAlmacen( $s_IdAlmacen, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdAlmacen, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdAlmacen ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdAlmacen( $s_IdAlmacen );
        return true;
    }

    /* Valida y establece el valor del campo IdAlmacenDestino */
    public function setIdAlmacenDestino( $s_IdAlmacenDestino, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdAlmacenDestino, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdAlmacenDestino ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdAlmacenDestino( $s_IdAlmacenDestino );
        return true;
    }

    /* Valida y establece el valor del campo FechaVencimiento */
    public function setFechaVencimiento( $d_FechaVencimiento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaVencimiento, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaVencimiento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaVencimiento( $d_FechaVencimiento );
        return true;
    }

    /* Valida y establece el valor del campo UnidadCodigo */
    public function setUnidadCodigo( $s_UnidadCodigo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UnidadCodigo, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UnidadCodigo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUnidadCodigo( $s_UnidadCodigo );
        return true;
    }

    /* Valida y establece el valor del campo Cantidad */
    public function setCantidad( $f_Cantidad, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_Cantidad, "DECIMAL", 10, 4, false ) )
            {
                throw new Exception( "El campo Cantidad ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCantidad( $f_Cantidad );
        return true;
    }

    /* Valida y establece el valor del campo CantidadDoble */
    public function setCantidadDoble( $f_CantidadDoble, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_CantidadDoble, "DECIMAL", 10, 4, false ) )
            {
                throw new Exception( "El campo CantidadDoble ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCantidadDoble( $f_CantidadDoble );
        return true;
    }

    /* Valida y establece el valor del campo CantidadFIFO */
    public function setCantidadFIFO( $f_CantidadFIFO, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_CantidadFIFO, "DECIMAL", 10, 4, false ) )
            {
                throw new Exception( "El campo CantidadFIFO ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCantidadFIFO( $f_CantidadFIFO );
        return true;
    }

    /* Valida y establece el valor del campo IdMoneda */
    public function setIdMoneda( $s_IdMoneda, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdMoneda, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo IdMoneda ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdMoneda( $s_IdMoneda );
        return true;
    }

    /* Valida y establece el valor del campo PrecioUnitario */
    public function setPrecioUnitario( $f_PrecioUnitario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioUnitario, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioUnitario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioUnitario( $f_PrecioUnitario );
        return true;
    }

    /* Valida y establece el valor del campo MontoTotal */
    public function setMontoTotal( $f_MontoTotal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoTotal, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoTotal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoTotal( $f_MontoTotal );
        return true;
    }

    /* Valida y establece el valor del campo PrecioUnitarioDolares */
    public function setPrecioUnitarioDolares( $f_PrecioUnitarioDolares, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioUnitarioDolares, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioUnitarioDolares ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioUnitarioDolares( $f_PrecioUnitarioDolares );
        return true;
    }

    /* Valida y establece el valor del campo MontoTotalDolares */
    public function setMontoTotalDolares( $f_MontoTotalDolares, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoTotalDolares, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoTotalDolares ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoTotalDolares( $f_MontoTotalDolares );
        return true;
    }

    /* Valida y establece el valor del campo ReferenciaCompaniaSocio */
    public function setReferenciaCompaniaSocio( $s_ReferenciaCompaniaSocio, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReferenciaCompaniaSocio, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo ReferenciaCompaniaSocio ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReferenciaCompaniaSocio( $s_ReferenciaCompaniaSocio );
        return true;
    }

    /* Valida y establece el valor del campo ReferenciaTipoDocumento */
    public function setReferenciaTipoDocumento( $s_ReferenciaTipoDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReferenciaTipoDocumento, "CHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo ReferenciaTipoDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReferenciaTipoDocumento( $s_ReferenciaTipoDocumento );
        return true;
    }

    /* Valida y establece el valor del campo ReferenciaNumeroDocumento */
    public function setReferenciaNumeroDocumento( $s_ReferenciaNumeroDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReferenciaNumeroDocumento, "VARCHAR", 14, 0, false ) )
            {
                throw new Exception( "El campo ReferenciaNumeroDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReferenciaNumeroDocumento( $s_ReferenciaNumeroDocumento );
        return true;
    }

    /* Valida y establece el valor del campo ReferenciaSecuencia */
    public function setReferenciaSecuencia( $i_ReferenciaSecuencia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_ReferenciaSecuencia, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo ReferenciaSecuencia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReferenciaSecuencia( $i_ReferenciaSecuencia );
        return true;
    }

    /* Valida y establece el valor del campo AprobacionTecnicaFlag */
    public function setAprobacionTecnicaFlag( $s_AprobacionTecnicaFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_AprobacionTecnicaFlag, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo AprobacionTecnicaFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAprobacionTecnicaFlag( $s_AprobacionTecnicaFlag );
        return true;
    }

    /* Valida y establece el valor del campo AprobacionTecnicaDocumento */
    public function setAprobacionTecnicaDocumento( $s_AprobacionTecnicaDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_AprobacionTecnicaDocumento, "CHAR", 15, 0, false ) )
            {
                throw new Exception( "El campo AprobacionTecnicaDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAprobacionTecnicaDocumento( $s_AprobacionTecnicaDocumento );
        return true;
    }

    /* Valida y establece el valor del campo FallaFlag */
    public function setFallaFlag( $s_FallaFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_FallaFlag, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo FallaFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFallaFlag( $s_FallaFlag );
        return true;
    }

    /* Valida y establece el valor del campo Observaciones */
    public function setObservaciones( $s_Observaciones, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Observaciones, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo Observaciones ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setObservaciones( $s_Observaciones );
        return true;
    }

    /* Valida y establece el valor del campo FacturadoFlag */
    public function setFacturadoFlag( $s_FacturadoFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_FacturadoFlag, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo FacturadoFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFacturadoFlag( $s_FacturadoFlag );
        return true;
    }

    /* Valida y establece el valor del campo ValorizacionExternaFlag */
    public function setValorizacionExternaFlag( $s_ValorizacionExternaFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ValorizacionExternaFlag, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo ValorizacionExternaFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setValorizacionExternaFlag( $s_ValorizacionExternaFlag );
        return true;
    }

    /* Valida y establece el valor del campo LoteProduccion */
    public function setLoteProduccion( $s_LoteProduccion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_LoteProduccion, "CHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo LoteProduccion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setLoteProduccion( $s_LoteProduccion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo DescripcionItem */
    public function setDescripcionItem( $s_DescripcionItem, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DescripcionItem, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo DescripcionItem ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcionItem( $s_DescripcionItem );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdCompania( $this->getIdCompania(), false );
        $this->setIdTipoDocumento( $this->getIdTipoDocumento(), false );
        $this->setIdNumeroDocumento( $this->getIdNumeroDocumento(), false );
        $this->setIdSucursal( $this->getIdSucursal(), true );
        $this->setIdCondicion( $this->getIdCondicion(), true );
        $this->setIdSecuencia( $this->getIdSecuencia(), false );
        $this->setIdItem( $this->getIdItem(), true );
        $this->setLote( $this->getLote(), true );
        $this->setIdTransaccionCab( $this->getIdTransaccionCab(), true );
        $this->setFechaDocumentoCab( $this->getFechaDocumentoCab(), true );
        $this->setIdAlmacen( $this->getIdAlmacen(), true );
        $this->setIdAlmacenDestino( $this->getIdAlmacenDestino(), true );
        $this->setFechaVencimiento( $this->getFechaVencimiento(), true );
        $this->setUnidadCodigo( $this->getUnidadCodigo(), true );
        $this->setCantidad( $this->getCantidad(), true );
        $this->setCantidadDoble( $this->getCantidadDoble(), true );
        $this->setCantidadFIFO( $this->getCantidadFIFO(), true );
        $this->setIdMoneda( $this->getIdMoneda(), true );
        $this->setPrecioUnitario( $this->getPrecioUnitario(), true );
        $this->setMontoTotal( $this->getMontoTotal(), true );
        $this->setPrecioUnitarioDolares( $this->getPrecioUnitarioDolares(), true );
        $this->setMontoTotalDolares( $this->getMontoTotalDolares(), true );
        $this->setReferenciaCompaniaSocio( $this->getReferenciaCompaniaSocio(), true );
        $this->setReferenciaTipoDocumento( $this->getReferenciaTipoDocumento(), true );
        $this->setReferenciaNumeroDocumento( $this->getReferenciaNumeroDocumento(), true );
        $this->setReferenciaSecuencia( $this->getReferenciaSecuencia(), true );
        $this->setAprobacionTecnicaFlag( $this->getAprobacionTecnicaFlag(), true );
        $this->setAprobacionTecnicaDocumento( $this->getAprobacionTecnicaDocumento(), true );
        $this->setFallaFlag( $this->getFallaFlag(), true );
        $this->setObservaciones( $this->getObservaciones(), true );
        $this->setFacturadoFlag( $this->getFacturadoFlag(), true );
        $this->setValorizacionExternaFlag( $this->getValorizacionExternaFlag(), true );
        $this->setLoteProduccion( $this->getLoteProduccion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setDescripcionItem( $this->getDescripcionItem(), true );
        return true;
    }
}
?>