<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_TransaccionCabecera.xml */
/* Generado: 2022-11-15 07:29:12 */

/* Validacion del contenido de los campos campos de la tabla ALM_TransaccionCabecera */
abstract class BaseALM_TransaccionCabeceraBV extends ALM_TransaccionCabeceraBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo IdSucursal */
    public function setIdSucursal( $i_IdSucursal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSucursal, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSucursal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSucursal( $i_IdSucursal );
        return true;
    }

    /* Valida y establece el valor del campo IdTipoDocumento */
    public function setIdTipoDocumento( $s_IdTipoDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdTipoDocumento, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo IdTipoDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTipoDocumento( $s_IdTipoDocumento );
        return true;
    }

    /* Valida y establece el valor del campo IdNumeroDocumento */
    public function setIdNumeroDocumento( $s_IdNumeroDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdNumeroDocumento, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdNumeroDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdNumeroDocumento( $s_IdNumeroDocumento );
        return true;
    }

    /* Valida y establece el valor del campo IdTransaccion */
    public function setIdTransaccion( $s_IdTransaccion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdTransaccion, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo IdTransaccion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTransaccion( $s_IdTransaccion );
        return true;
    }

    /* Valida y establece el valor del campo AlmacenTraslado */
    public function setAlmacenTraslado( $s_AlmacenTraslado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_AlmacenTraslado, "CHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo AlmacenTraslado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAlmacenTraslado( $s_AlmacenTraslado );
        return true;
    }

    /* Valida y establece el valor del campo IdAlmacen */
    public function setIdAlmacen( $s_IdAlmacen, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdAlmacen, "CHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdAlmacen ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdAlmacen( $s_IdAlmacen );
        return true;
    }

    /* Valida y establece el valor del campo IdTransaccionOperacion */
    public function setIdTransaccionOperacion( $s_IdTransaccionOperacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdTransaccionOperacion, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo IdTransaccionOperacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTransaccionOperacion( $s_IdTransaccionOperacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaDocumento */
    public function setFechaDocumento( $d_FechaDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaDocumento, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaDocumento( $d_FechaDocumento );
        return true;
    }

    /* Valida y establece el valor del campo TipodeCambio */
    public function setTipodeCambio( $f_TipodeCambio, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_TipodeCambio, "DECIMAL", 10, 4, false ) )
            {
                throw new Exception( "El campo TipodeCambio ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipodeCambio( $f_TipodeCambio );
        return true;
    }

    /* Valida y establece el valor del campo MonedaCod */
    public function setMonedaCod( $s_MonedaCod, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_MonedaCod, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo MonedaCod ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMonedaCod( $s_MonedaCod );
        return true;
    }

    /* Valida y establece el valor del campo Periodo */
    public function setPeriodo( $s_Periodo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Periodo, "VARCHAR", 6, 0, false ) )
            {
                throw new Exception( "El campo Periodo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPeriodo( $s_Periodo );
        return true;
    }

    /* Valida y establece el valor del campo PeriodoAnulacion */
    public function setPeriodoAnulacion( $s_PeriodoAnulacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_PeriodoAnulacion, "VARCHAR", 6, 0, false ) )
            {
                throw new Exception( "El campo PeriodoAnulacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPeriodoAnulacion( $s_PeriodoAnulacion );
        return true;
    }

    /* Valida y establece el valor del campo Voucher */
    public function setVoucher( $s_Voucher, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Voucher, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo Voucher ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setVoucher( $s_Voucher );
        return true;
    }

    /* Valida y establece el valor del campo CentroCostoConsumo */
    public function setCentroCostoConsumo( $s_CentroCostoConsumo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CentroCostoConsumo, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo CentroCostoConsumo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCentroCostoConsumo( $s_CentroCostoConsumo );
        return true;
    }

    /* Valida y establece el valor del campo ReferenciaTipoDocumento */
    public function setReferenciaTipoDocumento( $s_ReferenciaTipoDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReferenciaTipoDocumento, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo ReferenciaTipoDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReferenciaTipoDocumento( $s_ReferenciaTipoDocumento );
        return true;
    }

    /* Valida y establece el valor del campo ReferenciaNumeroDocumento */
    public function setReferenciaNumeroDocumento( $s_ReferenciaNumeroDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReferenciaNumeroDocumento, "VARCHAR", 14, 0, false ) )
            {
                throw new Exception( "El campo ReferenciaNumeroDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReferenciaNumeroDocumento( $s_ReferenciaNumeroDocumento );
        return true;
    }

    /* Valida y establece el valor del campo GuiaProveedor */
    public function setGuiaProveedor( $s_GuiaProveedor, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_GuiaProveedor, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo GuiaProveedor ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setGuiaProveedor( $s_GuiaProveedor );
        return true;
    }

    /* Valida y establece el valor del campo ReferenciaNumeroInterno */
    public function setReferenciaNumeroInterno( $s_ReferenciaNumeroInterno, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReferenciaNumeroInterno, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo ReferenciaNumeroInterno ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReferenciaNumeroInterno( $s_ReferenciaNumeroInterno );
        return true;
    }

    /* Valida y establece el valor del campo ReferenciaInterno */
    public function setReferenciaInterno( $s_ReferenciaInterno, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReferenciaInterno, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo ReferenciaInterno ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReferenciaInterno( $s_ReferenciaInterno );
        return true;
    }

    /* Valida y establece el valor del campo Descripcion */
    public function setDescripcion( $s_Descripcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Descripcion, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo Descripcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcion( $s_Descripcion );
        return true;
    }

    /* Valida y establece el valor del campo IdProyecto */
    public function setIdProyecto( $i_IdProyecto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdProyecto, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdProyecto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdProyecto( $i_IdProyecto );
        return true;
    }

    /* Valida y establece el valor del campo CodigoCliente */
    public function setCodigoCliente( $s_CodigoCliente, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CodigoCliente, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo CodigoCliente ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCodigoCliente( $s_CodigoCliente );
        return true;
    }

    /* Valida y establece el valor del campo CodigoProveedor */
    public function setCodigoProveedor( $s_CodigoProveedor, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CodigoProveedor, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo CodigoProveedor ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCodigoProveedor( $s_CodigoProveedor );
        return true;
    }

    /* Valida y establece el valor del campo TipoDocumentoFiscal */
    public function setTipoDocumentoFiscal( $s_TipoDocumentoFiscal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoDocumentoFiscal, "VARCHAR", 5, 0, false ) )
            {
                throw new Exception( "El campo TipoDocumentoFiscal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoDocumentoFiscal( $s_TipoDocumentoFiscal );
        return true;
    }

    /* Valida y establece el valor del campo CodDocumentoFiscal */
    public function setCodDocumentoFiscal( $s_CodDocumentoFiscal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CodDocumentoFiscal, "VARCHAR", 5, 0, false ) )
            {
                throw new Exception( "El campo CodDocumentoFiscal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCodDocumentoFiscal( $s_CodDocumentoFiscal );
        return true;
    }

    /* Valida y establece el valor del campo SerieDocumentoFiscal */
    public function setSerieDocumentoFiscal( $s_SerieDocumentoFiscal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_SerieDocumentoFiscal, "VARCHAR", 5, 0, false ) )
            {
                throw new Exception( "El campo SerieDocumentoFiscal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSerieDocumentoFiscal( $s_SerieDocumentoFiscal );
        return true;
    }

    /* Valida y establece el valor del campo NumeroDocumentoFiscal */
    public function setNumeroDocumentoFiscal( $s_NumeroDocumentoFiscal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NumeroDocumentoFiscal, "VARCHAR", 15, 0, false ) )
            {
                throw new Exception( "El campo NumeroDocumentoFiscal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNumeroDocumentoFiscal( $s_NumeroDocumentoFiscal );
        return true;
    }

    /* Valida y establece el valor del campo FechaDocumentoFiscal */
    public function setFechaDocumentoFiscal( $d_FechaDocumentoFiscal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaDocumentoFiscal, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaDocumentoFiscal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaDocumentoFiscal( $d_FechaDocumentoFiscal );
        return true;
    }

    /* Valida y establece el valor del campo Transportista */
    public function setTransportista( $i_Transportista, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_Transportista, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo Transportista ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTransportista( $i_Transportista );
        return true;
    }

    /* Valida y establece el valor del campo ControlEstadoSerie */
    public function setControlEstadoSerie( $s_ControlEstadoSerie, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ControlEstadoSerie, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo ControlEstadoSerie ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setControlEstadoSerie( $s_ControlEstadoSerie );
        return true;
    }

    /* Valida y establece el valor del campo MotivoDevolucion */
    public function setMotivoDevolucion( $s_MotivoDevolucion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_MotivoDevolucion, "VARCHAR", 4, 0, false ) )
            {
                throw new Exception( "El campo MotivoDevolucion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMotivoDevolucion( $s_MotivoDevolucion );
        return true;
    }

    /* Valida y establece el valor del campo UnidadNegocio */
    public function setUnidadNegocio( $s_UnidadNegocio, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UnidadNegocio, "VARCHAR", 4, 0, false ) )
            {
                throw new Exception( "El campo UnidadNegocio ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUnidadNegocio( $s_UnidadNegocio );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo CompaniaDescripcion */
    public function setCompaniaDescripcion( $s_CompaniaDescripcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CompaniaDescripcion, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo CompaniaDescripcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCompaniaDescripcion( $s_CompaniaDescripcion );
        return true;
    }

    /* Valida y establece el valor del campo Comentario */
    public function setComentario( $u_Comentario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $u_Comentario, "TEXT", 0, 0, false ) )
            {
                throw new Exception( "El campo Comentario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setComentario( $u_Comentario );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdCompania( $this->getIdCompania(), false );
        $this->setIdSucursal( $this->getIdSucursal(), true );
        $this->setIdTipoDocumento( $this->getIdTipoDocumento(), false );
        $this->setIdNumeroDocumento( $this->getIdNumeroDocumento(), false );
        $this->setIdTransaccion( $this->getIdTransaccion(), true );
        $this->setAlmacenTraslado( $this->getAlmacenTraslado(), true );
        $this->setIdAlmacen( $this->getIdAlmacen(), true );
        $this->setIdTransaccionOperacion( $this->getIdTransaccionOperacion(), true );
        $this->setFechaDocumento( $this->getFechaDocumento(), true );
        $this->setTipodeCambio( $this->getTipodeCambio(), true );
        $this->setMonedaCod( $this->getMonedaCod(), true );
        $this->setPeriodo( $this->getPeriodo(), true );
        $this->setPeriodoAnulacion( $this->getPeriodoAnulacion(), true );
        $this->setVoucher( $this->getVoucher(), true );
        $this->setCentroCostoConsumo( $this->getCentroCostoConsumo(), true );
        $this->setReferenciaTipoDocumento( $this->getReferenciaTipoDocumento(), true );
        $this->setReferenciaNumeroDocumento( $this->getReferenciaNumeroDocumento(), true );
        $this->setGuiaProveedor( $this->getGuiaProveedor(), true );
        $this->setReferenciaNumeroInterno( $this->getReferenciaNumeroInterno(), true );
        $this->setReferenciaInterno( $this->getReferenciaInterno(), true );
        $this->setDescripcion( $this->getDescripcion(), true );
        $this->setIdProyecto( $this->getIdProyecto(), true );
        $this->setCodigoCliente( $this->getCodigoCliente(), true );
        $this->setCodigoProveedor( $this->getCodigoProveedor(), true );
        $this->setTipoDocumentoFiscal( $this->getTipoDocumentoFiscal(), true );
        $this->setCodDocumentoFiscal( $this->getCodDocumentoFiscal(), true );
        $this->setSerieDocumentoFiscal( $this->getSerieDocumentoFiscal(), true );
        $this->setNumeroDocumentoFiscal( $this->getNumeroDocumentoFiscal(), true );
        $this->setFechaDocumentoFiscal( $this->getFechaDocumentoFiscal(), true );
        $this->setTransportista( $this->getTransportista(), true );
        $this->setControlEstadoSerie( $this->getControlEstadoSerie(), true );
        $this->setMotivoDevolucion( $this->getMotivoDevolucion(), true );
        $this->setUnidadNegocio( $this->getUnidadNegocio(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setCompaniaDescripcion( $this->getCompaniaDescripcion(), true );
        $this->setComentario( $this->getComentario(), true );
        return true;
    }
}
?>