<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_ReservaItemStock.xml */
/* Generado: 2020-08-18 04:21:24 */

/* Validacion del contenido de los campos campos de la tabla ALM_ReservaItemStock */
abstract class BaseALM_ReservaItemStockBV extends ALM_ReservaItemStockBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo ReservaId */
    public function setReservaId( $i_ReservaId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_ReservaId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo ReservaId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReservaId( $i_ReservaId );
        return true;
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo IdSucursal */
    public function setIdSucursal( $i_IdSucursal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSucursal, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSucursal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSucursal( $i_IdSucursal );
        return true;
    }

    /* Valida y establece el valor del campo IdAlmacen */
    public function setIdAlmacen( $s_IdAlmacen, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdAlmacen, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdAlmacen ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdAlmacen( $s_IdAlmacen );
        return true;
    }

    /* Valida y establece el valor del campo IdItem */
    public function setIdItem( $s_IdItem, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdItem, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo IdItem ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdItem( $s_IdItem );
        return true;
    }

    /* Valida y establece el valor del campo IdLote */
    public function setIdLote( $s_IdLote, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdLote, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo IdLote ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdLote( $s_IdLote );
        return true;
    }

    /* Valida y establece el valor del campo TipoOperacion */
    public function setTipoOperacion( $s_TipoOperacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoOperacion, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo TipoOperacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoOperacion( $s_TipoOperacion );
        return true;
    }

    /* Valida y establece el valor del campo ReservaDocTipo */
    public function setReservaDocTipo( $s_ReservaDocTipo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReservaDocTipo, "VARCHAR", 5, 0, false ) )
            {
                throw new Exception( "El campo ReservaDocTipo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReservaDocTipo( $s_ReservaDocTipo );
        return true;
    }

    /* Valida y establece el valor del campo ReservaDocNumero */
    public function setReservaDocNumero( $s_ReservaDocNumero, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReservaDocNumero, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo ReservaDocNumero ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReservaDocNumero( $s_ReservaDocNumero );
        return true;
    }

    /* Valida y establece el valor del campo ReservaRefNumero */
    public function setReservaRefNumero( $s_ReservaRefNumero, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReservaRefNumero, "VARCHAR", 45, 0, false ) )
            {
                throw new Exception( "El campo ReservaRefNumero ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReservaRefNumero( $s_ReservaRefNumero );
        return true;
    }

    /* Valida y establece el valor del campo ReservaSecuencia */
    public function setReservaSecuencia( $i_ReservaSecuencia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_ReservaSecuencia, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo ReservaSecuencia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReservaSecuencia( $i_ReservaSecuencia );
        return true;
    }

    /* Valida y establece el valor del campo ReservaCantidad */
    public function setReservaCantidad( $f_ReservaCantidad, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_ReservaCantidad, "DECIMAL", 16, 2, false ) )
            {
                throw new Exception( "El campo ReservaCantidad ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReservaCantidad( $f_ReservaCantidad );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioActualizacion */
    public function setUsuarioActualizacion( $s_UsuarioActualizacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioActualizacion, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo UsuarioActualizacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioActualizacion( $s_UsuarioActualizacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaActualizacion */
    public function setFechaActualizacion( $d_FechaActualizacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaActualizacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaActualizacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaActualizacion( $d_FechaActualizacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setReservaId( $this->getReservaId(), false );
        $this->setIdCompania( $this->getIdCompania(), true );
        $this->setIdSucursal( $this->getIdSucursal(), true );
        $this->setIdAlmacen( $this->getIdAlmacen(), true );
        $this->setIdItem( $this->getIdItem(), true );
        $this->setIdLote( $this->getIdLote(), true );
        $this->setTipoOperacion( $this->getTipoOperacion(), true );
        $this->setReservaDocTipo( $this->getReservaDocTipo(), true );
        $this->setReservaDocNumero( $this->getReservaDocNumero(), true );
        $this->setReservaRefNumero( $this->getReservaRefNumero(), true );
        $this->setReservaSecuencia( $this->getReservaSecuencia(), true );
        $this->setReservaCantidad( $this->getReservaCantidad(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioActualizacion( $this->getUsuarioActualizacion(), true );
        $this->setFechaActualizacion( $this->getFechaActualizacion(), true );
        return true;
    }
}
?>