<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_RequerimientoDetalleLog.xml */
/* Generado: 2021-11-05 04:08:06 */

/* Validacion del contenido de los campos campos de la tabla ALM_RequerimientoDetalleLog */
abstract class BaseALM_RequerimientoDetalleLogBV extends ALM_RequerimientoDetalleLogBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdRequerimientoLog */
    public function setIdRequerimientoLog( $i_IdRequerimientoLog, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdRequerimientoLog, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdRequerimientoLog ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdRequerimientoLog( $i_IdRequerimientoLog );
        return true;
    }

    /* Valida y establece el valor del campo Tipo */
    public function setTipo( $s_Tipo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Tipo, "VARCHAR", 5, 0, false ) )
            {
                throw new Exception( "El campo Tipo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipo( $s_Tipo );
        return true;
    }

    /* Valida y establece el valor del campo idRequerimiento */
    public function setIdRequerimiento( $i_IdRequerimiento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdRequerimiento, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo idRequerimiento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdRequerimiento( $i_IdRequerimiento );
        return true;
    }

    /* Valida y establece el valor del campo IdRequerimientoDetalle */
    public function setIdRequerimientoDetalle( $i_IdRequerimientoDetalle, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdRequerimientoDetalle, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdRequerimientoDetalle ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdRequerimientoDetalle( $i_IdRequerimientoDetalle );
        return true;
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo IdSucursal */
    public function setIdSucursal( $i_IdSucursal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSucursal, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSucursal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSucursal( $i_IdSucursal );
        return true;
    }

    /* Valida y establece el valor del campo IdMoneda */
    public function setIdMoneda( $s_IdMoneda, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdMoneda, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo IdMoneda ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdMoneda( $s_IdMoneda );
        return true;
    }

    /* Valida y establece el valor del campo IdPersona */
    public function setIdPersona( $i_IdPersona, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdPersona, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdPersona ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdPersona( $i_IdPersona );
        return true;
    }

    /* Valida y establece el valor del campo IdItem */
    public function setIdItem( $s_IdItem, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdItem, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo IdItem ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdItem( $s_IdItem );
        return true;
    }

    /* Valida y establece el valor del campo Cantidad */
    public function setCantidad( $f_Cantidad, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_Cantidad, "DECIMAL", 10, 4, false ) )
            {
                throw new Exception( "El campo Cantidad ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCantidad( $f_Cantidad );
        return true;
    }

    /* Valida y establece el valor del campo PrecioUnitario */
    public function setPrecioUnitario( $f_PrecioUnitario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioUnitario, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioUnitario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioUnitario( $f_PrecioUnitario );
        return true;
    }

    /* Valida y establece el valor del campo PrecioUnitarioMN */
    public function setPrecioUnitarioMN( $f_PrecioUnitarioMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioUnitarioMN, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioUnitarioMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioUnitarioMN( $f_PrecioUnitarioMN );
        return true;
    }

    /* Valida y establece el valor del campo PrecioUnitarioME */
    public function setPrecioUnitarioME( $f_PrecioUnitarioME, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioUnitarioME, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioUnitarioME ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioUnitarioME( $f_PrecioUnitarioME );
        return true;
    }

    /* Valida y establece el valor del campo PrecioUnitarioIGV */
    public function setPrecioUnitarioIGV( $f_PrecioUnitarioIGV, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioUnitarioIGV, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioUnitarioIGV ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioUnitarioIGV( $f_PrecioUnitarioIGV );
        return true;
    }

    /* Valida y establece el valor del campo PrecioUnitarioIGVMN */
    public function setPrecioUnitarioIGVMN( $f_PrecioUnitarioIGVMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioUnitarioIGVMN, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioUnitarioIGVMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioUnitarioIGVMN( $f_PrecioUnitarioIGVMN );
        return true;
    }

    /* Valida y establece el valor del campo PrecioUnitarioIGVME */
    public function setPrecioUnitarioIGVME( $f_PrecioUnitarioIGVME, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioUnitarioIGVME, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioUnitarioIGVME ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioUnitarioIGVME( $f_PrecioUnitarioIGVME );
        return true;
    }

    /* Valida y establece el valor del campo TipoCambio */
    public function setTipoCambio( $f_TipoCambio, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_TipoCambio, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo TipoCambio ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoCambio( $f_TipoCambio );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdRequerimientoLog( $this->getIdRequerimientoLog(), false );
        $this->setTipo( $this->getTipo(), true );
        $this->setIdRequerimiento( $this->getIdRequerimiento(), true );
        $this->setIdRequerimientoDetalle( $this->getIdRequerimientoDetalle(), true );
        $this->setIdCompania( $this->getIdCompania(), true );
        $this->setIdSucursal( $this->getIdSucursal(), true );
        $this->setIdMoneda( $this->getIdMoneda(), true );
        $this->setIdPersona( $this->getIdPersona(), true );
        $this->setIdItem( $this->getIdItem(), true );
        $this->setCantidad( $this->getCantidad(), true );
        $this->setPrecioUnitario( $this->getPrecioUnitario(), true );
        $this->setPrecioUnitarioMN( $this->getPrecioUnitarioMN(), true );
        $this->setPrecioUnitarioME( $this->getPrecioUnitarioME(), true );
        $this->setPrecioUnitarioIGV( $this->getPrecioUnitarioIGV(), true );
        $this->setPrecioUnitarioIGVMN( $this->getPrecioUnitarioIGVMN(), true );
        $this->setPrecioUnitarioIGVME( $this->getPrecioUnitarioIGVME(), true );
        $this->setTipoCambio( $this->getTipoCambio(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        return true;
    }
}
?>