<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_Lote.xml */
/* Generado: 2021-11-07 23:55:52 */

/* Validacion del contenido de los campos campos de la tabla ALM_Lote */
abstract class BaseALM_LoteBV extends ALM_LoteBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdLote */
    public function setIdLote( $i_IdLote, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdLote, "INT", 10, 0, false ) )
            {
                throw new Exception( "El campo IdLote ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdLote( $i_IdLote );
        return true;
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 10, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo IdSucursal */
    public function setIdSucursal( $i_IdSucursal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSucursal, "INT", 10, 0, false ) )
            {
                throw new Exception( "El campo IdSucursal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSucursal( $i_IdSucursal );
        return true;
    }

    /* Valida y establece el valor del campo IdItem */
    public function setIdItem( $s_IdItem, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdItem, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo IdItem ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdItem( $s_IdItem );
        return true;
    }

    /* Valida y establece el valor del campo ProductoDescripcion */
    public function setProductoDescripcion( $s_ProductoDescripcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ProductoDescripcion, "VARCHAR", 500, 0, false ) )
            {
                throw new Exception( "El campo ProductoDescripcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setProductoDescripcion( $s_ProductoDescripcion );
        return true;
    }

    /* Valida y establece el valor del campo LoteNumero */
    public function setLoteNumero( $s_LoteNumero, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_LoteNumero, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo LoteNumero ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setLoteNumero( $s_LoteNumero );
        return true;
    }

    /* Valida y establece el valor del campo FechaVencimiento */
    public function setFechaVencimiento( $d_FechaVencimiento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaVencimiento, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaVencimiento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaVencimiento( $d_FechaVencimiento );
        return true;
    }

    /* Valida y establece el valor del campo FechaOrigen */
    public function setFechaOrigen( $d_FechaOrigen, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaOrigen, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaOrigen ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaOrigen( $d_FechaOrigen );
        return true;
    }

    /* Valida y establece el valor del campo Descripcion */
    public function setDescripcion( $s_Descripcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Descripcion, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo Descripcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcion( $s_Descripcion );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo ProveedorId */
    public function setProveedorId( $i_ProveedorId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_ProveedorId, "INT", 10, 0, false ) )
            {
                throw new Exception( "El campo ProveedorId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setProveedorId( $i_ProveedorId );
        return true;
    }

    /* Valida y establece el valor del campo ProveedorNombre */
    public function setProveedorNombre( $s_ProveedorNombre, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ProveedorNombre, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo ProveedorNombre ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setProveedorNombre( $s_ProveedorNombre );
        return true;
    }

    /* Valida y establece el valor del campo LoteNumeroProveedor */
    public function setLoteNumeroProveedor( $s_LoteNumeroProveedor, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_LoteNumeroProveedor, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo LoteNumeroProveedor ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setLoteNumeroProveedor( $s_LoteNumeroProveedor );
        return true;
    }

    /* Valida y establece el valor del campo Anio */
    public function setAnio( $s_Anio, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Anio, "VARCHAR", 4, 0, false ) )
            {
                throw new Exception( "El campo Anio ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAnio( $s_Anio );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdLote( $this->getIdLote(), false );
        $this->setIdCompania( $this->getIdCompania(), true );
        $this->setIdSucursal( $this->getIdSucursal(), true );
        $this->setIdItem( $this->getIdItem(), true );
        $this->setProductoDescripcion( $this->getProductoDescripcion(), true );
        $this->setLoteNumero( $this->getLoteNumero(), true );
        $this->setFechaVencimiento( $this->getFechaVencimiento(), true );
        $this->setFechaOrigen( $this->getFechaOrigen(), true );
        $this->setDescripcion( $this->getDescripcion(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setProveedorId( $this->getProveedorId(), true );
        $this->setProveedorNombre( $this->getProveedorNombre(), true );
        $this->setLoteNumeroProveedor( $this->getLoteNumeroProveedor(), true );
        $this->setAnio( $this->getAnio(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        return true;
    }
}
?>