<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_ItemTipo.xml */
/* Generado: 2020-08-18 04:21:24 */

/* Validacion del contenido de los campos campos de la tabla ALM_ItemTipo */
abstract class BaseALM_ItemTipoBV extends ALM_ItemTipoBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdItemTipo */
    public function setIdItemTipo( $s_IdItemTipo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdItemTipo, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo IdItemTipo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdItemTipo( $s_IdItemTipo );
        return true;
    }

    /* Valida y establece el valor del campo DescripcionLocal */
    public function setDescripcionLocal( $s_DescripcionLocal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DescripcionLocal, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo DescripcionLocal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcionLocal( $s_DescripcionLocal );
        return true;
    }

    /* Valida y establece el valor del campo DescripcionIngles */
    public function setDescripcionIngles( $s_DescripcionIngles, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DescripcionIngles, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo DescripcionIngles ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcionIngles( $s_DescripcionIngles );
        return true;
    }

    /* Valida y establece el valor del campo CodigoSunat */
    public function setCodigoSunat( $s_CodigoSunat, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CodigoSunat, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo CodigoSunat ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCodigoSunat( $s_CodigoSunat );
        return true;
    }

    /* Valida y establece el valor del campo CuentaMayor */
    public function setCuentaMayor( $s_CuentaMayor, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CuentaMayor, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo CuentaMayor ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCuentaMayor( $s_CuentaMayor );
        return true;
    }

    /* Valida y establece el valor del campo IngenieriaFlag */
    public function setIngenieriaFlag( $s_IngenieriaFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IngenieriaFlag, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo IngenieriaFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIngenieriaFlag( $s_IngenieriaFlag );
        return true;
    }

    /* Valida y establece el valor del campo TransacciondelSistemaFlag */
    public function setTransacciondelSistemaFlag( $s_TransacciondelSistemaFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TransacciondelSistemaFlag, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo TransacciondelSistemaFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTransacciondelSistemaFlag( $s_TransacciondelSistemaFlag );
        return true;
    }

    /* Valida y establece el valor del campo MateriaPrimaFlag */
    public function setMateriaPrimaFlag( $s_MateriaPrimaFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_MateriaPrimaFlag, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo MateriaPrimaFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMateriaPrimaFlag( $s_MateriaPrimaFlag );
        return true;
    }

    /* Valida y establece el valor del campo VerDiaSemanaFlag */
    public function setVerDiaSemanaFlag( $s_VerDiaSemanaFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_VerDiaSemanaFlag, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo VerDiaSemanaFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setVerDiaSemanaFlag( $s_VerDiaSemanaFlag );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdItemTipo( $this->getIdItemTipo(), false );
        $this->setDescripcionLocal( $this->getDescripcionLocal(), true );
        $this->setDescripcionIngles( $this->getDescripcionIngles(), true );
        $this->setCodigoSunat( $this->getCodigoSunat(), true );
        $this->setCuentaMayor( $this->getCuentaMayor(), true );
        $this->setIngenieriaFlag( $this->getIngenieriaFlag(), true );
        $this->setTransacciondelSistemaFlag( $this->getTransacciondelSistemaFlag(), true );
        $this->setMateriaPrimaFlag( $this->getMateriaPrimaFlag(), true );
        $this->setVerDiaSemanaFlag( $this->getVerDiaSemanaFlag(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        return true;
    }
}
?>