<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_ItemAlmacen.xml */
/* Generado: 2020-08-18 04:21:24 */

/* Validacion del contenido de los campos campos de la tabla ALM_ItemAlmacen */
abstract class BaseALM_ItemAlmacenBV extends ALM_ItemAlmacenBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo IdItem */
    public function setIdItem( $s_IdItem, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdItem, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo IdItem ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdItem( $s_IdItem );
        return true;
    }

    /* Valida y establece el valor del campo IdAlmacen */
    public function setIdAlmacen( $s_IdAlmacen, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdAlmacen, "CHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdAlmacen ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdAlmacen( $s_IdAlmacen );
        return true;
    }

    /* Valida y establece el valor del campo IdCondicion */
    public function setIdCondicion( $s_IdCondicion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdCondicion, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo IdCondicion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCondicion( $s_IdCondicion );
        return true;
    }

    /* Valida y establece el valor del campo UbicacionFisica */
    public function setUbicacionFisica( $s_UbicacionFisica, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UbicacionFisica, "VARCHAR", 15, 0, false ) )
            {
                throw new Exception( "El campo UbicacionFisica ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUbicacionFisica( $s_UbicacionFisica );
        return true;
    }

    /* Valida y establece el valor del campo UbicacionFisica02 */
    public function setUbicacionFisica02( $s_UbicacionFisica02, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UbicacionFisica02, "VARCHAR", 15, 0, false ) )
            {
                throw new Exception( "El campo UbicacionFisica02 ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUbicacionFisica02( $s_UbicacionFisica02 );
        return true;
    }

    /* Valida y establece el valor del campo UbicacionFisica03 */
    public function setUbicacionFisica03( $s_UbicacionFisica03, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UbicacionFisica03, "VARCHAR", 15, 0, false ) )
            {
                throw new Exception( "El campo UbicacionFisica03 ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUbicacionFisica03( $s_UbicacionFisica03 );
        return true;
    }

    /* Valida y establece el valor del campo StockPedido */
    public function setStockPedido( $i_StockPedido, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_StockPedido, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo StockPedido ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setStockPedido( $i_StockPedido );
        return true;
    }

    /* Valida y establece el valor del campo StockMinimo */
    public function setStockMinimo( $i_StockMinimo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_StockMinimo, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo StockMinimo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setStockMinimo( $i_StockMinimo );
        return true;
    }

    /* Valida y establece el valor del campo StockMaximo */
    public function setStockMaximo( $i_StockMaximo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_StockMaximo, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo StockMaximo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setStockMaximo( $i_StockMaximo );
        return true;
    }

    /* Valida y establece el valor del campo StockPuntoReorden */
    public function setStockPuntoReorden( $i_StockPuntoReorden, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_StockPuntoReorden, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo StockPuntoReorden ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setStockPuntoReorden( $i_StockPuntoReorden );
        return true;
    }

    /* Valida y establece el valor del campo TiempoEspera */
    public function setTiempoEspera( $i_TiempoEspera, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_TiempoEspera, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo TiempoEspera ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTiempoEspera( $i_TiempoEspera );
        return true;
    }

    /* Valida y establece el valor del campo ValidacionPedidoComercialFlag */
    public function setValidacionPedidoComercialFlag( $s_ValidacionPedidoComercialFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ValidacionPedidoComercialFlag, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo ValidacionPedidoComercialFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setValidacionPedidoComercialFlag( $s_ValidacionPedidoComercialFlag );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdCompania( $this->getIdCompania(), false );
        $this->setIdItem( $this->getIdItem(), false );
        $this->setIdAlmacen( $this->getIdAlmacen(), false );
        $this->setIdCondicion( $this->getIdCondicion(), false );
        $this->setUbicacionFisica( $this->getUbicacionFisica(), true );
        $this->setUbicacionFisica02( $this->getUbicacionFisica02(), true );
        $this->setUbicacionFisica03( $this->getUbicacionFisica03(), true );
        $this->setStockPedido( $this->getStockPedido(), true );
        $this->setStockMinimo( $this->getStockMinimo(), true );
        $this->setStockMaximo( $this->getStockMaximo(), true );
        $this->setStockPuntoReorden( $this->getStockPuntoReorden(), true );
        $this->setTiempoEspera( $this->getTiempoEspera(), true );
        $this->setValidacionPedidoComercialFlag( $this->getValidacionPedidoComercialFlag(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        return true;
    }
}
?>