<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_InventarioFisicoPesaje.xml */
/* Generado: 2020-08-18 04:21:24 */

/* Validacion del contenido de los campos campos de la tabla ALM_InventarioFisicoPesaje */
abstract class BaseALM_InventarioFisicoPesajeBV extends ALM_InventarioFisicoPesajeBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo IdNumeroInventario */
    public function setIdNumeroInventario( $s_IdNumeroInventario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdNumeroInventario, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdNumeroInventario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdNumeroInventario( $s_IdNumeroInventario );
        return true;
    }

    /* Valida y establece el valor del campo IdSecuencia */
    public function setIdSecuencia( $i_IdSecuencia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSecuencia, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSecuencia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSecuencia( $i_IdSecuencia );
        return true;
    }

    /* Valida y establece el valor del campo IdPesaje */
    public function setIdPesaje( $i_IdPesaje, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdPesaje, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdPesaje ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdPesaje( $i_IdPesaje );
        return true;
    }

    /* Valida y establece el valor del campo StockFisico */
    public function setStockFisico( $f_StockFisico, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_StockFisico, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo StockFisico ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setStockFisico( $f_StockFisico );
        return true;
    }

    /* Valida y establece el valor del campo StockUnidades */
    public function setStockUnidades( $i_StockUnidades, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_StockUnidades, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo StockUnidades ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setStockUnidades( $i_StockUnidades );
        return true;
    }

    /* Valida y establece el valor del campo IdAlmacenDestino */
    public function setIdAlmacenDestino( $s_IdAlmacenDestino, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdAlmacenDestino, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdAlmacenDestino ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdAlmacenDestino( $s_IdAlmacenDestino );
        return true;
    }

    /* Valida y establece el valor del campo IdItemDestino */
    public function setIdItemDestino( $s_IdItemDestino, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdItemDestino, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo IdItemDestino ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdItemDestino( $s_IdItemDestino );
        return true;
    }

    /* Valida y establece el valor del campo IdUnidad */
    public function setIdUnidad( $s_IdUnidad, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdUnidad, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo IdUnidad ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdUnidad( $s_IdUnidad );
        return true;
    }

    /* Valida y establece el valor del campo IdTipoDocumentoRef */
    public function setIdTipoDocumentoRef( $s_IdTipoDocumentoRef, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdTipoDocumentoRef, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo IdTipoDocumentoRef ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTipoDocumentoRef( $s_IdTipoDocumentoRef );
        return true;
    }

    /* Valida y establece el valor del campo IdNumeroDocumentoRef */
    public function setIdNumeroDocumentoRef( $s_IdNumeroDocumentoRef, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdNumeroDocumentoRef, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdNumeroDocumentoRef ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdNumeroDocumentoRef( $s_IdNumeroDocumentoRef );
        return true;
    }

    /* Valida y establece el valor del campo IdSecuenciaRef */
    public function setIdSecuenciaRef( $i_IdSecuenciaRef, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSecuenciaRef, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSecuenciaRef ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSecuenciaRef( $i_IdSecuenciaRef );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo Longitud */
    public function setLongitud( $f_Longitud, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_Longitud, "DECIMAL", 10, 2, false ) )
            {
                throw new Exception( "El campo Longitud ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setLongitud( $f_Longitud );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdCompania( $this->getIdCompania(), false );
        $this->setIdNumeroInventario( $this->getIdNumeroInventario(), false );
        $this->setIdSecuencia( $this->getIdSecuencia(), false );
        $this->setIdPesaje( $this->getIdPesaje(), false );
        $this->setStockFisico( $this->getStockFisico(), true );
        $this->setStockUnidades( $this->getStockUnidades(), true );
        $this->setIdAlmacenDestino( $this->getIdAlmacenDestino(), true );
        $this->setIdItemDestino( $this->getIdItemDestino(), true );
        $this->setIdUnidad( $this->getIdUnidad(), true );
        $this->setIdTipoDocumentoRef( $this->getIdTipoDocumentoRef(), true );
        $this->setIdNumeroDocumentoRef( $this->getIdNumeroDocumentoRef(), true );
        $this->setIdSecuenciaRef( $this->getIdSecuenciaRef(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setLongitud( $this->getLongitud(), true );
        return true;
    }
}
?>