<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_InventarioFisicoDetalle.xml */
/* Generado: 2020-08-18 04:21:23 */

/* Validacion del contenido de los campos campos de la tabla ALM_InventarioFisicoDetalle */
abstract class BaseALM_InventarioFisicoDetalleBV extends ALM_InventarioFisicoDetalleBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo IdNumeroInventario */
    public function setIdNumeroInventario( $s_IdNumeroInventario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdNumeroInventario, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdNumeroInventario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdNumeroInventario( $s_IdNumeroInventario );
        return true;
    }

    /* Valida y establece el valor del campo IdSecuencia */
    public function setIdSecuencia( $i_IdSecuencia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSecuencia, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSecuencia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSecuencia( $i_IdSecuencia );
        return true;
    }

    /* Valida y establece el valor del campo IdAlmacen */
    public function setIdAlmacen( $s_IdAlmacen, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdAlmacen, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdAlmacen ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdAlmacen( $s_IdAlmacen );
        return true;
    }

    /* Valida y establece el valor del campo IdItem */
    public function setIdItem( $s_IdItem, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdItem, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo IdItem ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdItem( $s_IdItem );
        return true;
    }

    /* Valida y establece el valor del campo IdUnidad */
    public function setIdUnidad( $s_IdUnidad, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdUnidad, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo IdUnidad ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdUnidad( $s_IdUnidad );
        return true;
    }

    /* Valida y establece el valor del campo IdCondicion */
    public function setIdCondicion( $s_IdCondicion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdCondicion, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo IdCondicion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCondicion( $s_IdCondicion );
        return true;
    }

    /* Valida y establece el valor del campo IdLote */
    public function setIdLote( $s_IdLote, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdLote, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo IdLote ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdLote( $s_IdLote );
        return true;
    }

    /* Valida y establece el valor del campo StockActual */
    public function setStockActual( $f_StockActual, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_StockActual, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo StockActual ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setStockActual( $f_StockActual );
        return true;
    }

    /* Valida y establece el valor del campo StockFisico */
    public function setStockFisico( $f_StockFisico, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_StockFisico, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo StockFisico ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setStockFisico( $f_StockFisico );
        return true;
    }

    /* Valida y establece el valor del campo StockDiferencia */
    public function setStockDiferencia( $f_StockDiferencia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_StockDiferencia, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo StockDiferencia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setStockDiferencia( $f_StockDiferencia );
        return true;
    }

    /* Valida y establece el valor del campo PrecioUnitario */
    public function setPrecioUnitario( $f_PrecioUnitario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioUnitario, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioUnitario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioUnitario( $f_PrecioUnitario );
        return true;
    }

    /* Valida y establece el valor del campo MontoTotal */
    public function setMontoTotal( $f_MontoTotal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoTotal, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoTotal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoTotal( $f_MontoTotal );
        return true;
    }

    /* Valida y establece el valor del campo UbicacionFisica */
    public function setUbicacionFisica( $s_UbicacionFisica, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UbicacionFisica, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UbicacionFisica ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUbicacionFisica( $s_UbicacionFisica );
        return true;
    }

    /* Valida y establece el valor del campo TipoOperacion */
    public function setTipoOperacion( $s_TipoOperacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoOperacion, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo TipoOperacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoOperacion( $s_TipoOperacion );
        return true;
    }

    /* Valida y establece el valor del campo IdTipoDocumentoRef */
    public function setIdTipoDocumentoRef( $s_IdTipoDocumentoRef, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdTipoDocumentoRef, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo IdTipoDocumentoRef ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTipoDocumentoRef( $s_IdTipoDocumentoRef );
        return true;
    }

    /* Valida y establece el valor del campo IdNumeroDocumentoRef */
    public function setIdNumeroDocumentoRef( $s_IdNumeroDocumentoRef, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdNumeroDocumentoRef, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdNumeroDocumentoRef ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdNumeroDocumentoRef( $s_IdNumeroDocumentoRef );
        return true;
    }

    /* Valida y establece el valor del campo IdSecuenciaRef */
    public function setIdSecuenciaRef( $i_IdSecuenciaRef, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSecuenciaRef, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSecuenciaRef ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSecuenciaRef( $i_IdSecuenciaRef );
        return true;
    }

    /* Valida y establece el valor del campo MuestraKilos */
    public function setMuestraKilos( $f_MuestraKilos, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MuestraKilos, "DECIMAL", 10, 4, false ) )
            {
                throw new Exception( "El campo MuestraKilos ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMuestraKilos( $f_MuestraKilos );
        return true;
    }

    /* Valida y establece el valor del campo MuestraUnidades */
    public function setMuestraUnidades( $f_MuestraUnidades, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MuestraUnidades, "DECIMAL", 10, 4, false ) )
            {
                throw new Exception( "El campo MuestraUnidades ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMuestraUnidades( $f_MuestraUnidades );
        return true;
    }

    /* Valida y establece el valor del campo MuestraTotalesUnidades */
    public function setMuestraTotalesUnidades( $f_MuestraTotalesUnidades, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MuestraTotalesUnidades, "DECIMAL", 10, 4, false ) )
            {
                throw new Exception( "El campo MuestraTotalesUnidades ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMuestraTotalesUnidades( $f_MuestraTotalesUnidades );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "CHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdCompania( $this->getIdCompania(), false );
        $this->setIdNumeroInventario( $this->getIdNumeroInventario(), false );
        $this->setIdSecuencia( $this->getIdSecuencia(), false );
        $this->setIdAlmacen( $this->getIdAlmacen(), true );
        $this->setIdItem( $this->getIdItem(), true );
        $this->setIdUnidad( $this->getIdUnidad(), true );
        $this->setIdCondicion( $this->getIdCondicion(), true );
        $this->setIdLote( $this->getIdLote(), true );
        $this->setStockActual( $this->getStockActual(), true );
        $this->setStockFisico( $this->getStockFisico(), true );
        $this->setStockDiferencia( $this->getStockDiferencia(), true );
        $this->setPrecioUnitario( $this->getPrecioUnitario(), true );
        $this->setMontoTotal( $this->getMontoTotal(), true );
        $this->setUbicacionFisica( $this->getUbicacionFisica(), true );
        $this->setTipoOperacion( $this->getTipoOperacion(), true );
        $this->setIdTipoDocumentoRef( $this->getIdTipoDocumentoRef(), true );
        $this->setIdNumeroDocumentoRef( $this->getIdNumeroDocumentoRef(), true );
        $this->setIdSecuenciaRef( $this->getIdSecuenciaRef(), true );
        $this->setMuestraKilos( $this->getMuestraKilos(), true );
        $this->setMuestraUnidades( $this->getMuestraUnidades(), true );
        $this->setMuestraTotalesUnidades( $this->getMuestraTotalesUnidades(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        return true;
    }
}
?>