<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_CajaChicaArhivos.xml */
/* Generado: 2020-08-18 04:21:23 */

/* Validacion del contenido de los campos campos de la tabla ALM_CajaChicaArhivos */
abstract class BaseALM_CajaChicaArhivosBV extends ALM_CajaChicaArhivosBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdCajaDet */
    public function setIdCajaDet( $i_IdCajaDet, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCajaDet, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCajaDet ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCajaDet( $i_IdCajaDet );
        return true;
    }

    /* Valida y establece el valor del campo IdSecuencia */
    public function setIdSecuencia( $i_IdSecuencia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSecuencia, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSecuencia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSecuencia( $i_IdSecuencia );
        return true;
    }

    /* Valida y establece el valor del campo Nombre */
    public function setNombre( $s_Nombre, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Nombre, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo Nombre ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNombre( $s_Nombre );
        return true;
    }

    /* Valida y establece el valor del campo Tipo */
    public function setTipo( $s_Tipo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Tipo, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo Tipo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipo( $s_Tipo );
        return true;
    }

    /* Valida y establece el valor del campo TipoCompleto */
    public function setTipoCompleto( $s_TipoCompleto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoCompleto, "VARCHAR", 150, 0, false ) )
            {
                throw new Exception( "El campo TipoCompleto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoCompleto( $s_TipoCompleto );
        return true;
    }

    /* Valida y establece el valor del campo Tamanio */
    public function setTamanio( $i_Tamanio, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_Tamanio, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo Tamanio ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTamanio( $i_Tamanio );
        return true;
    }

    /* Valida y establece el valor del campo UbicacionURL */
    public function setUbicacionURL( $s_UbicacionURL, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UbicacionURL, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo UbicacionURL ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUbicacionURL( $s_UbicacionURL );
        return true;
    }

    /* Valida y establece el valor del campo UbicacionFisica */
    public function setUbicacionFisica( $s_UbicacionFisica, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UbicacionFisica, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo UbicacionFisica ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUbicacionFisica( $s_UbicacionFisica );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdCajaDet( $this->getIdCajaDet(), false );
        $this->setIdSecuencia( $this->getIdSecuencia(), false );
        $this->setNombre( $this->getNombre(), true );
        $this->setTipo( $this->getTipo(), true );
        $this->setTipoCompleto( $this->getTipoCompleto(), true );
        $this->setTamanio( $this->getTamanio(), true );
        $this->setUbicacionURL( $this->getUbicacionURL(), true );
        $this->setUbicacionFisica( $this->getUbicacionFisica(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        return true;
    }
}
?>