<?php
/* Autor...:  */
/* Esquema.: SR_Serie.xml */
/* Generado: 2020-08-18 04:21:31 */

/* Metodos de acceso a los campos de la tabla SR_Serie */
abstract class BaseSR_SerieBN
{
    /* Campos de la tabla */
    private $i_SerieId;    // SerieId: ( no definido )
    private $i_MovimientoId;    // MovimientoId: ( no definido )
    private $s_ProductoId;    // ProductoId: ( no definido )
    private $s_SerieNumero;    // SerieNumero: ( no definido )
    private $s_Almacen;    // Almacen: ( no definido )
    private $s_UltimaOperacion;    // UltimaOperacion: ( no definido )
    private $s_Estado;    // Estado: ( no definido )
    private $s_ReferenciaTipo;    // ReferenciaTipo: ( no definido )
    private $s_ReferenciaNumero;    // ReferenciaNumero: ( no definido )
    private $u_Comentario;    // Comentario: ( no definido )
    private $s_UsuarioRegistro;    // UsuarioRegistro: ( no definido )
    private $d_FechaRegistro;    // FechaRegistro: ( no definido )
    private $s_UsuarioModificacion;    // UsuarioModificacion: ( no definido )
    private $d_FechaModificacion;    // FechaModificacion: ( no definido )

    /* Establece el valor del campo SerieId */
    public function setSerieId( $i_SerieId )
    {
        $this->i_SerieId = $i_SerieId;
    }

    /* Obtiene el valor del campo SerieId */
    public function getSerieId()
    {
        return $this->i_SerieId;
    }

    /* Establece el valor del campo MovimientoId */
    public function setMovimientoId( $i_MovimientoId )
    {
        $this->i_MovimientoId = $i_MovimientoId;
    }

    /* Obtiene el valor del campo MovimientoId */
    public function getMovimientoId()
    {
        return $this->i_MovimientoId;
    }

    /* Establece el valor del campo ProductoId */
    public function setProductoId( $s_ProductoId )
    {
        $this->s_ProductoId = $s_ProductoId;
    }

    /* Obtiene el valor del campo ProductoId */
    public function getProductoId()
    {
        return $this->s_ProductoId;
    }

    /* Establece el valor del campo SerieNumero */
    public function setSerieNumero( $s_SerieNumero )
    {
        $this->s_SerieNumero = $s_SerieNumero;
    }

    /* Obtiene el valor del campo SerieNumero */
    public function getSerieNumero()
    {
        return $this->s_SerieNumero;
    }

    /* Establece el valor del campo Almacen */
    public function setAlmacen( $s_Almacen )
    {
        $this->s_Almacen = $s_Almacen;
    }

    /* Obtiene el valor del campo Almacen */
    public function getAlmacen()
    {
        return $this->s_Almacen;
    }

    /* Establece el valor del campo UltimaOperacion */
    public function setUltimaOperacion( $s_UltimaOperacion )
    {
        $this->s_UltimaOperacion = $s_UltimaOperacion;
    }

    /* Obtiene el valor del campo UltimaOperacion */
    public function getUltimaOperacion()
    {
        return $this->s_UltimaOperacion;
    }

    /* Establece el valor del campo Estado */
    public function setEstado( $s_Estado )
    {
        $this->s_Estado = $s_Estado;
    }

    /* Obtiene el valor del campo Estado */
    public function getEstado()
    {
        return $this->s_Estado;
    }

    /* Establece el valor del campo ReferenciaTipo */
    public function setReferenciaTipo( $s_ReferenciaTipo )
    {
        $this->s_ReferenciaTipo = $s_ReferenciaTipo;
    }

    /* Obtiene el valor del campo ReferenciaTipo */
    public function getReferenciaTipo()
    {
        return $this->s_ReferenciaTipo;
    }

    /* Establece el valor del campo ReferenciaNumero */
    public function setReferenciaNumero( $s_ReferenciaNumero )
    {
        $this->s_ReferenciaNumero = $s_ReferenciaNumero;
    }

    /* Obtiene el valor del campo ReferenciaNumero */
    public function getReferenciaNumero()
    {
        return $this->s_ReferenciaNumero;
    }

    /* Establece el valor del campo Comentario */
    public function setComentario( $u_Comentario )
    {
        $this->u_Comentario = $u_Comentario;
    }

    /* Obtiene el valor del campo Comentario */
    public function getComentario()
    {
        return $this->u_Comentario;
    }

    /* Establece el valor del campo UsuarioRegistro */
    public function setUsuarioRegistro( $s_UsuarioRegistro )
    {
        $this->s_UsuarioRegistro = $s_UsuarioRegistro;
    }

    /* Obtiene el valor del campo UsuarioRegistro */
    public function getUsuarioRegistro()
    {
        return $this->s_UsuarioRegistro;
    }

    /* Establece el valor del campo FechaRegistro */
    public function setFechaRegistro( $d_FechaRegistro )
    {
        $this->d_FechaRegistro = $d_FechaRegistro;
    }

    /* Obtiene el valor del campo FechaRegistro */
    public function getFechaRegistro()
    {
        return $this->d_FechaRegistro;
    }

    /* Establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion )
    {
        $this->s_UsuarioModificacion = $s_UsuarioModificacion;
    }

    /* Obtiene el valor del campo UsuarioModificacion */
    public function getUsuarioModificacion()
    {
        return $this->s_UsuarioModificacion;
    }

    /* Establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion )
    {
        $this->d_FechaModificacion = $d_FechaModificacion;
    }

    /* Obtiene el valor del campo FechaModificacion */
    public function getFechaModificacion()
    {
        return $this->d_FechaModificacion;
    }

    public function getJsonSerialize()
    {
        return 
        [
            'SerieId' => $this->getSerieId(),
            'MovimientoId' => $this->getMovimientoId(),
            'ProductoId' => $this->getProductoId(),
            'SerieNumero' => $this->getSerieNumero(),
            'Almacen' => $this->getAlmacen(),
            'UltimaOperacion' => $this->getUltimaOperacion(),
            'Estado' => $this->getEstado(),
            'ReferenciaTipo' => $this->getReferenciaTipo(),
            'ReferenciaNumero' => $this->getReferenciaNumero(),
            'Comentario' => $this->getComentario(),
            'UsuarioRegistro' => $this->getUsuarioRegistro(),
            'FechaRegistro' => $this->getFechaRegistro(),
            'UsuarioModificacion' => $this->getUsuarioModificacion(),
            'FechaModificacion' => $this->getFechaModificacion(),
        ];
    }

    public function toArray()
    {
        return $this->processArray( get_object_vars( $this ) ); 
    }

    private function processArray( $array )
    {
        foreach( $array as $key => $value ) 
        {
            if ( is_object( $value ) )
            {
                $array[$key] = $value->toArray();
            }
            if ( is_array( $value ) ) 
            {
                $array[$key] = $this->processArray( $value );
            }
        }
        return $array;
    }

    public function __toString()
    {
        return json_encode( $this->toArray() ); 
    }

    /* Recupera un objeto SR_SerieBN desde un RecordSet */
    public static function retrieveByRs( $o_SR_SerieRs )
    {
        $o_SR_SerieBN = new SR_SerieBN();
        $o_SR_SerieBN->setSerieId( ( integer ) $o_SR_SerieRs[ "SerieId" ] );
        $o_SR_SerieBN->setMovimientoId( ( integer ) $o_SR_SerieRs[ "MovimientoId" ] );
        $o_SR_SerieBN->setProductoId( $o_SR_SerieRs[ "ProductoId" ] );
        $o_SR_SerieBN->setSerieNumero( $o_SR_SerieRs[ "SerieNumero" ] );
        $o_SR_SerieBN->setAlmacen( $o_SR_SerieRs[ "Almacen" ] );
        $o_SR_SerieBN->setUltimaOperacion( $o_SR_SerieRs[ "UltimaOperacion" ] );
        $o_SR_SerieBN->setEstado( $o_SR_SerieRs[ "Estado" ] );
        $o_SR_SerieBN->setReferenciaTipo( $o_SR_SerieRs[ "ReferenciaTipo" ] );
        $o_SR_SerieBN->setReferenciaNumero( $o_SR_SerieRs[ "ReferenciaNumero" ] );
        $o_SR_SerieBN->setComentario( $o_SR_SerieRs[ "Comentario" ] );
        $o_SR_SerieBN->setUsuarioRegistro( $o_SR_SerieRs[ "UsuarioRegistro" ] );
        $o_SR_SerieBN->setFechaRegistro( utilTimestamp::getTimestamp( $o_SR_SerieRs[ "FechaRegistro" ], "Y-m-d H:i:s" ) );
        $o_SR_SerieBN->setUsuarioModificacion( $o_SR_SerieRs[ "UsuarioModificacion" ] );
        $o_SR_SerieBN->setFechaModificacion( utilTimestamp::getTimestamp( $o_SR_SerieRs[ "FechaModificacion" ], "Y-m-d H:i:s" ) );
        return $o_SR_SerieBN;
    }
}
?>